/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.generator;

import com.tridium.slottool.JavaUnit;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.generator.CodeGenerator;
import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.mode.SlotMode;
import com.tridium.slottool.model.BajaUnit;
import java.time.Year;
import java.util.Date;

public class SlotGenerator
extends CodeGenerator {
    private SlotMode slotMode;
    private final JavaUnit javaUnit;

    public SlotGenerator(SlotomaticOptions slotomaticOptions, JavaUnit unit) {
        this(slotomaticOptions, unit.getBajaUnit(), unit);
    }

    public SlotGenerator(SlotomaticOptions slotomaticOptions, BajaUnit bajaUnit, JavaUnit javaUnit) {
        super(slotomaticOptions, bajaUnit);
        this.javaUnit = javaUnit;
    }

    @Override
    protected void generate() {
        this.initMode(this.unit, this.cb);
        this.cb.println("//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/");
        this.cb.println("//@formatter:off");
        this.header(this.cb);
        this.cb.indent();
        this.slotMode.header();
        if (this.unit.isEnum()) {
            this.slotMode.enumBlock();
        } else {
            this.slotMode.propertyBlock();
            this.slotMode.actionBlock();
            this.slotMode.topicBlock();
            if (this.unit.isSingleton()) {
                this.slotMode.singleton();
            }
        }
        this.slotMode.typeDeclaration();
        this.slotMode.footer();
        this.cb.outdent();
        this.cb.println();
        this.cb.println("//@formatter:on");
        this.cb.print("//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/");
    }

    private void header(GeneratedCodeBlock cb) {
        String dateLine = null;
        if (this.slotomaticOptions.isPreserveDate() && !this.javaUnit.isSlotCodeOutOfDate()) {
            dateLine = this.javaUnit.getCurrentBajaDateLine();
        }
        if (dateLine == null) {
            dateLine = String.format("/* Generated %s by Slot-o-Matic (c) Tridium, Inc. 2012-%d */", new Date().toString(), Year.now().getValue());
        }
        cb.println(this.javaUnit.getBajaMetadata().asHeader());
        cb.println(dateLine);
    }

    private void initMode(BajaUnit unit, GeneratedCodeBlock cb) {
        String clsName = unit.getMode();
        if (!clsName.contains(".")) {
            clsName = "com.tridium.slottool.mode." + clsName;
        }
        try {
            this.slotMode = (SlotMode)Class.forName(clsName).getDeclaredConstructor(GeneratedCodeBlock.class, BajaUnit.class).newInstance(cb, unit);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

