/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.generator;

import com.github.javaparser.ast.ImportDeclaration;
import java.util.Objects;

public class JavaImport
implements Comparable<JavaImport> {
    private final boolean isStatic;
    private final boolean isOnDemand;
    private final String name;

    public JavaImport(ImportDeclaration importDeclaration) {
        this(importDeclaration.getNameAsString(), importDeclaration.isStatic(), importDeclaration.isAsterisk());
    }

    public JavaImport(String name, boolean isStatic, boolean isOnDemand) {
        this.isStatic = isStatic;
        this.isOnDemand = isOnDemand;
        this.name = name;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isOnDemand() {
        return this.isOnDemand;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        if (this.isOnDemand()) {
            return this.getName();
        }
        int lastDot = this.getName().lastIndexOf(46);
        if (lastDot > 0) {
            return this.getName().substring(0, lastDot);
        }
        return this.getName();
    }

    @Override
    public int compareTo(JavaImport o) {
        int nameCompare = this.name.compareTo(o.name);
        if (nameCompare == 0) {
            if (this.isStatic && !o.isStatic) {
                return -1;
            }
            if (o.isStatic && !this.isStatic) {
                return 1;
            }
            if (this.isOnDemand && !o.isOnDemand) {
                return -1;
            }
            if (o.isOnDemand && !this.isOnDemand) {
                return 1;
            }
        }
        return nameCompare;
    }

    public String asStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("import ");
        if (this.isStatic()) {
            sb.append("static ");
        }
        sb.append(this.name);
        if (this.isOnDemand()) {
            sb.append(".*");
        }
        sb.append(";");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaImport)) {
            return false;
        }
        JavaImport that = (JavaImport)o;
        return this.isStatic() == that.isStatic() && this.isOnDemand() == that.isOnDemand() && this.getName().equals(that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.isStatic(), this.isOnDemand(), this.getName());
    }
}

