/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.generator;

import com.tridium.slottool.Slotomatic;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.model.BajaUnit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class CodeGenerator {
    private static final Set<String> facetKeys = new HashSet<String>();
    protected final BajaUnit unit;
    protected static final Logger log = Slotomatic.getLogger();
    protected final SlotomaticOptions slotomaticOptions;
    protected final GeneratedCodeBlock cb;

    protected CodeGenerator(SlotomaticOptions slotomaticOptions, BajaUnit unit) {
        this.slotomaticOptions = slotomaticOptions;
        this.unit = unit;
        this.cb = new GeneratedCodeBlock(slotomaticOptions.getLineSeparator());
    }

    protected abstract void generate();

    public GeneratedCodeBlock getGeneratedBlock() {
        if (this.cb.isEmpty()) {
            this.generate();
        }
        return this.cb;
    }

    public static String getMethodizedName(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static boolean isFacetKey(String str) {
        if (facetKeys.isEmpty()) {
            String niagaraHome = System.getenv("niagara_home");
            if (niagaraHome == null) {
                log.warning("Missing system property \"niagara_home\"");
                return false;
            }
            File niagaraHomeFile = new File(niagaraHome);
            Properties props = CodeGenerator.loadProperties(new File(niagaraHomeFile, "defaults" + File.separator + "workbench" + File.separator + "facetKeys.properties"));
            facetKeys.addAll(props.keySet().stream().map(key -> CodeGenerator.toFlagName((String)key)).collect(Collectors.toList()));
        }
        return facetKeys.contains(str);
    }

    public static String toFlagName(String fullName) {
        String name;
        StringBuilder buf = new StringBuilder();
        int dotIndex = fullName.indexOf(46);
        if (dotIndex > -1) {
            buf.append(fullName.substring(0, dotIndex));
            name = fullName.substring(dotIndex);
        } else {
            name = fullName;
        }
        int len = name.length();
        char last = '\uffff';
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (Character.isLetter(ch)) {
                if (Character.isLowerCase(ch)) {
                    buf.append(Character.toUpperCase(ch));
                } else {
                    if (last != '_' && Character.isLowerCase(last)) {
                        buf.append('_');
                    }
                    buf.append(ch);
                }
            } else if (Character.isDigit(ch)) {
                if (last != '_' && !Character.isDigit(last) && Character.isLowerCase(last)) {
                    buf.append('_');
                }
                buf.append(ch);
            } else {
                buf.append(ch);
            }
            last = ch;
        }
        return buf.toString();
    }

    public static String trimLeft(String s) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimRight(String s) {
        StringBuilder sb = new StringBuilder(s);
        for (int len = sb.length(); len > 0 && Character.isWhitespace(sb.charAt(len - 1)); --len) {
            sb.deleteCharAt(len - 1);
        }
        return sb.toString();
    }

    private static Properties loadProperties(File propsFile) {
        Properties props;
        block14: {
            props = new Properties();
            try (FileInputStream in = new FileInputStream(propsFile);){
                props.load(in);
            }
            catch (IOException e) {
                if (!log.isLoggable(Level.WARNING)) break block14;
                log.warning("Cannot load properties: " + propsFile);
            }
        }
        return props;
    }
}

