/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool;

import com.tridium.slottool.JavaSource;
import com.tridium.slottool.JavaUnit;
import com.tridium.slottool.Slotomatic;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.generator.SortedImportCodeBlock;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class SourceTransformer {
    protected final SlotomaticOptions slotomaticOptions;
    protected final Logger log = Slotomatic.getLogger();
    protected final JavaUnit javaUnit;
    protected final JavaSource javaSource;

    protected SourceTransformer(SlotomaticOptions slotomaticOptions, JavaUnit javaUnit) {
        this.slotomaticOptions = slotomaticOptions;
        this.javaUnit = javaUnit;
        this.javaSource = new JavaSource(javaUnit.getSource(), slotomaticOptions.getLineSeparator());
    }

    public String transform() {
        this.doTransform();
        String rendered = this.javaSource.render();
        if (!rendered.endsWith(this.slotomaticOptions.getLineSeparator())) {
            return rendered + this.slotomaticOptions.getLineSeparator();
        }
        return rendered;
    }

    protected abstract void doTransform();

    protected void insertImports(GeneratedCodeBlock cb) {
        if (this.slotomaticOptions.isSortImports()) {
            SortedImportCodeBlock importCodeBlock = this.javaUnit.getSortedImports().orElseThrow(() -> new IllegalStateException("JavaUnit was built without sorting enabled"));
            cb.getImports().forEach(importCodeBlock::addImport);
            importCodeBlock.setStartLine(this.javaUnit.getImportBlock().getRange().getEnd() + 1);
            if (this.javaUnit.hasImports()) {
                this.javaSource.addDeletion(this.javaUnit.getImportBlock());
            } else {
                importCodeBlock.setPrefix("");
            }
            this.javaSource.addInsertion(importCodeBlock);
        } else {
            Set imports = cb.getImports().stream().filter(imp -> !this.javaUnit.hasImport((String)imp)).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
            if (!imports.isEmpty()) {
                GeneratedCodeBlock importCb = new GeneratedCodeBlock(this.slotomaticOptions.getLineSeparator());
                for (String imp2 : imports) {
                    importCb.printImport(imp2);
                }
                importCb.trim();
                importCb.setStartLine(this.javaUnit.getImportBlock().getRange().getEnd() + 1);
                if (!this.javaUnit.hasImports()) {
                    importCb.prepend(importCb.getLineSeparator());
                }
                this.javaSource.addInsertion(importCb);
            }
        }
    }
}

