/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gradle.plugins.templates.util;

import com.tridium.gradle.plugins.templates.ModuleRuntimeProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class NiagaraModuleInfo {
    public static final String NIAGARA_MODULE_TAG = "niagara-module";
    public static final String MODULE_PART_TAG = "module-part";
    public static final String MODULE_NAME_ATTR = "moduleName";
    public static final String PREFERRED_SYMBOL_ATTR = "preferredSymbol";
    public static final String RUNTIME_PROFILES_ATTR = "runtimeProfiles";
    public static final String MODULE_PART_NAME_ATTR = "name";
    public static final String RUNTIME_PROFILE_ATTR = "runtimeProfile";
    private String moduleName;
    private String preferredSymbol;
    private final EnumSet<ModuleRuntimeProfile> runtimeProfiles = EnumSet.noneOf(ModuleRuntimeProfile.class);
    private final EnumMap<ModuleRuntimeProfile, String> modulePartNameOverrides = new EnumMap(ModuleRuntimeProfile.class);

    public static NiagaraModuleInfo fromElement(XElem element) {
        if (!NIAGARA_MODULE_TAG.equals(element.name())) {
            throw new IllegalArgumentException("Element '" + element.name() + "' is not a valid module info element");
        }
        NiagaraModuleInfo nmi = new NiagaraModuleInfo();
        nmi.moduleName = element.get(MODULE_NAME_ATTR);
        nmi.preferredSymbol = element.get(PREFERRED_SYMBOL_ATTR);
        for (String string : element.get(RUNTIME_PROFILES_ATTR).split(",")) {
            nmi.runtimeProfiles.add(ModuleRuntimeProfile.valueOf(string));
        }
        for (String string : element.elems(MODULE_PART_TAG)) {
            ModuleRuntimeProfile rtp = ModuleRuntimeProfile.valueOf(string.get(RUNTIME_PROFILE_ATTR));
            String modulePartName = string.get(MODULE_PART_NAME_ATTR);
            if (!nmi.runtimeProfiles.contains((Object)rtp)) {
                throw new IllegalArgumentException("Module part runtime profile '" + (Object)((Object)rtp) + "' not in list of declared runtime profiles");
            }
            nmi.modulePartNameOverrides.put(rtp, modulePartName);
        }
        return nmi;
    }

    public XElem toElement() {
        XElem element = new XElem(NIAGARA_MODULE_TAG);
        element.setAttr(MODULE_NAME_ATTR, this.moduleName);
        element.setAttr(PREFERRED_SYMBOL_ATTR, this.preferredSymbol);
        element.setAttr(RUNTIME_PROFILES_ATTR, this.runtimeProfiles.stream().map(Enum::name).collect(Collectors.joining(",")));
        if (!this.modulePartNameOverrides.isEmpty()) {
            for (Map.Entry<ModuleRuntimeProfile, String> entry : this.modulePartNameOverrides.entrySet()) {
                XElem modulePart = new XElem(MODULE_PART_TAG);
                modulePart.setAttr(MODULE_PART_NAME_ATTR, entry.getValue());
                modulePart.setAttr(RUNTIME_PROFILE_ATTR, entry.getKey().name());
                element.addContent((XContent)modulePart);
            }
        }
        return element;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getPreferredSymbol() {
        return this.preferredSymbol;
    }

    public void setPreferredSymbol(String preferredSymbol) {
        this.preferredSymbol = preferredSymbol;
    }

    public EnumSet<ModuleRuntimeProfile> getRuntimeProfiles() {
        return this.runtimeProfiles;
    }

    public void addRuntimeProfiles(Collection<ModuleRuntimeProfile> runtimeProfiles) {
        this.runtimeProfiles.addAll(runtimeProfiles);
    }

    public void addRuntimeProfiles(ModuleRuntimeProfile ... runtimeProfiles) {
        this.addRuntimeProfiles(Arrays.asList(runtimeProfiles));
    }

    public void addModulePartNameOverride(ModuleRuntimeProfile rtp, String modulePartName) {
        if (!this.runtimeProfiles.contains((Object)rtp)) {
            throw new IllegalArgumentException("Runtime profile '" + (Object)((Object)rtp) + "' not declared for " + this.moduleName);
        }
        this.modulePartNameOverrides.put(rtp, modulePartName);
    }

    public List<String> getModulePartNames() {
        return new LinkedList<String>(this.getModulePartNamesByRuntimeProfile().values());
    }

    public EnumMap<ModuleRuntimeProfile, String> getModulePartNamesByRuntimeProfile() {
        EnumMap<ModuleRuntimeProfile, String> parts = new EnumMap<ModuleRuntimeProfile, String>(ModuleRuntimeProfile.class);
        for (ModuleRuntimeProfile rtp : this.runtimeProfiles) {
            if (this.modulePartNameOverrides.containsKey((Object)rtp)) {
                parts.put(rtp, this.modulePartNameOverrides.get((Object)rtp));
                continue;
            }
            parts.put(rtp, this.moduleName + "-" + (Object)((Object)rtp));
        }
        return parts;
    }
}

