/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gradle.plugins.templates;

import com.tridium.gradle.plugins.templates.Generator;
import com.tridium.gradle.plugins.templates.GradleProjectGenerator;
import com.tridium.gradle.plugins.templates.ModuleRuntimeProfile;
import com.tridium.gradle.plugins.templates.NiagaraModulePartGenerator;
import com.tridium.gradle.plugins.templates.exception.TemplateGenerationException;
import com.tridium.gradle.plugins.templates.util.GeneratorUtils;
import com.tridium.gradle.plugins.templates.util.NiagaraModuleInfo;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.StringJoiner;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class NiagaraModuleGenerator
extends Generator {
    protected final String moduleName;
    protected String preferredSymbol;
    protected final EnumMap<ModuleRuntimeProfile, NiagaraModulePartGenerator> runtimeProfiles = new EnumMap(ModuleRuntimeProfile.class);

    protected NiagaraModuleGenerator(GradleProjectGenerator projectGenerator, String modulePath, String moduleName) {
        super(projectGenerator, modulePath);
        this.preferredSymbol = this.moduleName = moduleName;
        this.context.put("moduleName", (Object)this.moduleName);
    }

    public static NiagaraModuleGenerator make(GradleProjectGenerator projectGenerator, String moduleName) {
        return NiagaraModuleGenerator.make(projectGenerator, moduleName, "");
    }

    public static NiagaraModuleGenerator make(GradleProjectGenerator projectGenerator, String moduleName, String moduleRoot) {
        StringJoiner joiner = new StringJoiner("/");
        if (moduleRoot != null && !moduleRoot.isEmpty()) {
            joiner.add(moduleRoot);
        }
        joiner.add(moduleName);
        String modulePath = joiner.toString();
        return new NiagaraModuleGenerator(projectGenerator, modulePath, moduleName);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setRuntimeProfiles(Collection<ModuleRuntimeProfile> runtimeProfiles) {
        if (!this.runtimeProfiles.isEmpty()) {
            throw new TemplateGenerationException("Cannot change runtime profiles once defined");
        }
        for (ModuleRuntimeProfile runtimeProfile : runtimeProfiles) {
            this.runtimeProfiles.put(runtimeProfile, NiagaraModulePartGenerator.make(this, runtimeProfile));
        }
    }

    public void setRuntimeProfiles(ModuleRuntimeProfile ... runtimeProfiles) {
        this.setRuntimeProfiles(Arrays.asList(runtimeProfiles));
    }

    public NiagaraModulePartGenerator getModulePart(ModuleRuntimeProfile runtimeProfile) {
        return this.runtimeProfiles.get((Object)runtimeProfile);
    }

    public Collection<NiagaraModulePartGenerator> getModuleParts() {
        return this.runtimeProfiles.values();
    }

    public void setDescription(String description) {
        this.context.put("description", (Object)GeneratorUtils.escapeJava(description));
    }

    public void setPreferredSymbol(String preferredSymbol) {
        this.preferredSymbol = preferredSymbol;
        this.context.put("preferredSymbol", (Object)this.preferredSymbol);
    }

    public void generate() {
        this.writeNiagaraModuleFiles();
    }

    void writeNiagaraModuleFiles() {
        File moduleDirectory = this.generator.getBaseDirectory();
        this.context.put("runtimeProfiles", this.runtimeProfiles.keySet());
        NiagaraModuleInfo nmi = this.updateNiagaraModuleXml(moduleDirectory);
        this.context.put("allRuntimeProfiles", nmi.getRuntimeProfiles());
        for (NiagaraModulePartGenerator generator : this.runtimeProfiles.values()) {
            generator.generate();
        }
        this.generateFiles();
    }

    NiagaraModuleInfo updateNiagaraModuleXml(File moduleDirectory) {
        NiagaraModuleInfo niagaraModuleInfo;
        File niagaraModuleInfoXml = new File(moduleDirectory, "niagara-module.xml");
        if (niagaraModuleInfoXml.exists()) {
            XElem root;
            try {
                root = XParser.make((File)niagaraModuleInfoXml).parse();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot parse " + niagaraModuleInfoXml, e);
            }
            niagaraModuleInfo = NiagaraModuleInfo.fromElement(root);
            if (!niagaraModuleInfo.getModuleName().equals(this.moduleName)) {
                throw new TemplateGenerationException(niagaraModuleInfo.getModuleName() + ": existing module name '" + niagaraModuleInfo.getModuleName() + "' does not match provided module name '" + this.moduleName + "'");
            }
            if (!niagaraModuleInfo.getPreferredSymbol().equals(this.preferredSymbol)) {
                throw new TemplateGenerationException(niagaraModuleInfo.getModuleName() + ": existing preferred symbol '" + niagaraModuleInfo.getPreferredSymbol() + "' does not match provided preferred symbol '" + this.preferredSymbol + "'");
            }
            for (ModuleRuntimeProfile rtp : this.runtimeProfiles.keySet()) {
                if (niagaraModuleInfo.getRuntimeProfiles().contains((Object)rtp)) {
                    throw new TemplateGenerationException(niagaraModuleInfo.getModuleName() + ": runtime profile '" + (Object)((Object)rtp) + "' is already defined");
                }
                niagaraModuleInfo.addRuntimeProfiles(rtp);
            }
        } else {
            niagaraModuleInfo = new NiagaraModuleInfo();
            niagaraModuleInfo.setModuleName(this.moduleName);
            niagaraModuleInfo.setPreferredSymbol(this.preferredSymbol);
            niagaraModuleInfo.addRuntimeProfiles(this.runtimeProfiles.keySet());
        }
        try {
            XWriter writer = new XWriter(niagaraModuleInfoXml);
            Object object = null;
            try {
                writer.prolog();
                niagaraModuleInfo.toElement().write(writer);
                writer.flush();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (object != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return niagaraModuleInfo;
    }
}

