/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.util.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RamFile
implements DataInput,
DataOutput {
    private File file;
    private byte[] bytes;
    private int idx;

    public RamFile(File file) throws IOException {
        this.file = file;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            this.bytes = new byte[(int)raf.length()];
            raf.read(this.bytes);
        }
        this.idx = 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.bytes[this.idx++];
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public short readShort() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public char readChar() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public int readInt() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public long readLong() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public float readFloat() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public double readDouble() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public String readLine() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.bytes[this.idx++] = (byte)v;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.writeByte(v ? 1 : 0);
    }

    @Override
    public void writeLong(long v) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeUTF(String str) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeInt(int v) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void write(int b) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void write(byte[] b) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeShort(int v) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeChar(int v) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeFloat(float v) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeDouble(double v) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new IllegalStateException();
    }

    public void seek(long pos) throws IOException {
        this.idx = (int)pos;
    }

    public void close() throws IOException {
        this.bytes = null;
    }

    public long getFilePointer() throws IOException {
        return this.idx;
    }

    public long length() throws IOException {
        return this.bytes.length;
    }

    public void writeAll() throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");){
            raf.write(this.bytes);
        }
    }
}

