/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.codegen;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;

public class CodeGen {
    HashMap<String, String> macros = new HashMap();
    HashMap<String, String> ifs = new HashMap();

    public String get(String key) {
        String value = this.macros.get(key);
        if (value == null) {
            throw new IllegalStateException("Missing macro " + key);
        }
        return value;
    }

    public void put(String key, String value) {
        this.macros.put(key, value);
    }

    public boolean getif(String key) {
        return this.ifs.get(key) != null;
    }

    public void putif(String key, boolean condition) {
        if (condition) {
            this.ifs.put(key, "true");
        } else {
            this.ifs.remove(key);
        }
    }

    public void process(FilePath in, FilePath out) throws Exception {
        try (InputStream is = ((BIFile)BOrd.make((OrdQuery)in).get()).getInputStream();
             OutputStream os = ((BIFile)BOrd.make((OrdQuery)out).get()).getOutputStream();){
            this.process(is, os);
        }
    }

    public void process(BIFile in, BIFile out) throws Exception {
        try (InputStream is = in.getInputStream();
             OutputStream os = out.getOutputStream();){
            this.process(is, os);
        }
    }

    public void process(File in, File out) throws Exception {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(in));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));){
            this.process(is, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InputStream in, OutputStream out) throws Exception {
        try {
            int c;
            String skip = null;
            boolean skipNewline = false;
            while ((c = in.read()) > 0) {
                if (c == 10 && skipNewline) {
                    skipNewline = false;
                    continue;
                }
                skipNewline = false;
                if (c != 36) {
                    if (skip != null) continue;
                    out.write(c);
                    continue;
                }
                int d = in.read();
                if (d != 40) {
                    if (skip != null) continue;
                    out.write(c);
                    out.write(d);
                    continue;
                }
                StringBuilder s = new StringBuilder();
                while ((c = in.read()) > 0 && c != 41) {
                    s.append((char)c);
                }
                String key = s.toString();
                if (key.startsWith("if.")) {
                    skip = this.getif(key = key.substring(3)) ? null : key;
                    skipNewline = true;
                    continue;
                }
                if (key.startsWith("end.")) {
                    key = key.substring(4);
                    if (skip != null && skip.equals(key)) {
                        skip = null;
                    }
                    skipNewline = true;
                    continue;
                }
                if (skip != null) continue;
                out.write(this.get(key).trim().getBytes());
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    public void process2(BIFile in, BIFile out) throws Exception {
        try (InputStream is = in.getInputStream();
             OutputStream os = out.getOutputStream();){
            this.process2(is, os);
        }
    }

    public void process2(InputStream input, OutputStream output) throws Exception {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(input));
             PrintWriter out = new PrintWriter(output);){
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.indexOf("$(if.") > -1) {
                    this.processMacro(line, in, out);
                    continue;
                }
                out.println(this.replaceMarkers(line));
            }
        }
    }

    private void processMacro(String line, BufferedReader in, PrintWriter out) throws Exception {
        int index = line.indexOf("$(if.");
        String key = line.substring(index + "$if(.".length(), line.indexOf(")"));
        boolean conditionSatisified = this.getif(key);
        if (conditionSatisified) {
            while ((line = in.readLine()) != null && line.indexOf("$(end." + key) == -1) {
                if (line.indexOf("$(if.") > -1) {
                    this.processMacro(line, in, out);
                    continue;
                }
                out.println(this.replaceMarkers(line));
            }
        } else {
            while ((line = in.readLine()) != null && line.indexOf("$(end." + key) == -1) {
            }
        }
    }

    private String replaceMarkers(String line) {
        StringBuilder processedLine = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            char c;
            if ((c = line.charAt(i++)) == '$') {
                if ((c = line.charAt(i++)) == '(') {
                    StringBuilder key = new StringBuilder();
                    while (i < line.length() && (c = line.charAt(i++)) != ')') {
                        key.append(c);
                    }
                    String value = this.get(key.toString());
                    if (value == null) continue;
                    processedLine.append(value);
                    continue;
                }
                processedLine.append(c);
                continue;
            }
            processedLine.append(c);
        }
        return processedLine.toString();
    }
}

