/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import com.tridium.batchJob.BBatchJobStepLogFile;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="steps", type="BFolder", defaultValue="new BFolder()", flags=1)
public class BNetworkJobStage
extends BJobStage {
    @Generated
    public static final Property steps = BNetworkJobStage.newProperty((int)1, (BValue)new BFolder(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNetworkJobStage.class);
    private static final Logger LOGGER = Logger.getLogger("batchJob");

    @Generated
    public BFolder getSteps() {
        return (BFolder)this.get(steps);
    }

    @Generated
    public void setSteps(BFolder v) {
        this.set(steps, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNetworkJobStage() {
    }

    public BNetworkJobStage(String stageName) {
        super(stageName);
    }

    public BDevice[] getDevices() {
        return ((BDeviceNetworkJob)this.getJob()).getDevices();
    }

    public BDeviceNetwork getNetwork() {
        return ((BDeviceNetworkJob)this.getJob()).getNetwork();
    }

    @Override
    public BJobState doRun(BBatchJobService service, BBatchJob job, BatchJobOp opIn) {
        DeviceNetworkJobOp op = (DeviceNetworkJobOp)opIn;
        BNetworkJobStep[] steps = this.getCombinedSteps();
        BDeviceNetwork nw = this.getNetwork();
        BDevice[] allDevices = this.getDevices();
        boolean anyFailed = false;
        boolean anyCanceled = false;
        for (BNetworkJobStep step : steps) {
            try {
                step.doInit(service, op);
            }
            catch (Exception e) {
                this.getJob().log().failed("batchJob", "NetworkJobStage.initializationFailed", (Throwable)e);
                return BJobState.failed;
            }
        }
        try {
            Thread.sleep(JOB_RUN_DELAY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (BNetworkJobStep step : steps) {
            ArrayList<BDevice> okDevices = new ArrayList<BDevice>();
            for (BDevice allDevice : allDevices) {
                if (op.deviceFailed(allDevice)) continue;
                okDevices.add(allDevice);
            }
            BNetworkStepDetails stepDetails = step.run(service, nw, okDevices.toArray(new BDevice[0]), op);
            BJobState stepState = stepDetails.getState();
            if (stepState == BJobState.failed) {
                this.stepComplete(service, stepDetails, op);
                anyFailed = true;
                break;
            }
            if (stepState == BJobState.canceled || stepState == BJobState.canceling) {
                if (stepState == BJobState.canceling) {
                    stepState = BJobState.canceled;
                    stepDetails.setState(stepState);
                }
                this.stepComplete(service, stepDetails, op);
                anyCanceled = true;
                break;
            }
            this.stepComplete(service, stepDetails, op);
        }
        if (anyFailed) {
            return BJobState.failed;
        }
        if (anyCanceled) {
            return BJobState.canceled;
        }
        return BJobState.success;
    }

    @Override
    public void addStep(BJobStep step) {
        this.getSteps().add("step?", (BValue)step);
    }

    @Override
    public void removeAllSteps() {
        this.getSteps().removeAll();
    }

    @Override
    public BJobStep[] getAllSteps() {
        ArrayList<BJobStep> result = new ArrayList<BJobStep>();
        SlotCursor c = this.getSteps().getProperties();
        while (c.next(BNetworkJobStep.class)) {
            result.add((BJobStep)c.get());
        }
        return result.toArray(new BJobStep[0]);
    }

    protected BNetworkJobStep[] getCombinedSteps() {
        ArrayList<BNetworkJobStep> result = new ArrayList<BNetworkJobStep>();
        BNetworkJobStep combineWith = null;
        SlotCursor c = this.getSteps().getProperties();
        while (c.next(BNetworkJobStep.class)) {
            BNetworkJobStep step = (BNetworkJobStep)c.get();
            if (combineWith != null && combineWith.canCombine(step) && step.canCombine(step)) {
                combineWith.combine(step);
                continue;
            }
            result.add(step);
            combineWith = step;
        }
        return result.toArray(new BNetworkJobStep[0]);
    }

    @Override
    public void prepareStage(BObject target) throws Exception {
        SlotCursor c = this.getSteps().getProperties();
        while (c.next(BNetworkJobStep.class)) {
            ((BNetworkJobStep)c.get()).prepareStep(target);
        }
    }

    @Override
    public void jobComplete(BatchJobOp op) {
        for (BNetworkJobStep step : this.getCombinedSteps()) {
            try {
                step.jobComplete((DeviceNetworkJobOp)op);
            }
            catch (Exception e) {
                this.getJob().log().failed("batchJob", "NetworkJobStage.cleanupFailed", (Throwable)e);
            }
        }
    }

    protected void stepComplete(BBatchJobService batch, BNetworkStepDetails stepDetails, DeviceNetworkJobOp op) {
        try {
            BBatchJobStepLogFile logFile = BBatchJobStepLogFile.create(stepDetails, this.getJob().getStartTime());
            if ((stepDetails.getState() == BJobState.failed || stepDetails.getState() == BJobState.canceled) && this.getJob().getAlertOnStepFailure()) {
                String alertMessage = Lexicon.make((String)"batchJob").getText("JobStepDetails.alertAlarmMessage", new Object[]{stepDetails.getStepDescription(), stepDetails.getDevicesToProcess().toString(), stepDetails.getFailureAlarmMessage(op)});
                batch.newAlert(alertMessage, logFile.getOrdInSession());
            }
            stepDetails.resetLog();
        }
        catch (Exception e) {
            Logger.getLogger("batchJob").log(Level.SEVERE, "error persisting job step", e);
        }
    }

    protected final synchronized void checkCanceled() {
        this.getJob().checkCanceled();
    }

    @Override
    public void doDispose(Context cx) {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        for (BJobStepDetails rec : this.getJobStepDetails()) {
            try {
                rec.dispose();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error disposing step record", e);
            }
        }
    }
}

