/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BLocalTimeUtil;
import com.tridium.batchJob.history.BHistoryJobSummaryManager;
import com.tridium.batchJob.history.BJobStepHistoryRecord;
import com.tridium.util.TimeFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.baja.agent.AgentList;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDataFile;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.types.log.BILogFile;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.FileExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

@NiagaraType(ext={@FileExt(name="bjsl")})
public class BBatchJobStepLogFile
extends BDataFile
implements BILogFile {
    @Generated
    public static final Type TYPE = Sys.loadType(BBatchJobStepLogFile.class);
    private BJobStepDetails details = null;
    private BAbsTime jobStartTime = null;
    private BString logContents = null;
    public static final String STEP_FILENAME_FORMAT = "yyyyMMdd_HHmmss.SSS.'bjsl'";
    public static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE});

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBatchJobStepLogFile(BIFileStore store) {
        super(store);
    }

    public BBatchJobStepLogFile() {
    }

    public static BBatchJobStepLogFile find(BJobStepDetails details, BObject base) {
        return BBatchJobStepLogFile.getLogFile(BBatchJobStepLogFile.pathFor(details.getStepType(), details.getLocalStartTime(), base), base);
    }

    public static BBatchJobStepLogFile find(BTypeSpec stepType, BAbsTime stepStartTime, BObject base) {
        return BBatchJobStepLogFile.getLogFile(BBatchJobStepLogFile.pathFor(stepType, stepStartTime, base), base);
    }

    public static BBatchJobStepLogFile find(BIJobStepSummary summary, BObject base) {
        return BBatchJobStepLogFile.getLogFile(BBatchJobStepLogFile.pathFor(summary.getStepType(), summary.getLocalStartTime(), base), base);
    }

    public static BBatchJobStepLogFile findLocal(BJobStepDetails details) {
        return BBatchJobStepLogFile.getLocalLogFile(BBatchJobStepLogFile.pathFor(details.getStepType(), details.getLocalStartTime(), null));
    }

    public static BBatchJobStepLogFile findLocal(BTypeSpec stepType, BAbsTime stepStartTime) {
        return BBatchJobStepLogFile.getLocalLogFile(BBatchJobStepLogFile.pathFor(stepType, stepStartTime, null));
    }

    public static BBatchJobStepLogFile findLocal(BJobStepHistoryRecord historyRecord) {
        return BBatchJobStepLogFile.getLocalLogFile(BBatchJobStepLogFile.pathFor(historyRecord.getStepType(), historyRecord.getLocalStartTime(), null));
    }

    private static BBatchJobStepLogFile getLocalLogFile(FilePath path) {
        return BBatchJobStepLogFile.getLogFile(path, null);
    }

    private static BBatchJobStepLogFile getLogFile(FilePath path, BObject base) {
        try {
            return AccessController.doPrivileged(() -> (BBatchJobStepLogFile)BOrd.make((OrdQuery)path).get(base));
        }
        catch (PrivilegedActionException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static BBatchJobStepLogFile create(BJobStepDetails details, BAbsTime jobStartTime) throws IOException {
        try {
            return AccessController.doPrivileged(() -> {
                BBatchJobStepLogFile result = (BBatchJobStepLogFile)BFileSystem.INSTANCE.makeFile(BBatchJobStepLogFile.pathFor(details.getStepType(), details.getLocalStartTime(), null));
                OutputStream out = result.getOutputStream();
                ValueDocEncoder enc = new ValueDocEncoder(out);
                enc.setEncodeTransients(true);
                BComponent doc = new BComponent();
                doc.add("stepDetails", details.newCopy());
                doc.add("jobStartTime", (BValue)jobStartTime);
                doc.add("logContents", (BValue)BString.make((String)details.log().encode()));
                enc.setZipped(true);
                enc.encodeDocument((BValue)doc);
                enc.close();
                out.close();
                return result;
            });
        }
        catch (PrivilegedActionException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BJobStepDetails getDetails() throws Exception {
        this.parse();
        return this.details;
    }

    public BAbsTime getJobStartTime() throws Exception {
        this.parse();
        return this.jobStartTime;
    }

    public BString getLogContents() throws Exception {
        this.parse();
        return this.logContents;
    }

    public BBatchJob getJob() throws Exception {
        return this.getJobLogFile().getJob();
    }

    public BBatchJobLogFile getJobLogFile() throws Exception {
        return BBatchJobLogFile.find(this.getJobStartTime(), (BObject)this);
    }

    public BAbsTime getFilenameTime() {
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(STEP_FILENAME_FORMAT);
            fmt.setTimeZone(BTimeZone.getLocal().getJavaTimeZone());
            return BAbsTime.make((long)fmt.parse(this.getFileName()).getTime());
        }
        catch (ParseException pe) {
            throw new BajaRuntimeException("Invalid log file name");
        }
    }

    private void parse() throws Exception {
        if (this.details == null) {
            BComponent doc = (BComponent)BLocalTimeUtil.decodeBogFile((BIFile)this);
            this.details = (BJobStepDetails)doc.get("stepDetails");
            this.jobStartTime = (BAbsTime)doc.get("jobStartTime");
            this.details.setLogFile((BIFile)this);
            this.logContents = (BString)doc.get("logContents");
            if (this.logContents == null) {
                this.logContents = BString.DEFAULT;
            }
        }
    }

    public void setStore(BIFileStore store) {
        super.setStore(store);
        this.details = null;
        this.jobStartTime = null;
    }

    public String getMimeType() {
        return "application/niagara-batch-job-step-log";
    }

    public String getNavDescription(Context cx) {
        return null;
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BINavNode[] getNavChildren() {
        return new BINavNode[0];
    }

    public BINavNode getNavChild(String navName) {
        return null;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toBottom("web:FileDownloadView");
        return agents;
    }

    private static FilePath pathFor(BTypeSpec stepType, BAbsTime startTime, BObject base) {
        TypeInfo historyType = BHistoryJobSummaryManager.getStepHistoryRecordType(stepType.getTypeInfo());
        FilePath result = new FilePath("^batchJob/logs");
        result = result.merge(historyType.getModuleName() + "_" + historyType.getTypeName());
        result = result.merge(TimeFormat.format((BAbsTime)startTime, (Context)TIMESTAMP_FORMAT) + ".bjsl");
        return result;
    }
}

