/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import com.tridium.email.BBasicEmailClientAuthenticator;
import com.tridium.email.BNoAuthEmailClientAuthenticator;
import com.tridium.email.EmailUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailClientAuthenticator;
import javax.baja.email.BEmailService;
import javax.baja.email.BIOutgoingAccountClientAuthenticator;
import javax.baja.email.BOutgoingAccountClientAuthenticatorTypeConfig;
import javax.baja.email.BTransport;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="port", type="int", defaultValue="25", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(-1))")}, override=true), @NiagaraProperty(name="emailAuthenticator", type="BEmailAuthenticatorTypeConfig", defaultValue="new BOutgoingAccountClientAuthenticatorTypeConfig()", flags=4, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}, override=true), @NiagaraProperty(name="transport", type="BTransport", defaultValue="BTransport.smtp"), @NiagaraProperty(name="connectionTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)"), @NiagaraProperty(name="useAuthentication", type="boolean", defaultValue="false", deprecated=true), @NiagaraProperty(name="replyTo", type="BEmailAddress", defaultValue="BEmailAddress.DEFAULT"), @NiagaraProperty(name="persistent", type="boolean", defaultValue="false"), @NiagaraProperty(name="persistenceDirectory", type="BOrd", defaultValue="BOrd.make(\"file:^email\")"), @NiagaraProperty(name="maxPersistedEmailSize", type="int", defaultValue="25000", facets={@Facet(name="BFacets.UNITS", value="BUnit.make(\"kilobyte\", \"KB\", BDimension.NULL)"), @Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="BInteger.MAX")}), @NiagaraProperty(name="allowDisabledQueueing", type="boolean", defaultValue="false"), @NiagaraProperty(name="queueSize", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="maxQueueSize", type="int", defaultValue="100", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(1))")}), @NiagaraProperty(name="numberSent", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="maxSendablePerDay", type="int", defaultValue="100", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(1))")}), @NiagaraProperty(name="numberDiscarded", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="lastDiscard", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastDiscardCause", type="String", defaultValue="", flags=1)})
@NiagaraActions(value={@NiagaraAction(name="send", parameterType="BEmail", defaultValue="new BEmail()"), @NiagaraAction(name="clearQueue"), @NiagaraAction(name="resetNumberSent")})
public class BOutgoingAccount
extends BEmailAccount {
    @Generated
    public static final Property port = BOutgoingAccount.newProperty((int)0, (int)25, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    @Generated
    public static final Property emailAuthenticator = BOutgoingAccount.newProperty((int)4, (BValue)new BOutgoingAccountClientAuthenticatorTypeConfig(), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property transport = BOutgoingAccount.newProperty((int)0, (BValue)BTransport.smtp, null);
    @Generated
    public static final Property connectionTimeout = BOutgoingAccount.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), null);
    @Deprecated
    @Generated
    public static final Property useAuthentication = BOutgoingAccount.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property replyTo = BOutgoingAccount.newProperty((int)0, (BValue)BEmailAddress.DEFAULT, null);
    @Generated
    public static final Property persistent = BOutgoingAccount.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property persistenceDirectory = BOutgoingAccount.newProperty((int)0, (BValue)BOrd.make((String)"file:^email"), null);
    @Generated
    public static final Property maxPersistedEmailSize = BOutgoingAccount.newProperty((int)0, (int)25000, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"kilobyte", (String)"KB", (BDimension)BDimension.NULL)), (BFacets)BFacets.make((String)"min", (int)1)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.MAX)));
    @Generated
    public static final Property allowDisabledQueueing = BOutgoingAccount.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property queueSize = BOutgoingAccount.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property maxQueueSize = BOutgoingAccount.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property numberSent = BOutgoingAccount.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property maxSendablePerDay = BOutgoingAccount.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property numberDiscarded = BOutgoingAccount.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property lastDiscard = BOutgoingAccount.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastDiscardCause = BOutgoingAccount.newProperty((int)1, (String)"", null);
    @Generated
    public static final Action send = BOutgoingAccount.newAction((int)0, (BValue)new BEmail(), null);
    @Generated
    public static final Action clearQueue = BOutgoingAccount.newAction((int)0, null);
    @Generated
    public static final Action resetNumberSent = BOutgoingAccount.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOutgoingAccount.class);
    private static final BIcon icon = BIcon.std((String)"outbox.png");
    private static final Pattern PROTECTED_STATION_HOME_PATH_PATTERN = Pattern.compile("file:\\^\\^email/\\p{XDigit}{8}-(\\p{XDigit}{4}-){3}\\p{XDigit}{12}");
    private static final BOrd PROTECTED_STATION_HOME_PERSISTENCE_DIRECTORY_TEMPLATE = BOrd.make((String)"file:^^email/$(uuid)");
    private BOrd effectivePersistenceDirectory;
    private static final DirectoryStream.Filter<Path> FILES_ONLY_FILTER = path -> path.toFile().isFile();
    private final Queue q = new Queue();
    private final Set<File> undeletableFiles = new HashSet<File>();
    private final Map<File, Integer> retriedPersistedEmails = new HashMap<File, Integer>();
    private Clock.Ticket ticket;
    private static final Lexicon LEX = Lexicon.make((String)"email");

    @Generated
    public BTransport getTransport() {
        return (BTransport)this.get(transport);
    }

    @Generated
    public void setTransport(BTransport v) {
        this.set(transport, (BValue)v, null);
    }

    @Generated
    public BRelTime getConnectionTimeout() {
        return (BRelTime)this.get(connectionTimeout);
    }

    @Generated
    public void setConnectionTimeout(BRelTime v) {
        this.set(connectionTimeout, (BValue)v, null);
    }

    @Deprecated
    @Generated
    public boolean getUseAuthentication() {
        return this.getBoolean(useAuthentication);
    }

    @Deprecated
    @Generated
    public void setUseAuthentication(boolean v) {
        this.setBoolean(useAuthentication, v, null);
    }

    @Generated
    public BEmailAddress getReplyTo() {
        return (BEmailAddress)this.get(replyTo);
    }

    @Generated
    public void setReplyTo(BEmailAddress v) {
        this.set(replyTo, (BValue)v, null);
    }

    @Generated
    public boolean getPersistent() {
        return this.getBoolean(persistent);
    }

    @Generated
    public void setPersistent(boolean v) {
        this.setBoolean(persistent, v, null);
    }

    @Generated
    public BOrd getPersistenceDirectory() {
        return (BOrd)this.get(persistenceDirectory);
    }

    @Generated
    public void setPersistenceDirectory(BOrd v) {
        this.set(persistenceDirectory, (BValue)v, null);
    }

    @Generated
    public int getMaxPersistedEmailSize() {
        return this.getInt(maxPersistedEmailSize);
    }

    @Generated
    public void setMaxPersistedEmailSize(int v) {
        this.setInt(maxPersistedEmailSize, v, null);
    }

    @Generated
    public boolean getAllowDisabledQueueing() {
        return this.getBoolean(allowDisabledQueueing);
    }

    @Generated
    public void setAllowDisabledQueueing(boolean v) {
        this.setBoolean(allowDisabledQueueing, v, null);
    }

    @Generated
    public int getQueueSize() {
        return this.getInt(queueSize);
    }

    @Generated
    public void setQueueSize(int v) {
        this.setInt(queueSize, v, null);
    }

    @Generated
    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    @Generated
    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    @Generated
    public int getNumberSent() {
        return this.getInt(numberSent);
    }

    @Generated
    public void setNumberSent(int v) {
        this.setInt(numberSent, v, null);
    }

    @Generated
    public int getMaxSendablePerDay() {
        return this.getInt(maxSendablePerDay);
    }

    @Generated
    public void setMaxSendablePerDay(int v) {
        this.setInt(maxSendablePerDay, v, null);
    }

    @Generated
    public int getNumberDiscarded() {
        return this.getInt(numberDiscarded);
    }

    @Generated
    public void setNumberDiscarded(int v) {
        this.setInt(numberDiscarded, v, null);
    }

    @Generated
    public BAbsTime getLastDiscard() {
        return (BAbsTime)this.get(lastDiscard);
    }

    @Generated
    public void setLastDiscard(BAbsTime v) {
        this.set(lastDiscard, (BValue)v, null);
    }

    @Generated
    public String getLastDiscardCause() {
        return this.getString(lastDiscardCause);
    }

    @Generated
    public void setLastDiscardCause(String v) {
        this.setString(lastDiscardCause, v, null);
    }

    @Generated
    public void send(BEmail parameter) {
        this.invoke(send, (BValue)parameter, null);
    }

    @Generated
    public void clearQueue() {
        this.invoke(clearQueue, null, null);
    }

    @Generated
    public void resetNumberSent() {
        this.invoke(resetNumberSent, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    final void fwStarted(int x, Object a, Object b, Object c, Object d) {
        this.migratePersistenceDirectoryToProtectedStationHome();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void started() throws Exception {
        super.started();
        if (this.getPersistent()) {
            BOutgoingAccount bOutgoingAccount = this;
            synchronized (bOutgoingAccount) {
                this.setQueueSize(this.getPersistedEmailFileCount());
            }
        } else {
            this.setQueueSize(this.q.size());
        }
        this.ticket = this.midnight();
    }

    @Override
    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        if (persistent.equals(prop)) {
            this.doPersistentChanged(cx);
        }
        if (persistenceDirectory.equals(prop) && !this.effectivePersistenceDirectory.equivalent((Object)this.getPersistenceDirectory())) {
            this.setPersistenceDirectory(this.effectivePersistenceDirectory);
        }
    }

    @Override
    final void migrateDeprecatedAuthProperties() {
        if (!Flags.isUserDefined2((BComplex)this, (Slot)emailAuthenticator)) {
            BEmailClientAuthenticator authenticator;
            if (this.getUseAuthentication()) {
                BBasicEmailClientAuthenticator basicAuthenticator = new BBasicEmailClientAuthenticator();
                basicAuthenticator.setAccount(this.getAccount());
                basicAuthenticator.setPassword(this.getPassword());
                authenticator = basicAuthenticator;
            } else {
                authenticator = new BNoAuthEmailClientAuthenticator();
            }
            BOutgoingAccountClientAuthenticatorTypeConfig authenticatorTypeConfig = new BOutgoingAccountClientAuthenticatorTypeConfig();
            authenticatorTypeConfig.setTypeSpec(((BEmailClientAuthenticator)authenticator).getType().getTypeSpec());
            authenticatorTypeConfig.syncFrom((BObject)authenticator);
            this.setEmailAuthenticator(authenticatorTypeConfig);
            this.setFlags((Slot)emailAuthenticator, this.getFlags((Slot)emailAuthenticator) | 0x20000000);
        }
        if (!Flags.isUserDefined1((BComplex)this, (Slot)emailAuthenticator)) {
            this.set(useAuthentication, useAuthentication.getDefaultValue());
            this.setFlags((Slot)useAuthentication, this.getFlags((Slot)useAuthentication) | 4 | 1);
        }
        super.migrateDeprecatedAuthProperties();
    }

    private void migratePersistenceDirectoryToProtectedStationHome() {
        boolean persistenceDirectoryAlreadyInProtectedStationHome = PROTECTED_STATION_HOME_PATH_PATTERN.matcher(this.getPersistenceDirectory().encodeToString()).matches();
        BOrd bOrd = this.effectivePersistenceDirectory = persistenceDirectoryAlreadyInProtectedStationHome ? this.getPersistenceDirectory() : BOutgoingAccount.substituteUuidInOrd(PROTECTED_STATION_HOME_PERSISTENCE_DIRECTORY_TEMPLATE);
        if (!this.getPersistenceDirectory().equivalent((Object)this.effectivePersistenceDirectory)) {
            BOrd originalPersistenceDirectoryOrd = this.getPersistenceDirectory();
            this.setPersistenceDirectory(this.effectivePersistenceDirectory);
            BEmailService.log.log(Level.WARNING, "The persistenceDirectory for email account: {0} has been changed from: {1} to: {2}, any previously persisted emails have not been moved", new Object[]{this.getName(), originalPersistenceDirectoryOrd, this.effectivePersistenceDirectory});
        }
        Flags.add((BComponent)this, (Slot)persistenceDirectory, (Context)Context.NULL, (int[])new int[]{1, 4});
    }

    @Override
    public void poll() throws Exception {
        this.pollQueue();
        this.pollUndeletables();
    }

    public void pollUndeletables() {
        AccessController.doPrivileged(() -> {
            this.undeletableFiles.removeIf(File::delete);
            return null;
        });
    }

    public void pollQueue() throws Exception {
        BEmailService.log.fine("BOutgoingAccount poll start");
        if (this.getPersistent() && this.getQueueSize() == 0 || !this.getPersistent() && this.q.isEmpty()) {
            return;
        }
        if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
            BEmailService.log.severe("BOutgoingAccount has already sent too many, ignoring poll request and clearing queue.");
            this.doClearQueue();
            return;
        }
        Session session = this.mailPlatformHandler.getOutgoingSession(this);
        session.setDebug(this.getDebug());
        session.setDebugOut(System.out);
        Transport smtpTransport = session.getTransport("smtp");
        ((BEmailClientAuthenticator)this.getEmailAuthenticator().make()).connectOutgoingSession(smtpTransport);
        if (this.getPersistent()) {
            this.dequeueDisk(smtpTransport, session);
        } else {
            this.dequeueMemory(smtpTransport, session);
        }
        smtpTransport.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSend(BEmail email, Context cx) {
        if (!(this.getAllowDisabledQueueing() || this.getEnabled() && this.isOperational())) {
            this.addDiscarded(LEX.getText("email.outgoingAccount.discardEmail.queueDisabled"), null, 1, false);
            return;
        }
        if (this.getQueueSize() >= this.getMaxQueueSize()) {
            this.addDiscarded(LEX.getText("email.outgoingAccount.discardEmail.queueFull"));
            return;
        }
        if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
            this.addDiscarded(LEX.getText("email.outgoingAccount.exceedsMaxSendablePerDay"));
            this.doClearQueue();
            return;
        }
        if (email.getFrom().equals((Object)BEmailAddress.DEFAULT)) {
            email.setFrom(this.getReplyTo());
        }
        try {
            if (this.getPersistent()) {
                this.enqueueDisk(email, cx);
                BOutgoingAccount bOutgoingAccount = this;
                synchronized (bOutgoingAccount) {
                    this.setQueueSize(this.getPersistedEmailFileCount());
                }
            } else {
                this.q.enqueue((Object)email);
                this.setQueueSize(this.q.size());
            }
            BEmailService.log.fine("BOutgoingAccount has just enqueued an email for delivery.");
        }
        catch (Exception e) {
            this.addDiscarded(LEX.getText("email.outgoingAccount.enqueueFailure"), e);
        }
    }

    public void doClearQueue() {
        int originalNumberQueuedEmails = this.getQueueSize();
        AtomicInteger queuedPersistedEmailCount = new AtomicInteger(this.getQueueSize());
        if (this.getPersistent() && this.getQueueSize() > 0) {
            try {
                this.forEachFileInPersistenceDirectory(persistedEmail -> {
                    if (this.deleteFile(persistedEmail.toFile(), Context.NULL)) {
                        queuedPersistedEmailCount.decrementAndGet();
                    }
                });
            }
            catch (IOException e) {
                BEmailService.log.log(Level.SEVERE, "BOutgoingAccount could not clear queue: ", e);
            }
            this.retriedPersistedEmails.clear();
        } else {
            this.q.clear();
            queuedPersistedEmailCount.set(0);
        }
        int numberDiscardedFromQueue = originalNumberQueuedEmails - queuedPersistedEmailCount.get();
        if (numberDiscardedFromQueue > 0) {
            this.addDiscarded(LEX.getText("email.outgoingAccount.queueCleared"), null, numberDiscardedFromQueue, false);
        }
        this.setQueueSize(0);
    }

    public void doResetNumberSent() {
        this.ticket.cancel();
        this.ticket = this.midnight();
        this.setNumberSent(0);
        this.setNumberDiscarded(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPersistentChanged(Context cx) {
        block7: {
            try {
                if (this.getQueueSize() <= 0) break block7;
                if (this.getPersistent()) {
                    while (!this.q.isEmpty()) {
                        this.enqueueDisk((BEmail)((Object)this.q.dequeue()), cx);
                    }
                    BOutgoingAccount bOutgoingAccount = this;
                    synchronized (bOutgoingAccount) {
                        this.setQueueSize(this.getPersistedEmailFileCount());
                        break block7;
                    }
                }
                this.forEachFileInPersistenceDirectory(encodedEmailFilePath -> {
                    File encodedEmailFile = encodedEmailFilePath.toFile();
                    try (ValueDocDecoder decoder = new ValueDocDecoder(encodedEmailFilePath.toFile());){
                        BEmail email = (BEmail)decoder.decodeDocument();
                        this.q.enqueue((Object)email);
                        this.deleteFile(encodedEmailFile, cx);
                        this.retriedPersistedEmails.remove(encodedEmailFile);
                    }
                    catch (Exception e) {
                        String failureToPersistMessage = String.format("BOutgoingAccount unable to persisted email: %s", encodedEmailFile.getPath());
                        BEmailService.log.log(Level.SEVERE, failureToPersistMessage, e);
                    }
                });
            }
            catch (Exception e) {
                BEmailService.log.log(Level.SEVERE, "BOutgoingAccount unable to set switch Email Directory", e);
            }
        }
    }

    private static BOrd substituteUuidInOrd(BOrd ord) {
        BOrd effectiveOrd = ord;
        if (ord.hasVariables()) {
            BFacets variableMap = BFacets.make((String)"uuid", (String)BUuid.make().toString());
            try {
                effectiveOrd = ord.substitute(variableMap);
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        return effectiveOrd;
    }

    private static File getFileOrdAsFile(BOrd ord) {
        FilePath path = (FilePath)ord.parse()[0];
        return BFileSystem.INSTANCE.pathToLocalFile(path);
    }

    private int getPersistedEmailFileCount() throws IOException {
        int count = 0;
        File persistenceDir = BOutgoingAccount.getFileOrdAsFile(this.getPersistenceDirectory());
        boolean persistenceDirExists = AccessController.doPrivileged(persistenceDir::exists);
        if (persistenceDirExists) {
            AtomicInteger persistedFileCount = new AtomicInteger();
            this.forEachFileInPersistenceDirectory(file -> {
                if (!this.undeletableFiles.contains(file.toFile())) {
                    persistedFileCount.incrementAndGet();
                }
            });
            count = persistedFileCount.get();
        }
        return count;
    }

    private void dequeueDisk(Transport transport, Session session) throws Exception {
        long maxPersistedEmailSizeInBytes = (long)this.getMaxPersistedEmailSize() * 1000L;
        AtomicInteger currentNumberSent = new AtomicInteger();
        Path persistenceDirPath = BOutgoingAccount.getFileOrdAsFile(this.getPersistenceDirectory()).toPath();
        try {
            AccessController.doPrivileged(() -> {
                try (DirectoryStream<Path> persistedEmailsDirectory = Files.newDirectoryStream(persistenceDirPath, FILES_ONLY_FILTER);){
                    List persistedEmails = StreamSupport.stream(persistedEmailsDirectory.spliterator(), false).map(Path::toFile).sorted((f1, f2) -> (int)(f1.lastModified() - f2.lastModified())).collect(Collectors.toList());
                    for (File persistedEmail : persistedEmails) {
                        if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
                            BEmailService.log.log(Level.SEVERE, "BOutgoingAccount has already sent too many, discarding email and clearing queue.");
                            this.doClearQueue();
                            break;
                        }
                        if (!transport.isConnected()) {
                            break;
                        }
                        BEmail email = null;
                        try {
                            if (this.undeletableFiles.contains(persistedEmail)) continue;
                            if (Files.size(persistedEmail.toPath()) > maxPersistedEmailSizeInBytes) {
                                this.deleteFile(persistedEmail, Context.NULL);
                                throw new LocalizableRuntimeException("email", "email.outgoingAccount.discardEmail.sizeLimitReached", new Object[]{persistedEmail.getName()});
                            }
                            if (this.retriedPersistedEmails.getOrDefault(persistedEmail, 0) >= BEmailService.MAX_NUMBER_OF_RETRIES_BEFORE_DISCARD) {
                                this.deleteFile(persistedEmail, Context.NULL);
                                throw new LocalizableRuntimeException("email", "email.outgoingAccount.maxRetryLimitReached");
                            }
                            try (ValueDocDecoder decoder = new ValueDocDecoder(persistedEmail);){
                                email = (BEmail)decoder.decodeDocument();
                            }
                            MimeMessage msg = EmailUtil.toMessage(email, session);
                            if (msg.getAllRecipients() == null || msg.getAllRecipients().length == 0) {
                                this.deleteFile(persistedEmail, Context.NULL);
                                throw new LocalizableRuntimeException("email", "email.outgoingAccount.noRecipients");
                            }
                            try {
                                AccessController.doPrivileged(() -> BOutgoingAccount.lambda$null$5(transport, (Message)msg));
                            }
                            catch (PrivilegedActionException e) {
                                throw e.getException();
                            }
                            this.deleteFile(persistedEmail, Context.NULL);
                            this.setNumberSent(this.getNumberSent() + 1);
                            currentNumberSent.incrementAndGet();
                        }
                        catch (Exception e) {
                            int retriedCount = 0;
                            if (email != null) {
                                retriedCount = this.retriedPersistedEmails.compute(persistedEmail, (emailFile, retryCount) -> retryCount == null ? 0 : retryCount + 1);
                            }
                            this.addDiscarded(LEX.getText("email.outgoingAccount.dequeuePersistentFailure"), e, email == null || retriedCount > BEmailService.MAX_NUMBER_OF_RETRIES_BEFORE_DISCARD ? 1 : 0, false);
                        }
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        if (currentNumberSent.get() > 0) {
            BEmailService.log.log(Level.FINE, "BOutgoingAccount has just sent {0} email(s).", currentNumberSent);
        }
        this.setQueueSize(this.getPersistedEmailFileCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueDisk(BEmail email, Context cx) throws IOException {
        File file;
        File persistenceDir = BOutgoingAccount.getFileOrdAsFile(this.getPersistenceDirectory());
        boolean persistenceDirExists = AccessController.doPrivileged(persistenceDir::exists);
        if (!persistenceDirExists) {
            this.createPersistenceDirectory(cx);
        }
        BOutgoingAccount bOutgoingAccount = this;
        synchronized (bOutgoingAccount) {
            file = new File(persistenceDir, BUuid.make() + ".xml");
        }
        try {
            AccessController.doPrivileged(() -> {
                try (ValueDocEncoder encoder = new ValueDocEncoder(file);){
                    encoder.encodeDocument((BValue)email);
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            if (pae.getCause() instanceof IOException) {
                throw (IOException)pae.getCause();
            }
            throw new IOException(pae.getCause());
        }
    }

    private void createPersistenceDirectory(Context cx) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                FilePath persistenceDirPath = (FilePath)this.getPersistenceDirectory().parse()[0];
                BFileSystem.INSTANCE.makeDir(persistenceDirPath, cx);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new BajaRuntimeException(e.getCause());
        }
    }

    private boolean deleteFile(File file, Context cx) {
        return AccessController.doPrivileged(() -> {
            boolean deleted = false;
            try {
                FilePath emailFilePath = BFileSystem.INSTANCE.localFileToPath(file);
                BFileSystem.INSTANCE.delete(emailFilePath, cx);
                this.undeletableFiles.remove(file);
                this.retriedPersistedEmails.remove(file);
                deleted = true;
            }
            catch (IOException e) {
                BEmailService.log.log(Level.WARNING, "BOutgoingAccount could not delete file: {0}", file.getPath());
                this.undeletableFiles.add(file);
                file.deleteOnExit();
            }
            return deleted;
        });
    }

    private void forEachFileInPersistenceDirectory(Consumer<Path> action) throws IOException {
        Path persistenceDirPath = BOutgoingAccount.getFileOrdAsFile(this.getPersistenceDirectory()).toPath();
        try {
            AccessController.doPrivileged(() -> {
                try (DirectoryStream<Path> persistedEmails = Files.newDirectoryStream(persistenceDirPath, FILES_ONLY_FILTER);){
                    persistedEmails.forEach(action);
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new BajaRuntimeException(e.getCause());
        }
    }

    private void dequeueMemory(Transport transport, Session session) throws Exception {
        int currentNumberSent = 0;
        while (!this.q.isEmpty() && transport.isConnected()) {
            if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
                this.addDiscarded(LEX.getText("email.outgoingAccount.exceedsMaxSendablePerDay"), null, this.getQueueSize(), true);
                this.doClearQueue();
                return;
            }
            BEmail email = (BEmail)((Object)this.q.dequeue());
            email.incrementNumberOfRetries();
            StringBuilder message = new StringBuilder();
            try {
                MimeMessage msg = EmailUtil.toMessage(email, session);
                Object[] recipients = msg.getAllRecipients();
                if (recipients == null || recipients.length == 0) {
                    throw new LocalizableRuntimeException("email", "email.outgoingAccount.noRecipients");
                }
                try {
                    AccessController.doPrivileged(() -> BOutgoingAccount.lambda$dequeueMemory$12(transport, (Message)msg, (Address[])recipients));
                    this.setNumberSent(this.getNumberSent() + 1);
                    ++currentNumberSent;
                }
                catch (PrivilegedActionException e) {
                    Throwable cause = e.getCause();
                    message.append(LEX.getText("email.outgoingAccount.sendFail", new Object[]{Arrays.toString(recipients)}));
                    if (cause instanceof MessagingException) {
                        if (email.getNumberOfRetries() > BEmailService.MAX_NUMBER_OF_RETRIES_BEFORE_DISCARD) {
                            message.append(System.lineSeparator()).append(LEX.getText("email.outgoingAccount.maxRetryLimitReached"));
                        } else {
                            this.q.enqueue((Object)email);
                            message.append(System.lineSeparator()).append(LEX.getText("email.outgoingAccount.retryEmail"));
                        }
                    } else if (cause instanceof SendFailedException || cause instanceof IOException || cause instanceof NullPointerException) {
                        message.append(System.lineSeparator()).append(LEX.getText("email.outgoingAccount.discardEmail"));
                    }
                    throw e.getException();
                }
            }
            catch (Exception e) {
                if (message.length() > 0) {
                    this.addDiscarded(message.toString(), e, email.getNumberOfRetries() > BEmailService.MAX_NUMBER_OF_RETRIES_BEFORE_DISCARD ? 1 : 0, true);
                    continue;
                }
                this.addDiscarded(LEX.getText("email.outgoingAccount.discardEmail"), e);
            }
        }
        if (currentNumberSent > 0) {
            BEmailService.log.log(Level.FINE, "BOutgoingAccount has just sent {0} email(s).", currentNumberSent);
        }
        this.setQueueSize(this.q.size());
    }

    private Clock.Ticket midnight() {
        BAbsTime now = BAbsTime.now();
        BAbsTime next = now.nextDay();
        BAbsTime midnight = next.timeOfDay(0, 0, 0, 0);
        return Clock.schedule((BComponent)this, (BAbsTime)midnight, (Action)resetNumberSent, null);
    }

    public void addDiscarded(String message) {
        this.addDiscarded(message, null);
    }

    public void addDiscarded(Exception e) {
        this.addDiscarded(null, e);
    }

    public void addDiscarded(String message, Exception e) {
        this.addDiscarded(message, e, 1, true);
    }

    public void addDiscarded(String message, Exception e, int amount, boolean logError) {
        this.setNumberDiscarded(this.getNumberDiscarded() + amount);
        this.setLastDiscard(BAbsTime.now());
        StringBuilder b = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            b.append(message);
        }
        if (message != null && !message.isEmpty() && e != null) {
            b.append(": ");
        }
        if (e != null) {
            b.append(BOutgoingAccount.getExceptionMessage(e));
        }
        if (e != null && e.getCause() != null) {
            b.append(": ").append(BOutgoingAccount.getExceptionMessage(e.getCause()));
        }
        this.setLastDiscardCause(b.toString());
        if (logError) {
            BEmailService.log.log(Level.SEVERE, b.toString(), e);
        } else if (BEmailService.log.isLoggable(Level.FINE)) {
            BEmailService.log.log(Level.FINE, b.toString(), e);
        }
    }

    private static String getExceptionMessage(Throwable throwable) {
        if (throwable instanceof Localizable) {
            return ((Localizable)throwable).toString(null);
        }
        return throwable.getMessage();
    }

    @Override
    public Type getTargetEmailAuthenticatorType() {
        return BIOutgoingAccountClientAuthenticator.TYPE;
    }

    private static /* synthetic */ Object lambda$dequeueMemory$12(Transport transport, Message msg, Address[] recipients) throws Exception {
        if (!transport.isConnected()) {
            throw new MessagingException("Transport not connected.");
        }
        transport.sendMessage(msg, recipients);
        return null;
    }

    private static /* synthetic */ Object lambda$null$5(Transport transport, Message msg) throws Exception {
        transport.sendMessage(msg, msg.getAllRecipients());
        return null;
    }
}

