/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email.alarm;

import com.tridium.alarm.user.BIUserAlarmRecipient;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.BEmailService;
import javax.baja.email.BOutgoingAccount;
import javax.baja.email.BTextPart;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="to", type="BEmailAddressList", defaultValue="BEmailAddressList.DEFAULT"), @NiagaraProperty(name="cc", type="BEmailAddressList", defaultValue="BEmailAddressList.DEFAULT"), @NiagaraProperty(name="bcc", type="BEmailAddressList", defaultValue="BEmailAddressList.DEFAULT"), @NiagaraProperty(name="language", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH, BInteger.make(6))")}), @NiagaraProperty(name="emailAccount", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"email:OutgoingAccountFE\"))")}), @NiagaraProperty(name="subject", type="BFormat", defaultValue="BFormat.make(\"Niagara Alarm From %alarmData.sourceName%\")"), @NiagaraProperty(name="body", type="BFormat", defaultValue="makeDefaultEmailFormat()", facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.make(true))")})})
public class BEmailRecipient
extends BAlarmRecipient
implements BIUserAlarmRecipient {
    @Generated
    public static final Property to = BEmailRecipient.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    @Generated
    public static final Property cc = BEmailRecipient.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    @Generated
    public static final Property bcc = BEmailRecipient.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    @Generated
    public static final Property language = BEmailRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)6)));
    @Generated
    public static final Property emailAccount = BEmailRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"email:OutgoingAccountFE")));
    @Generated
    public static final Property subject = BEmailRecipient.newProperty((int)0, (BValue)BFormat.make((String)"Niagara Alarm From %alarmData.sourceName%"), null);
    @Generated
    public static final Property body = BEmailRecipient.newProperty((int)0, (BValue)BEmailRecipient.makeDefaultEmailFormat(), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    @Generated
    public static final Type TYPE = Sys.loadType(BEmailRecipient.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"email.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    public Lexicon lex = Lexicon.make(BEmailRecipient.class);
    public static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);

    @Generated
    public BEmailAddressList getTo() {
        return (BEmailAddressList)this.get(to);
    }

    @Generated
    public void setTo(BEmailAddressList v) {
        this.set(to, (BValue)v, null);
    }

    @Generated
    public BEmailAddressList getCc() {
        return (BEmailAddressList)this.get(cc);
    }

    @Generated
    public void setCc(BEmailAddressList v) {
        this.set(cc, (BValue)v, null);
    }

    @Generated
    public BEmailAddressList getBcc() {
        return (BEmailAddressList)this.get(bcc);
    }

    @Generated
    public void setBcc(BEmailAddressList v) {
        this.set(bcc, (BValue)v, null);
    }

    @Generated
    public String getLanguage() {
        return this.getString(language);
    }

    @Generated
    public void setLanguage(String v) {
        this.setString(language, v, null);
    }

    @Generated
    public String getEmailAccount() {
        return this.getString(emailAccount);
    }

    @Generated
    public void setEmailAccount(String v) {
        this.setString(emailAccount, v, null);
    }

    @Generated
    public BFormat getSubject() {
        return (BFormat)this.get(subject);
    }

    @Generated
    public void setSubject(BFormat v) {
        this.set(subject, (BValue)v, null);
    }

    @Generated
    public BFormat getBody() {
        return (BFormat)this.get(body);
    }

    @Generated
    public void setBody(BFormat v) {
        this.set(body, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void handleAlarm(BAlarmRecord alarm) {
        this.sendAlarm(this.getTo(), alarm);
    }

    private void sendAlarm(BEmailAddressList toList, BAlarmRecord alarm) {
        BEmailService service = (BEmailService)Sys.getService((Type)BEmailService.TYPE);
        BOutgoingAccount account = (BOutgoingAccount)service.loadSlots().get(this.getEmailAccount());
        if (account == null) {
            BEmailService.log.severe("Alarm email recipient can not find '" + this.getEmailAccount() + "' outgoing account.");
            return;
        }
        String lang = this.getLanguage();
        if (lang.equals("")) {
            lang = Sys.getLanguage();
        }
        EmailContext cx = new EmailContext(lang);
        BEmail mail = new BEmail();
        mail.setTo(toList);
        mail.setCc(this.getCc());
        mail.setBcc(this.getBcc());
        mail.setDate(BAbsTime.now());
        mail.setSubject(BIUserAlarmRecipient.formatAlarmDataValues((BFormat)this.getSubject(), (BAlarmRecord)alarm, (Context)cx));
        String body = BIUserAlarmRecipient.formatAlarmDataValues((BFormat)this.getBody(), (BAlarmRecord)alarm, (Context)cx);
        mail.setBody(new BTextPart("", body));
        mail.getHeaders().addHeader("Message-ID", "alarm." + alarm.getUuid().toString((Context)cx));
        account.send(mail);
    }

    public static BFormat makeDefaultEmailFormat() {
        StringBuilder buf = new StringBuilder();
        buf.append("Source:      %alarmData.sourceName%\n");
        buf.append("Timestamp:   %timestamp%\n");
        buf.append("State:       %sourceState% / %ackState%\n");
        buf.append("Priority:    %priority%\n");
        buf.append("Alarm Class: %alarmClass%\n");
        buf.append("Text:        %alarmData.msgText%\n");
        return BFormat.make((String)buf.toString());
    }

    public void handleAlarmForUser(BUser user, BAlarmRecord alarmRecord) {
        if (this.accept(alarmRecord)) {
            this.sendAlarm(BEmailAddressList.make(user.getEmail()), alarmRecord);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    class EmailContext
    implements Context {
        String lang;

        public EmailContext(String lang) {
            this.lang = lang;
        }

        public Context getBase() {
            return null;
        }

        public BUser getUser() {
            return null;
        }

        public BFacets getFacets() {
            return TIME_FACETS;
        }

        public BObject getFacet(String name) {
            return this.getFacets().get(name);
        }

        public String getLanguage() {
            return this.lang;
        }
    }
}

