/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email;

import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.email.BAbstractOAuthEmailAuthenticator;
import com.tridium.nre.security.SecretChars;
import com.tridium.oauth2.OAuth2AuthorizationException;
import com.tridium.oauth2.OAuth2AuthorizationRequest;
import com.tridium.oauth2.OAuth2AuthorizationServerMetadata;
import com.tridium.oauth2.clientcredentials.OAuth2ClientCredentialsGrantRequest;
import com.tridium.oauth2.jwt.OAuth2JWTBearerGrantRequest;
import com.tridium.util.ArrayUtil;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="clientCertificate", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:CertificateAliasFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:CertificateAliasEditor\"))"), @Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="privateKeyPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="useJWTBearerAssertion", type="boolean", defaultValue="false")})
public class BOAuthEmailClientCertificateAuthenticator
extends BAbstractOAuthEmailAuthenticator {
    @Generated
    public static final Property clientCertificate = BOAuthEmailClientCertificateAuthenticator.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    @Generated
    public static final Property privateKeyPassword = BOAuthEmailClientCertificateAuthenticator.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property useJWTBearerAssertion = BOAuthEmailClientCertificateAuthenticator.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOAuthEmailClientCertificateAuthenticator.class);
    private static final String[] CONFIGURABLE_PROPERTIES = new String[]{clientCertificate.getName(), privateKeyPassword.getName(), useJWTBearerAssertion.getName()};

    @Generated
    public String getClientCertificate() {
        return this.getString(clientCertificate);
    }

    @Generated
    public void setClientCertificate(String v) {
        this.setString(clientCertificate, v, null);
    }

    @Generated
    public BPassword getPrivateKeyPassword() {
        return (BPassword)this.get(privateKeyPassword);
    }

    @Generated
    public void setPrivateKeyPassword(BPassword v) {
        this.set(privateKeyPassword, (BValue)v, null);
    }

    @Generated
    public boolean getUseJWTBearerAssertion() {
        return this.getBoolean(useJWTBearerAssertion);
    }

    @Generated
    public void setUseJWTBearerAssertion(boolean v) {
        this.setBoolean(useJWTBearerAssertion, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected OAuth2AuthorizationRequest getAuthorizationRequest() throws OAuth2AuthorizationException {
        try {
            CoreCryptoManager ccm = CoreCryptoManager.get();
            X509Certificate certificate = ccm.getKeyStore().getCertificate(this.getClientCertificate());
            PrivateKey privateKey = AccessController.doPrivileged(() -> this.lambda$getAuthorizationRequest$0((ICoreCryptoManager)ccm));
            OAuth2AuthorizationServerMetadata authServerMetadata = this.getAuthServerMetadata();
            String clientId = this.getClientId();
            String[] scope = new String[]{this.getScope()};
            OAuth2JWTBearerGrantRequest authorizationRequest = this.getUseJWTBearerAssertion() ? new OAuth2JWTBearerGrantRequest(authServerMetadata, clientId, certificate, privateKey, scope) : new OAuth2ClientCredentialsGrantRequest(authServerMetadata, clientId, certificate, privateKey, scope);
            return authorizationRequest;
        }
        catch (PrivilegedActionException e) {
            throw new OAuth2AuthorizationException("Failed to obtain either the client certificate or corresponding private key", e.getCause());
        }
        catch (Exception e) {
            throw new OAuth2AuthorizationException((Throwable)e);
        }
    }

    @Override
    public String[] listConfig() {
        return (String[])ArrayUtil.add((Object[])super.listConfig(), (Object[])CONFIGURABLE_PROPERTIES);
    }

    private /* synthetic */ PrivateKey lambda$getAuthorizationRequest$0(ICoreCryptoManager ccm) throws Exception {
        try (SecretChars passwordChars = this.getPrivateKeyPassword().getSecretChars();){
            PrivateKey privateKey = (PrivateKey)ccm.getKeyStore().getKey(this.getClientCertificate(), this.getPrivateKeyPassword().isDefault() ? null : passwordChars.get());
            return privateKey;
        }
    }
}

