/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.camera.BVideoCameraWidget;
import com.tridium.videoDriver.ui.camera.BVideoLayerPane;
import com.tridium.videoDriver.ui.camera.BVideoPtzDialogPane;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;

@NiagaraType
public class BVideoCameraWidgetPtzDialog
extends BDialog {
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoCameraWidgetPtzDialog.class);
    protected boolean closed = false;
    protected BVideoCameraWidget videoCameraWidget;
    protected BVideoLayerPane myWindowContent;
    public static final Logger log = Logger.getLogger("videoDriver.cameraWidget.dialog");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BVideoCameraWidgetPtzDialog() {
        super(null, VideoDriverLexicon.LEX.getText("PanTiltZoom"), false);
        this.draw();
        this.setBoundsCenteredOnOwner();
    }

    public BVideoCameraWidgetPtzDialog(BVideoCameraWidget videoCameraWidget) {
        super((BWidget)videoCameraWidget, VideoDriverLexicon.LEX.getText("PanTiltZoom"), false);
        this.videoCameraWidget = videoCameraWidget;
        this.draw();
        this.setBoundsCenteredOnOwner();
    }

    public void draw() {
        this.myWindowContent = new BVideoLayerPane();
        this.myWindowContent.add("videoPane", (BValue)new BBorderPane((BWidget)new BVideoPlayer(), BBorder.inset, BInsets.NULL));
        BEdgePane loadingPane = new BEdgePane();
        BLabel loadingLabel = new BLabel(BImage.make((String)VideoDriverLexicon.LEX.getText("VideoMultistreamViewer.Loading.Icon")), VideoDriverLexicon.LEX.getText("VideoMultistreamViewer.Loading.Label"));
        loadingLabel.setFont(Theme.label().getLargeBoldFont());
        loadingPane.setCenter((BWidget)loadingLabel);
        this.myWindowContent.add("loadingPane", (BValue)loadingPane);
        this.setContent((BWidget)this.myWindowContent);
    }

    public void windowOpened(BWindowEvent event) {
        if (this.videoCameraWidget != null) {
            this.initDialogAsync();
        }
        this.closed = false;
    }

    public void windowClosed(BWindowEvent event) {
        this.closed = true;
        this.isVisible();
    }

    public void initDialogAsync() {
        new Thread("CameraWidget.InitPtzDialog"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("CameraWidget.InitPtzDialog - Thread running.");
                }
                boolean viewLoaded = false;
                if (!BVideoCameraWidgetPtzDialog.this.isRunning()) {
                    BVideoCameraWidgetPtzDialog.this.start();
                }
                while (BVideoCameraWidgetPtzDialog.this.isRunning() && !viewLoaded && !BVideoCameraWidgetPtzDialog.this.closed) {
                    long startOfWhileLoopTicks = Clock.ticks();
                    try {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Updating dialog title.");
                        }
                        BVideoCameraWidgetPtzDialog.this.setTitle(BVideoCameraWidgetPtzDialog.this.videoCameraWidget.getPtzDialogTitle());
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Attempting to re-draw the view.");
                        }
                        BVideoPtzDialogPane dialogPane = BVideoCameraWidgetPtzDialog.this.videoCameraWidget.getPtzVideoPane();
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Finished re-drawing the view.");
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Updating the dialog contents.");
                        }
                        BVideoCameraWidgetPtzDialog.this.myWindowContent.removeAll();
                        BVideoCameraWidgetPtzDialog.this.myWindowContent.add("ptzVideoPane", (BValue)dialogPane);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("View should be loaded. This thread should finish in a moment.");
                        }
                        viewLoaded = true;
                    }
                    catch (UnresolvedException ue) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Unable to resolve video camera at this time");
                        }
                        viewLoaded = false;
                        try {
                            long nowTicks = Clock.ticks();
                            long elapsedTimeUntilException = nowTicks - startOfWhileLoopTicks;
                            if (elapsedTimeUntilException < 15000L) {
                                long sleepTime = 16000L - elapsedTimeUntilException;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("Will sleep for " + sleepTime + " millis and then retry");
                                }
                                Thread.sleep(sleepTime);
                                continue;
                            }
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("Will retry immediately");
                        }
                        catch (InterruptedException ie) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("CameraWidget.InitPtzDialog - Thread Interrupted");
                            }
                            return;
                        }
                    }
                    finally {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("Thread finished.");
                    }
                }
            }
        }.start();
    }
}

