/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAsyncCallbacks;
import com.tridium.fox.session.FoxSession;
import com.tridium.sys.Nre;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoSource;
import com.tridium.videoDriver.videoStream.fox.FoxVideoConnection;
import com.tridium.videoDriver.videoStream.fox.StationSideVideoCoordinator;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.io.ValueDocEncoder;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;

public class StationSideVideoSession
implements IVideoDestination,
FoxAsyncCallbacks,
Runnable {
    protected long lastChunkToGuiTicks = Clock.ticks();
    protected IVideoStream driverVideoStream;
    protected String videoClientId;
    protected int videoStreamId;
    protected BPlaybackParams playbackParams;
    protected StationSideVideoCoordinator stationSideVideoCoordinator;
    protected byte[] receiveBuffer = new byte[4096];
    protected BFoxVideoSource foxVideoSource;
    protected Object sendToGuiMonitor = new Object();
    protected boolean running = false;
    protected boolean closed = false;
    protected boolean paused = false;
    protected boolean closedEarly = false;
    protected Thread myThread;
    protected static long ticksLastCpuTrace = 0L;
    protected static final int MAX_CPU_BACKOFF_INTERVAL = 1000;
    protected int cpuBackoffInterval = 1000;
    protected long ticksLastCpuBackoff = 0L;
    protected static final int ONE_HOURS_WORTH_OF_TICKS = 3600000;
    protected static final int TEN_SECONDS_WORTH_OF_TICKS = 10000;
    protected static Logger log = Logger.getLogger("fox.stationVideoSessions");
    protected static Logger xferLog = Logger.getLogger("fox.stationVideoSessions.transfer");
    protected static Logger cpulog = Logger.getLogger("fox.stationVideoSessions.cpu");

    protected StationSideVideoSession(StationSideVideoCoordinator videoCoordinator, BFoxVideoSource foxVideoSource, BPlaybackParams playbackParams, String videoClientId, int videoStreamId) {
        this.stationSideVideoCoordinator = videoCoordinator;
        this.foxVideoSource = foxVideoSource;
        this.playbackParams = playbackParams;
        this.videoClientId = videoClientId;
        this.videoStreamId = videoStreamId;
    }

    protected StationSideVideoSession() {
    }

    public String getVideoClientId() {
        return this.videoClientId;
    }

    public int getVideoStreamId() {
        return this.videoStreamId;
    }

    public BPlaybackParams getPlaybackParams() {
        return this.playbackParams;
    }

    public BFoxVideoSource getFoxVideoSource() {
        return this.foxVideoSource;
    }

    public StationSideVideoCoordinator getStationSideVideoCoordinator() {
        return this.stationSideVideoCoordinator;
    }

    @Override
    public void receiveVideoStream(IVideoStream videoStream) {
        if (log.isLoggable(Level.FINE)) {
            this.trace(log, "Received video stream for underlying video driver. " + this.closed);
        }
        this.driverVideoStream = videoStream;
        this.playbackParams = videoStream.getPlaybackParams();
        if (this.closed) {
            if (this.stationSideVideoCoordinator.log.isLoggable(Level.FINE)) {
                this.stationSideVideoCoordinator.log.fine("Received stream from driver after the video stream was closed. Video client = " + this.videoClientId + ". Video stream = " + this.videoStreamId);
            }
            try {
                videoStream.closeVideoStream();
                this.stationSideVideoCoordinator.closeVideoStream(this.getVideoClientId(), this.getVideoStreamId());
            }
            catch (IOException e) {
                if (log.isLoggable(Level.FINE)) {
                    this.trace(log, "Error closing late stream", e);
                }
            }
        } else {
            this.startStationSideVideoSession();
        }
    }

    @Override
    public void videoStreamTimeout() {
        if (log.isLoggable(Level.FINE)) {
            this.trace(log, "Video stream timeout from underlying video driver.");
        }
        if (this.stationSideVideoCoordinator.log.isLoggable(Level.FINE)) {
            this.stationSideVideoCoordinator.log.fine("Driver notified session of video stream timeout. Video client id = " + this.videoClientId + " Video stream = " + this.getVideoStreamId());
        }
        try {
            this.stationSideVideoCoordinator.videoSessionTimeOut(this);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unable to notify client that its video stream timed out:  " + e);
        }
    }

    @Override
    public IVideoSession getVideoSession() {
        return null;
    }

    @Override
    public IVideoDecoder getVideoDecoder() {
        return null;
    }

    public byte[] getReceiveBuffer() {
        return this.receiveBuffer;
    }

    public void startStationSideVideoSession() {
        if (!this.running) {
            if (log.isLoggable(Level.FINE)) {
                this.trace(log, "startStationSideVideoSession()");
            }
            this.running = true;
            this.myThread = new Thread((Runnable)this, "Fox:VideoSession:" + this.getVideoClientId() + "." + this.getVideoStreamId());
            this.myThread.start();
        }
    }

    public void watchdog(Logger watchDogLog) {
        block5: {
            if (watchDogLog.isLoggable(Level.FINE)) {
                this.trace(watchDogLog, "watchdog check. videoClientId=" + this.videoClientId + " videoStreamId=" + this.videoStreamId);
            }
            if (Clock.ticks() - this.lastChunkToGuiTicks >= 30000L) {
                if (watchDogLog.isLoggable(Level.FINE)) {
                    this.trace(watchDogLog, "Too much time has elapsed. Closing video session videoClientId=" + this.videoClientId + " videoStreamId=" + this.videoStreamId);
                }
                try {
                    this.close();
                }
                catch (IOException ioe) {
                    if (!watchDogLog.isLoggable(Level.FINE)) break block5;
                    this.trace(watchDogLog, "IOException occurred while closing video session videoClientId=" + this.videoClientId + " videoStreamId=" + this.videoStreamId, ioe);
                }
            }
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            this.trace(log, "close", null);
        }
        this.closed = true;
        Object object = this.sendToGuiMonitor;
        synchronized (object) {
            this.sendToGuiMonitor.notifyAll();
        }
        try {
            if (this.driverVideoStream == null) {
                if (log.isLoggable(Level.FINE)) {
                    this.closedEarly = true;
                    this.trace(log, "Closed before receiving video stream.");
                }
            } else {
                this.driverVideoStream.closeVideoStream();
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "IO Exception closing driver video stream", e);
            throw e;
        }
        catch (RuntimeException rte) {
            log.log(Level.SEVERE, "Runtime Exception closing driver video stream", rte);
            throw rte;
        }
        this.running = false;
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
        if (this.myThread != null && !this.myThread.isAlive()) {
            this.receiveBuffer = null;
            this.playbackParams = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncMessageSent(FoxSession session, FoxMessage message) {
        if (xferLog.isLoggable(Level.FINE)) {
            this.trace(xferLog, "[" + Clock.ticks() + "]Chunk was transmitted. Video client id = " + this.videoClientId);
        }
        Object object = this.sendToGuiMonitor;
        synchronized (object) {
            this.sendToGuiMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (log.isLoggable(Level.FINE)) {
                this.trace(log, "Running", null);
            }
            boolean firstPass = true;
            while (this.running && !this.closed) {
                try {
                    if (this.paused) {
                        Thread.sleep(100L);
                        continue;
                    }
                    this.stationSideVideoCoordinator.getVideoSessionsWatchdog().startWatchingSession(this);
                    try {
                        this.transferOneChunk(firstPass);
                        firstPass = false;
                    }
                    finally {
                        this.stationSideVideoCoordinator.getVideoSessionsWatchdog().stopWatchingSession(this);
                    }
                    long nowTicks = Clock.ticks();
                    int cpuUtilization = Nre.getPlatform().getCpuUsage();
                    if (cpuUtilization > 75) {
                        if (nowTicks - this.ticksLastCpuBackoff >= (long)this.cpuBackoffInterval) {
                            if (nowTicks - this.ticksLastCpuBackoff >= 3600000L) {
                                cpulog.info("Excessive CPU utilization. Slowing down fox video stream mechanism. cpuBackoffInterval = " + this.cpuBackoffInterval);
                            }
                            this.ticksLastCpuBackoff = nowTicks;
                            Thread.sleep(100L);
                            this.cpuBackoffInterval = this.cpuBackoffInterval / 2 + 1;
                        }
                    } else if (nowTicks - this.ticksLastCpuBackoff >= (long)this.cpuBackoffInterval) {
                        if (this.cpuBackoffInterval < 1000) {
                            this.cpuBackoffInterval *= 2;
                        }
                        if (this.cpuBackoffInterval > 1000) {
                            this.cpuBackoffInterval = 1000;
                        }
                    }
                    if (!cpulog.isLoggable(Level.FINE) || nowTicks - ticksLastCpuTrace <= 10000L) continue;
                    ticksLastCpuTrace = nowTicks;
                    this.trace(cpulog, "Streaming video. CPU utilization = " + cpuUtilization + "  cpuBackoffInterval = " + this.cpuBackoffInterval);
                }
                catch (Exception e) {
                    if (log.isLoggable(Level.FINE)) {
                        this.trace(log, "Exception occurred transferring a chunk of video Video Client Id = " + this.getVideoClientId() + " Video stream Id = " + this.getVideoStreamId(), e);
                    }
                    this.running = false;
                }
            }
        }
        finally {
            if (log.isLoggable(Level.FINE)) {
                this.trace(log, "finished running", null);
            }
            try {
                this.close();
                this.receiveBuffer = null;
                this.playbackParams = null;
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error closing/de-allocating driver video stream", e);
            }
        }
    }

    protected void trace(Logger log, String traceStr) {
        log.fine(this.videoClientId + "{vsId:" + this.videoStreamId + "}" + traceStr);
    }

    protected void trace(Logger log, String traceStr, Exception e) {
        log.log(Level.FINE, this.videoClientId + "{vsId:" + this.videoStreamId + "}" + traceStr, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferOneChunk(boolean addPlayback) throws Exception {
        FoxVideoConnection videoConnection = this.stationSideVideoCoordinator.connectionToClient;
        if (videoConnection == null) {
            throw new IllegalStateException("Fox video connection is null.");
        }
        int n = 0;
        if (xferLog.isLoggable(Level.FINE)) {
            this.trace(xferLog, "[" + Clock.ticks() + "]Reading 4K chunk from driver stream. Video stream id = " + this.getVideoStreamId() + " Video client id = " + this.getVideoClientId());
        }
        try {
            n = this.driverVideoStream.getInputStream().read(this.getReceiveBuffer());
        }
        catch (Exception e) {
            if (xferLog.isLoggable(Level.FINE)) {
                this.trace(xferLog, "Exception while reading chunk of video from driver: ", e);
            }
            n = -1;
        }
        if (this.closed) {
            return;
        }
        if (n > 0) {
            if (xferLog.isLoggable(Level.FINE)) {
                this.trace(xferLog, "[" + Clock.ticks() + "]Sending chunk to Gui client. Size=" + n + " Video stream id = " + this.getVideoStreamId() + " Video client id = " + videoConnection.getVideoClientId());
            }
            FoxMessage frameChunkMsg = new FoxMessage();
            frameChunkMsg.add("msgType", "videoFrameData");
            frameChunkMsg.add("videoStreamId", this.getVideoStreamId());
            if (addPlayback) {
                frameChunkMsg.add("playbackParams", ValueDocEncoder.marshal((BValue)this.playbackParams));
            }
            frameChunkMsg.add("videoFrameChunk", this.getReceiveBuffer(), n);
            Object object = this.sendToGuiMonitor;
            synchronized (object) {
                videoConnection.writeChunkToCircuit(this, frameChunkMsg, this.getVideoStreamId());
                this.sendToGuiMonitor.wait(10000L);
                this.lastChunkToGuiTicks = Clock.ticks();
            }
        } else if (n == 0) {
            if (xferLog.isLoggable(Level.FINE)) {
                this.trace(xferLog, "Call to read from underlying video stream returned with zero bytes. Video stream id = " + this.getVideoStreamId() + " Video client id = " + videoConnection.getVideoClientId());
            }
            Thread.sleep(100L);
        } else {
            this.stationSideVideoCoordinator.closeVideoStream(videoConnection.getVideoClientId(), this.getVideoStreamId());
            throw new IOException("Stream closed closed while reading block of video for Workbench client. Video stream id = " + this.getVideoStreamId() + " Video client id = " + videoConnection.getVideoClientId());
        }
    }
}

