/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.MessageWriter;
import com.tridium.fox.session.FoxAsyncCallbacks;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.videoDriver.videoStream.fox.StationSideVideoCoordinator;
import com.tridium.videoDriver.videoStream.fox.StationSideVideoSession;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FoxVideoConnection {
    protected static Logger log = Logger.getLogger("fox.clientVideoConnections");
    protected String videoClientId;
    protected StationSideVideoCoordinator videoCoordinator;
    protected FoxCircuit circuit;

    protected FoxVideoConnection(StationSideVideoCoordinator videoRouter, FoxCircuit circuit, String videoClientId) {
        this.videoCoordinator = videoRouter;
        this.circuit = circuit;
        this.videoClientId = videoClientId;
    }

    protected FoxVideoConnection() {
    }

    protected void connectionClosed() {
    }

    public FoxCircuit getCircuit() {
        return this.circuit;
    }

    public void sendTimeout(StationSideVideoSession videoSession) throws Exception {
        FoxMessage timeoutMsg = new FoxMessage();
        timeoutMsg.add("videoStreamId", videoSession.getVideoStreamId());
        timeoutMsg.add("msgType", "timeout");
        timeoutMsg.add("videoStreamTimeout", true);
        this.circuit.writeMessage(timeoutMsg);
    }

    protected void writeChunkToCircuit(StationSideVideoSession videoSession, FoxMessage frameChunkMsg, int videoStreamId) throws Exception {
        if (this.circuit.session().isClosed()) {
            this.videoCoordinator.closeVideoStream(this.videoClientId, videoStreamId);
            throw new EOFException("Circuit to client closed in the middle of sending video frames. Video stream id = " + videoStreamId + " Video client id = " + this.videoClientId);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageWriter writer = new MessageWriter((OutputStream)out);
        frameChunkMsg.writeValue(writer);
        byte[] msgBytes = out.toByteArray();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Sending chunk to workbench. Video stream id = " + videoStreamId + " Video client id = " + this.videoClientId);
        }
        this.circuit.write(msgBytes, 0, msgBytes.length, (FoxAsyncCallbacks)videoSession);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Video session now busy...waiting for chunk to be transmitted. Video stream id = " + videoStreamId + " Video client id = " + this.videoClientId);
        }
    }

    public String getVideoClientId() {
        return this.videoClientId;
    }
}

