/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.alarm.monitoring;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.videoDriver.alarm.monitoring.BAlarmConsoleTypeEnum;
import com.tridium.videoDriver.alarm.monitoring.BAlarmDialogScaleFactorEnum;
import com.tridium.videoDriver.alarm.monitoring.BAlarmNotification;
import com.tridium.videoDriver.alarm.monitoring.BAlarmTypeEnum;
import com.tridium.videoDriver.alarm.monitoring.BMonitor;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"baja:User"})})
@NiagaraProperties(value={@NiagaraProperty(name="sourceToMonitor", type="BOrd", defaultValue="BOrd.make(\"service:alarm:AlarmService\")", override=true), @NiagaraProperty(name="alarmTypeToMonitor", type="BAlarmTypeEnum", defaultValue="BAlarmTypeEnum.allAlarms"), @NiagaraProperty(name="alarmState", type="BAlarmTransitionBits", defaultValue="BAlarmTransitionBits.DEFAULT"), @NiagaraProperty(name="ackState", type="BAckState", defaultValue="BAckState.unacked"), @NiagaraProperty(name="alarmConsoleType", type="BAlarmConsoleTypeEnum", defaultValue="BAlarmConsoleTypeEnum.alarmConsole"), @NiagaraProperty(name="dialogScaleFactor", type="BAlarmDialogScaleFactorEnum", defaultValue="BAlarmDialogScaleFactorEnum.seventy")})
public class BConsoleRecipientMonitor
extends BMonitor {
    @Generated
    public static final Property sourceToMonitor = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BOrd.make((String)"service:alarm:AlarmService"), null);
    @Generated
    public static final Property alarmTypeToMonitor = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BAlarmTypeEnum.allAlarms, null);
    @Generated
    public static final Property alarmState = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BAlarmTransitionBits.DEFAULT, null);
    @Generated
    public static final Property ackState = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BAckState.unacked, null);
    @Generated
    public static final Property alarmConsoleType = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BAlarmConsoleTypeEnum.alarmConsole, null);
    @Generated
    public static final Property dialogScaleFactor = BConsoleRecipientMonitor.newProperty((int)0, (BValue)BAlarmDialogScaleFactorEnum.seventy, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BConsoleRecipientMonitor.class);
    private static final Type CONSOLE_RECIPIENT_TYPE = BTypeSpec.make((String)"alarm:ConsoleRecipient").getResolvedType();

    @Generated
    public BAlarmTypeEnum getAlarmTypeToMonitor() {
        return (BAlarmTypeEnum)this.get(alarmTypeToMonitor);
    }

    @Generated
    public void setAlarmTypeToMonitor(BAlarmTypeEnum v) {
        this.set(alarmTypeToMonitor, (BValue)v, null);
    }

    @Generated
    public BAlarmTransitionBits getAlarmState() {
        return (BAlarmTransitionBits)this.get(alarmState);
    }

    @Generated
    public void setAlarmState(BAlarmTransitionBits v) {
        this.set(alarmState, (BValue)v, null);
    }

    @Generated
    public BAckState getAckState() {
        return (BAckState)this.get(ackState);
    }

    @Generated
    public void setAckState(BAckState v) {
        this.set(ackState, (BValue)v, null);
    }

    @Generated
    public BAlarmConsoleTypeEnum getAlarmConsoleType() {
        return (BAlarmConsoleTypeEnum)this.get(alarmConsoleType);
    }

    @Generated
    public void setAlarmConsoleType(BAlarmConsoleTypeEnum v) {
        this.set(alarmConsoleType, (BValue)v, null);
    }

    @Generated
    public BAlarmDialogScaleFactorEnum getDialogScaleFactor() {
        return (BAlarmDialogScaleFactorEnum)this.get(dialogScaleFactor);
    }

    @Generated
    public void setDialogScaleFactor(BAlarmDialogScaleFactorEnum v) {
        this.set(dialogScaleFactor, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(sourceToMonitor)) {
            if (this.getSourceToMonitor().isNull()) {
                return;
            }
            BLink[] monitorLinks = this.getLinks((Slot)signalNotification);
            for (int i = 0; i < monitorLinks.length; ++i) {
                this.remove((BComplex)monitorLinks[i]);
            }
            BComponent monitorSource = this.getMonitorSource().asComponent();
            if (monitorSource.getType().is(BConsoleRecipient.TYPE)) {
                BConsoleRecipient recipient = (BConsoleRecipient)monitorSource;
                BLink link = this.makeLink((BComponent)recipient, (Slot)BConsoleRecipient.routeAlarm, (Slot)signalNotification, context);
                link.setSourceOrd(recipient.getHandleOrd());
                this.add("monitorSourceLink?", (BValue)link);
                link.activate();
            }
        }
    }

    public static boolean videoDriverAvailable() {
        try {
            Sys.loadModule((String)"videoDriver");
            Sys.getLicenseManager().checkFeature("tridium", "videoDriver");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public BAlarmRecord getLastAlarmRecord() {
        BValue record = this.getLastValueSignaled();
        return record instanceof BAlarmRecord ? (BAlarmRecord)record : null;
    }

    @Override
    public Type getMonitorSourceType() {
        return CONSOLE_RECIPIENT_TYPE;
    }

    @Override
    public Type getNotificationType() {
        return BAlarmNotification.TYPE;
    }

    public String getDisplayNameInParent(Context cx) {
        return "Alarm Popup Settings";
    }
}

