/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb.orient;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemDb.BSystemDbService;
import com.tridium.systemDb.SystemDbConnection;
import com.tridium.systemDb.orient.BOrientSystemDb;
import com.tridium.systemDb.orient.NiagaraPermissionOrientHook;
import com.tridium.systemDb.orient.queryGeneration.OrientGeneratingVisitor;
import com.tridium.util.EscUtil;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.baja.category.BICategorizable;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataTypes;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.neql.NeqlQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BMarker;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.tag.util.BasicEntity;
import javax.baja.tag.util.TagSet;

public class OrientSystemDbConnection
extends SystemDbConnection {
    private static final Map<String, Object> edgeLabelLocks = Collections.synchronizedMap(new WeakHashMap());
    private static final OrientEsc orientEsc = new OrientEsc();
    private static final String DELETE_STATION_QUERY_PREFIX = "DELETE VERTEX V WHERE " + OrientSystemDbConnection.escapeToOrientForm("n:station") + " IN ";
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private ODatabaseDocumentEmbedded graph;
    private OrientDB dbEngine;
    final Context cx;
    NiagaraPermissionOrientHook permissionHook;
    private static final String ID = "__id";
    private static final String VIRTUAL_END = "|virtual:/";
    public static final String SCOPED_EDGE_LABEL = "scopedEdge";
    public static final String IN_SCOPED_EDGE_LABEL = "in_scopedEdge";
    public static final String OUT_SCOPED_EDGE_LABEL = "out_scopedEdge";
    private static final Map<String, BIDataValue> COMMON_NON_INFERRABLE_TAG_CONVERSIONS = Collections.singletonMap("n:ordInSession", BOrd.DEFAULT);

    OrientSystemDbConnection(OrientDB dbEngine, Context cx) {
        this.dbEngine = dbEngine;
        this.cx = cx;
    }

    public final void close() {
        this.closeGraph();
    }

    protected final void doAddEntity(Entity entity) throws Exception {
        if (this.permissionHook != null) {
            this.permissionHook.failOnInaccessibleRead = true;
        }
        try {
            if (!this.isConnected()) {
                throw new NoGraphOpenException("This connection is closed. No graph is open for use.");
            }
            BOrd resolvedOrd = BSystemDb.toSystemDbOrd((Entity)entity);
            AccessController.doPrivileged(() -> {
                this.addTransaction(resolvedOrd, entity);
                return null;
            });
        }
        finally {
            if (this.permissionHook != null) {
                this.permissionHook.failOnInaccessibleRead = false;
            }
        }
    }

    private void addTransaction(BOrd resolvedOrd, Entity entity) throws Exception {
        String resolvedOrdString = resolvedOrd.toString();
        this.graph.activateOnCurrentThread();
        if (this.getVertex(resolvedOrdString) == null) {
            try {
                HashSet knownEdgeLabels = new HashSet();
                AccessController.doPrivileged(() -> {
                    this.beginTransaction();
                    for (Relation r : entity.relations()) {
                        Id id = r.getId();
                        if (knownEdgeLabels.contains(id)) continue;
                        this.createEdgeLabelIfAbsent(OrientSystemDbConnection.escapeToOrientForm(id.getQName()));
                        knownEdgeLabels.add(id);
                    }
                    OVertex vertex = this.graph.newVertex();
                    vertex.setProperty(ID, (Object)resolvedOrdString);
                    this.addPropertyTags(entity, vertex);
                    this.updateScopeEdges(vertex, this.graph);
                    this.addEdges(entity, vertex, this.graph);
                    this.graph.save((ORecord)vertex);
                    this.endTransaction();
                    return null;
                });
            }
            catch (Exception e) {
                this.rollbackTransaction();
                throw e;
            }
        } else {
            throw new SystemDbConnection.AddEntityException(resolvedOrdString + " already exists in the DB.");
        }
    }

    private void addEdges(Entity entity, OVertex vertex, ODatabaseDocumentEmbedded idGraph) throws Exception {
        HashSet<Id> knownEdgeLabels = new HashSet<Id>();
        try {
            for (Relation relation : entity.relations()) {
                OVertex target;
                Optional<BOrd> endpointOrd = OrientSystemDbConnection.getEndpointOrd(relation);
                if (!endpointOrd.isPresent() || (target = this.getVertex(endpointOrd.get().toString())) == null) continue;
                Id id = relation.getId();
                String edgeLabel = OrientSystemDbConnection.escapeToOrientForm(relation.getId().getQName());
                if (!knownEdgeLabels.contains(id)) {
                    this.createEdgeLabelIfAbsent(edgeLabel);
                    knownEdgeLabels.add(id);
                }
                OEdge edge = relation.isOutbound() ? idGraph.newEdge(vertex, target, edgeLabel) : idGraph.newEdge(target, vertex, edgeLabel);
                this.addTagPropertiesToElement((OElement)edge, relation.tags());
                idGraph.save((ORecord)edge);
            }
        }
        catch (Exception e) {
            BOrd entityOrd = entity.getOrdToEntity().orElse(BOrd.NULL);
            LOGGER.log(Level.WARNING, e, () -> "Failed to add edges to vertex. Failed on " + entityOrd);
            throw e;
        }
    }

    private static Optional<BOrd> getEndpointOrd(Relation relation) throws BSystemDb.InvalidEntityException {
        Entity entity = relation.getEndpoint();
        Optional<BOrd> resolvedOrd = entity == null ? Optional.of(relation.getEndpointOrd()) : Optional.of(BSystemDb.toSystemDbOrd((Entity)entity));
        return resolvedOrd;
    }

    private void updateScopeEdges(OVertex vertex, ODatabaseDocumentEmbedded graph) {
        BOrd startOrd = BOrd.make((String)vertex.getProperty(ID).toString());
        Optional<BOrd> nearestAncestorOrd = this.getClosestParentOrd(startOrd);
        if (nearestAncestorOrd.isPresent()) {
            OVertex src = this.getVertex(nearestAncestorOrd.get().toString());
            this.buildAncestorScopeEdge(graph, src, vertex);
        }
    }

    private Optional<BOrd> getClosestParentOrd(BOrd startOrd) {
        BOrd parentOrd = startOrd.getParent();
        parentOrd = OrientSystemDbConnection.getParent(parentOrd, startOrd.toString());
        while (parentOrd != null) {
            String currentParentString = parentOrd.toString();
            OVertex parentVertex = this.getVertex(currentParentString);
            if (parentVertex != null) {
                return Optional.ofNullable(BOrd.make((String)parentVertex.getProperty(ID).toString()));
            }
            parentOrd = OrientSystemDbConnection.getParent(parentOrd.getParent(), parentOrd.toString());
        }
        return Optional.empty();
    }

    private static BOrd getParent(BOrd parentOrd, String ordString) {
        if (parentOrd == null && ordString.endsWith(VIRTUAL_END)) {
            parentOrd = BOrd.make((String)ordString.substring(0, ordString.length() - VIRTUAL_END.length()));
        }
        return parentOrd;
    }

    private void updateMultipleScopeEdges(String id, EntityVertexPair pair, NavigableMap<String, EntityVertexPair> entityMap) {
        boolean containsKey;
        String lowerKey = id;
        do {
            boolean bl = (lowerKey = entityMap.lowerKey(lowerKey)) != null && (lowerKey.endsWith("/") ? id.startsWith(lowerKey) : id.startsWith(lowerKey + '/')) ? true : (containsKey = false);
            if (!containsKey || id.length() == lowerKey.length()) continue;
            OVertex src = ((EntityVertexPair)entityMap.get(lowerKey)).vertex;
            OVertex dest = pair.vertex;
            this.buildLightweightEdge(src, dest);
        } while (lowerKey != null && !containsKey);
    }

    private void addPropertyTags(Entity entity, OVertex vertex) {
        this.addTagPropertiesToElement((OElement)vertex, entity.tags());
        if (entity instanceof BICategorizable) {
            vertex.setProperty("CategoryMask", (Object)((BICategorizable)entity).getAppliedCategoryMask().encodeToString());
        }
    }

    private void addTagPropertiesToElement(OElement element, Tags tags) {
        StringJoiner tagTypes = null;
        for (Tag tag : tags) {
            BIDataValue dataValue = tag.getValue();
            String tagIdStr = tag.getId().toString();
            char dataTypeSymbol = OrientSystemDbConnection.setElementProperty(OrientSystemDbConnection.escapeToOrientForm(tagIdStr), dataValue, element);
            if (dataTypeSymbol == '\u0000' || COMMON_NON_INFERRABLE_TAG_CONVERSIONS.containsKey(tagIdStr)) continue;
            if (tagTypes == null) {
                tagTypes = new StringJoiner(";");
            }
            tagTypes.add(tagIdStr + '=' + dataTypeSymbol);
        }
        if (tagTypes != null) {
            element.setProperty("TagTypes", (Object)tagTypes.toString());
        }
    }

    private static char setElementProperty(String propertyString, BIDataValue dataValue, OElement element) {
        Type valueType = dataValue.getType();
        if (BMarker.TYPE.equals(valueType)) {
            element.setProperty(propertyString, (Object)((BIBoolean)dataValue).getBoolean());
        } else {
            if (BBoolean.TYPE.equals(valueType)) {
                element.setProperty(propertyString, (Object)((BIBoolean)dataValue).getBoolean());
                return valueType.getDataTypeSymbol();
            }
            if (BDouble.TYPE.equals(valueType)) {
                element.setProperty(propertyString, (Object)((BNumber)dataValue).getDouble());
            } else if (BFloat.TYPE.equals(valueType)) {
                element.setProperty(propertyString, (Object)Float.valueOf(((BNumber)dataValue).getFloat()));
            } else if (BInteger.TYPE.equals(valueType)) {
                element.setProperty(propertyString, (Object)((BNumber)dataValue).getInt());
            } else if (BLong.TYPE.equals(valueType)) {
                element.setProperty(propertyString, (Object)((BNumber)dataValue).getLong());
            } else if (BString.TYPE.equals(valueType)) {
                element.setProperty(propertyString, (Object)dataValue.toString());
            } else {
                if (BRelTime.TYPE.equals(valueType)) {
                    element.setProperty(propertyString, (Object)((BRelTime)dataValue).getMillis());
                    return valueType.getDataTypeSymbol();
                }
                if (BAbsTime.TYPE.equals(valueType)) {
                    element.setProperty(propertyString, (Object)new Date(((BAbsTime)dataValue).getMillis()));
                } else {
                    try {
                        element.setProperty(propertyString, (Object)dataValue.encodeToString());
                    }
                    catch (IOException e) {
                        throw new BajaRuntimeException((Throwable)e);
                    }
                    return valueType.getDataTypeSymbol();
                }
            }
        }
        return '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doAddEntities(Stream<Entity> entities) throws Exception {
        long start = DiagnosticUtil.startIfLoggable((String)"OrientSystemDbConnection.doAddEntities");
        if (this.permissionHook != null) {
            this.permissionHook.failOnInaccessibleRead = true;
        }
        try {
            NavigableMap<String, EntityVertexPair> entityMap = this.prepareForInsertion(entities);
            AccessController.doPrivileged(() -> {
                this.addEntitiesTransaction(entityMap);
                return null;
            });
        }
        finally {
            if (this.permissionHook != null) {
                this.permissionHook.failOnInaccessibleRead = false;
            }
            DiagnosticUtil.complete((long)start, (String)"OrientSystemDbConnection.doAddEntities");
        }
    }

    private void addEntitiesTransaction(NavigableMap<String, EntityVertexPair> entityMap) throws Exception {
        try {
            ODatabaseDocumentEmbedded graph = this.getGraph();
            this.beginTransaction();
            for (Map.Entry entry : entityMap.entrySet()) {
                String id = (String)entry.getKey();
                EntityVertexPair pair = (EntityVertexPair)entry.getValue();
                pair.vertex = graph.newVertex();
                pair.vertex.setProperty(ID, (Object)id);
                this.addPropertyTags(pair.entity, pair.vertex);
                this.updateMultipleScopeEdges(id, pair, entityMap);
                this.addEdges(pair, entityMap, graph);
                graph.save((ORecord)pair.vertex);
            }
            this.endTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            LOGGER.log(Level.WARNING, e, () -> "Failed to add entities to the database.");
            if (e instanceof IllegalArgumentException) {
                throw new SystemDbConnection.AddEntityException(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEdges(EntityVertexPair pair, NavigableMap<String, EntityVertexPair> entityMap, ODatabaseDocumentEmbedded graph) throws Exception {
        try {
            for (Relation relation : pair.entity.relations()) {
                EntityVertexPair endpoint;
                Optional<BOrd> endpointOrd = OrientSystemDbConnection.getEndpointOrd(relation);
                if (!endpointOrd.isPresent() || (endpoint = (EntityVertexPair)entityMap.get(endpointOrd.get().toString())) == null || endpoint.vertex == null) continue;
                String label = OrientSystemDbConnection.escapeToOrientForm(relation.getId().getQName());
                if (graph.getClass(label) == null) {
                    ODatabaseDocumentAbstract localGraph = BOrientSystemDb.openDatabaseSession(this.dbEngine);
                    localGraph.activateOnCurrentThread();
                    try {
                        localGraph.createClass(label, new String[0]);
                        localGraph.close();
                    }
                    finally {
                        graph.activateOnCurrentThread();
                    }
                }
                OEdge edge = relation.isOutbound() ? graph.newEdge(pair.vertex, endpoint.vertex, label) : graph.newEdge(endpoint.vertex, pair.vertex, label);
                this.addTagPropertiesToElement((OElement)edge, relation.tags());
                graph.save((ORecord)edge);
            }
        }
        catch (Exception e) {
            BOrd entityOrd = pair.entity.getOrdToEntity().orElse(BOrd.NULL);
            LOGGER.log(Level.WARNING, e, () -> "Failed to add edges to vertex. Failed on " + entityOrd);
            throw e;
        }
    }

    private void buildLightweightEdge(OVertex source, OVertex destination) {
        Objects.requireNonNull(this.graph, "A graph is required. It can't be null");
        Objects.requireNonNull(source, "A source is required. It can't be null");
        Objects.requireNonNull(destination, "A destination is required. It can't be null");
        try {
            this.graph.setUseLightweightEdges(true);
            this.graph.newEdge(source, destination, SCOPED_EDGE_LABEL);
        }
        finally {
            this.graph.setUseLightweightEdges(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEdgeLabelIfAbsent(String label) {
        block9: {
            try {
                if (this.graph.getClass(label) != null) break block9;
                Object object = OrientSystemDbConnection.getLockForEdgeLabel(label);
                synchronized (object) {
                    if (this.graph.getClass(label) == null) {
                        AccessController.doPrivileged(() -> {
                            ODatabaseDocumentAbstract localGraph = BOrientSystemDb.openDatabaseSession(this.dbEngine);
                            localGraph.activateOnCurrentThread();
                            localGraph.createEdgeClass(label);
                            localGraph.close();
                            return null;
                        });
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.graph.activateOnCurrentThread();
            }
        }
    }

    private NavigableMap<String, EntityVertexPair> prepareForInsertion(Stream<Entity> entities) {
        TreeMap<String, EntityVertexPair> result = new TreeMap<String, EntityVertexPair>();
        HashSet knownEdgeLabels = new HashSet();
        entities.forEach(entity -> {
            for (Relation r : entity.relations()) {
                Id id = r.getId();
                if (knownEdgeLabels.contains(id)) continue;
                try {
                    this.createEdgeLabelIfAbsent(OrientSystemDbConnection.escapeToOrientForm(id.getQName()));
                    knownEdgeLabels.add(id);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, e, () -> "Unable to create edge class for : " + id);
                    throw new RuntimeException(e);
                }
            }
            try {
                String key = BSystemDb.toSystemDbOrd((Entity)entity).toString();
                result.put(key, new EntityVertexPair((Entity)entity));
            }
            catch (BSystemDb.InvalidEntityException iee) {
                throw new RuntimeException(iee);
            }
        });
        return result;
    }

    private static Object getLockForEdgeLabel(String label) {
        return edgeLabelLocks.computeIfAbsent(label, v -> new Object());
    }

    private void closeGraph() {
        long start = DiagnosticUtil.startIfLoggable((String)"OrientSystemDbConnection.closeGraph");
        if (this.graph != null) {
            this.graph.activateOnCurrentThread();
            this.graph.close();
            LOGGER.fine(() -> "Closed connection " + this.graph.toString());
        } else {
            LOGGER.fine(() -> "Connection already closed.");
        }
        DiagnosticUtil.complete((long)start, (String)"OrientSystemDbConnection.closeGraph");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OResultSet getVertices(OrdTarget scope, OrdQuery query) throws Exception {
        long start = DiagnosticUtil.startIfLoggable((String)"OrientSystemDbConnection.getVertices");
        try {
            OResultSet oResultSet = AccessController.doPrivileged(() -> {
                this.graph.activateOnCurrentThread();
                return this.executeQuery((NeqlQuery)query, scope, (ODatabaseSession)this.graph);
            });
            return oResultSet;
        }
        finally {
            if (start > -1L) {
                DiagnosticUtil.complete((long)start, (String)"OrientSystemDbConnection.getVertices", (Object)(scope + ", " + query));
            }
        }
    }

    public final void connect() throws Exception {
        if (this.isConnected()) {
            return;
        }
        this.getGraph();
    }

    protected void beginTransaction() {
        this.graph.begin();
    }

    protected void endTransaction() throws Exception {
        AccessController.doPrivileged(() -> {
            this.graph.commit();
            return null;
        });
    }

    protected void rollbackTransaction() {
        this.graph.rollback();
    }

    private ODatabaseDocumentEmbedded getConfiguredGraph() {
        if (this.graph == null) {
            long start = DiagnosticUtil.startIfLoggable((String)"OrientSystemDbConnection.getConfiguredGraph");
            this.graph = (ODatabaseDocumentEmbedded)BOrientSystemDb.openDatabaseSession(this.dbEngine);
            DiagnosticUtil.complete((long)start, (String)"OrientSystemDbConnection.getConfiguredGraph");
        }
        return this.graph;
    }

    ODatabaseDocumentEmbedded getGraph() throws Exception {
        if (this.isConnected()) {
            this.graph.activateOnCurrentThread();
            return this.graph;
        }
        try {
            this.graph = this.makeGraph();
            this.graph.activateOnCurrentThread();
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        this.createEdgeLabelIfAbsent(SCOPED_EDGE_LABEL);
        return this.graph;
    }

    private ODatabaseDocumentEmbedded makeGraph() throws PrivilegedActionException {
        return AccessController.doPrivileged(() -> {
            ODatabaseDocumentEmbedded orientGraph = this.getConfiguredGraph();
            this.permissionHook = new NiagaraPermissionOrientHook((ODatabaseDocument)orientGraph, this.cx);
            return orientGraph;
        });
    }

    private boolean isConnected() {
        return this.graph != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OResultSet executeQuery(NeqlQuery query, OrdTarget scope, ODatabaseSession graph) throws Exception {
        long start = DiagnosticUtil.startIfLoggable((String)"OrientSystemDbConnection.executeQuery");
        try {
            ORID scopeId = null;
            BObject base = null;
            if (scope != null && !(scope.get() instanceof BSystemDb) && scope.getBase() != null) {
                BOrd scopeOrd = BSystemDb.toSystemDbOrd((Entity)((Entity)scope.get()));
                scopeId = this.getBaseRecord(scopeOrd).orElse(null);
                OrdTarget temp = scope.getBaseOrdTarget();
                base = temp != null ? temp.get() : null;
            }
            OrientGeneratingVisitor visitor = OrientGeneratingVisitor.makeVisitor(scopeId, base, query, this.cx);
            String translation = visitor.getTranslation();
            Map<String, String> parameters = visitor.getParameters();
            OResultSet oResultSet = AccessController.doPrivileged(() -> graph.command(translation, parameters));
            return oResultSet;
        }
        finally {
            if (start > -1L) {
                DiagnosticUtil.complete((long)start, (String)"OrientSystemDbConnection.executeQuery", (Object)(scope + ", " + query));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ORID> getBaseRecord(BOrd ord) throws LocalizableException {
        long start = DiagnosticUtil.startIfLoggable((String)"OrientSystemDbConnection.getBaseRecord");
        try {
            String ordString = ord.relativizeToSession().toString();
            OVertex v = this.getVertex(ordString);
            if (v == null) {
                throw new LocalizableException("orientSystemDb", "orientSystemDb.OrdNotFound", new Object[]{ordString});
            }
            Optional<ORID> optional = Optional.ofNullable(v.getIdentity());
            return optional;
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"OrientSystemDbConnection.getBaseRecord", (Object)ord);
        }
    }

    protected void doRemoveEntity(Entity entity) throws Exception {
        try {
            if (this.permissionHook != null) {
                this.permissionHook.skipReadPermissionCheck = true;
            }
            BOrd resolvedOrd = BSystemDb.toSystemDbOrd((Entity)entity);
            AccessController.doPrivileged(() -> {
                this.removeTransaction(resolvedOrd.toString());
                return null;
            });
        }
        finally {
            if (this.permissionHook != null) {
                this.permissionHook.skipReadPermissionCheck = false;
            }
        }
    }

    private OVertex getVertex(String vertexId) {
        OVertex theVertex = null;
        try (OResultSet query = this.graph.query("SELECT FROM V WHERE __id = ?", new Object[]{vertexId});){
            Optional optionalOVertex;
            if (query.hasNext() && (optionalOVertex = query.next().getVertex()).isPresent()) {
                theVertex = (OVertex)optionalOVertex.get();
            }
        }
        return theVertex;
    }

    private void removeTransaction(String vertexId) throws Exception {
        ODatabaseDocumentEmbedded graph = this.getGraph();
        OVertex currentVertex = this.getVertex(vertexId);
        if (currentVertex != null) {
            try {
                this.beginTransaction();
                this.removeVertexFor(currentVertex, graph);
                this.endTransaction();
            }
            catch (Exception e) {
                this.rollbackTransaction();
                throw e;
            }
        } else {
            LOGGER.severe(() -> "Failed to remove entity [" + vertexId + "]from the database. It is not in the DB.");
        }
    }

    private void removeVertexFor(OVertex vertex, ODatabaseDocumentEmbedded graph) {
        Optional<OVertex> parentVertex = OrientSystemDbConnection.getParentVertex(vertex);
        if (parentVertex.isPresent()) {
            OVertex currentParent = parentVertex.get();
            for (OEdge edge : vertex.getEdges(ODirection.OUT, new String[]{SCOPED_EDGE_LABEL})) {
                OVertex currentKidVertex = edge.getVertex(ODirection.IN);
                if (currentKidVertex.getProperty(ID).toString().equals(currentParent.getProperty(ID).toString())) {
                    graph.delete((ORecord)edge);
                    continue;
                }
                this.buildLightweightEdge(currentParent, currentKidVertex);
            }
        }
        graph.delete((ORecord)vertex);
    }

    private static Optional<OVertex> getParentVertex(OVertex vertex) {
        Iterator parentEdge = vertex.getEdges(ODirection.IN, new String[]{SCOPED_EDGE_LABEL}).iterator();
        OVertex parent = null;
        if (parentEdge.hasNext()) {
            parent = ((OEdge)parentEdge.next()).getVertex(ODirection.OUT);
        }
        return Optional.ofNullable(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doRemoveEntities(OrdTarget scope, OrdQuery query) throws Exception {
        int numRemoved;
        long start = DiagnosticUtil.startIfLoggable((String)"OrientSystemDbConnection.doRemoveEntities");
        try {
            if (this.permissionHook != null) {
                this.permissionHook.skipReadPermissionCheck = true;
            }
            numRemoved = AccessController.doPrivileged(() -> this.removeTransaction(scope, query));
        }
        finally {
            if (this.permissionHook != null) {
                this.permissionHook.skipReadPermissionCheck = false;
            }
            if (start > -1L) {
                DiagnosticUtil.complete((long)start, (String)"OrientSystemDbConnection.doRemoveEntities", (Object)(scope + ", " + query));
            }
        }
        return numRemoved;
    }

    private int removeTransaction(OrdTarget scope, OrdQuery query) throws Exception {
        AtomicInteger numRemoved = new AtomicInteger(0);
        ODatabaseDocumentEmbedded graph = this.getGraph();
        OResultSet toRemove = this.getVertices(scope, query);
        try {
            this.beginTransaction();
            while (toRemove.hasNext()) {
                OResult result = toRemove.next();
                OVertex idVertex = (OVertex)result.getVertex().get();
                try {
                    this.removeVertexFor(idVertex, graph);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                numRemoved.incrementAndGet();
            }
            this.endTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            numRemoved.set(0);
            throw e;
        }
        return numRemoved.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doRemoveStationEntities(String ... stationNames) throws Exception {
        Objects.requireNonNull(stationNames);
        long start = DiagnosticUtil.startIfLoggable((String)"OrientSystemDbConnection.doRemoveStationEntities");
        try {
            LinkedList<String> validStationNames = new LinkedList<String>();
            StringJoiner sj = new StringJoiner(",", "[", "]");
            sj.setEmptyValue("");
            for (String stationName : stationNames) {
                if (stationName == null || stationName.isEmpty()) continue;
                sj.add("?");
                validStationNames.add(stationName);
            }
            if (sj.length() == 0) {
                int n = 0;
                return n;
            }
            String deleteQuery = DELETE_STATION_QUERY_PREFIX + sj;
            int n = (Integer)this.executeTransaction(deleteQuery, validStationNames.toArray(EMPTY_STRING_ARRAY));
            return n;
        }
        finally {
            if (start > -1L) {
                StringJoiner allNames = new StringJoiner(", ");
                for (String name : stationNames) {
                    allNames.add(name);
                }
                DiagnosticUtil.complete((long)start, (String)"OrientSystemDbConnection.doRemoveStationEntities", (Object)allNames.toString());
            }
        }
    }

    private Object executeTransaction(String query, String ... stationNames) throws Exception {
        Object returnObject;
        try {
            this.getGraph();
            this.beginTransaction();
            returnObject = this.executeQuery(query, stationNames);
            this.endTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            throw e;
        }
        return returnObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doRemoveAllEntities() {
        long start = DiagnosticUtil.startIfLoggable((String)"OrientSystemDbConnection.doRemoveAllEntities");
        try {
            this.graph.activateOnCurrentThread();
            long numRemoved = this.graph.countClass("V");
            AccessController.doPrivileged(() -> {
                BOrientSystemDb orientSystemDb = (BOrientSystemDb)((BSystemDbService)Sys.getService((Type)BSystemDbService.TYPE)).getSystemDatabase();
                try {
                    this.dbEngine = orientSystemDb.deleteAndRebuildDatabase();
                    this.graph = null;
                    this.getGraph();
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
                return null;
            });
            long l = numRemoved;
            return l;
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"OrientSystemDbConnection.doRemoveAllEntities");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeQuery(String query, String ... stationNames) {
        long start = DiagnosticUtil.startIfLoggable((String)"OrientSystemDbConnection.executeQuery");
        try {
            OCommandSQL preparedQuery = new OCommandSQL(query);
            Object object = AccessController.doPrivileged(() -> {
                try {
                    return this.graph.command((OCommandRequest)preparedQuery).execute((Object[])stationNames);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Unable to get graph to query DB", e);
                    return null;
                }
            });
            return object;
        }
        finally {
            if (start > -1L) {
                StringJoiner output = new StringJoiner(", ");
                for (String name : stationNames) {
                    output.add(name);
                }
                DiagnosticUtil.complete((long)start, (String)"OrientSystemDbConnection.executeQuery", (Object)(query + ", " + output.toString()));
            }
        }
    }

    protected Collection<OVertex> getClosestDescOrds(ODatabaseDocumentEmbedded graph, OVertex srcVertex) {
        String srcOrdStr = srcVertex.getProperty(ID).toString();
        int parentLevel = srcOrdStr.split("/").length - 1;
        String regexpQuery = srcOrdStr.endsWith("/") ? "SELECT FROM V WHERE __id MATCHES '^" + srcOrdStr.replace("|", "\\\\|") + ".*'" : "SELECT FROM V WHERE __id MATCHES '^" + srcOrdStr.replace("|", "\\\\|") + "/.*'";
        OCommandSQL filterQuery = new OCommandSQL(regexpQuery);
        HashMap<String, OVertex> cache = new HashMap<String, OVertex>();
        Object closeableIterable = AccessController.doPrivileged(() -> graph.command((OCommandRequest)filterQuery).execute(new Object[0]));
        if (closeableIterable instanceof Collection) {
            for (Object objVertex : (Collection)closeableIterable) {
                String destId;
                OVertex tempVertex;
                OVertex destVertex = tempVertex = (OVertex)objVertex;
                String tempId = destId = destVertex.getProperty(ID).toString();
                if (cache.get(destId) != null || destId.length() <= srcOrdStr.length()) continue;
                boolean alreadyConnected = false;
                int currentLevel = tempId.split("/").length - 1;
                while (currentLevel > parentLevel) {
                    Iterator parentEdge = tempVertex.getEdges(ODirection.IN, new String[]{SCOPED_EDGE_LABEL}).iterator();
                    if (parentEdge.hasNext()) {
                        OEdge currentEdge = (OEdge)parentEdge.next();
                        tempVertex = currentEdge.getVertex(ODirection.OUT);
                        tempId = tempVertex.getProperty(ID).toString();
                        currentLevel = tempId.split("/").length - 1;
                        alreadyConnected = currentLevel == parentLevel;
                    } else {
                        currentLevel = -1;
                    }
                    if (currentLevel <= parentLevel) continue;
                    destVertex = tempVertex;
                    destId = tempId;
                }
                if (alreadyConnected) break;
                cache.put(destId, this.getVertex((String)destVertex.getProperty(ID)));
            }
        }
        return cache.values();
    }

    private void buildAncestorScopeEdge(ODatabaseDocumentEmbedded graph, OVertex src, OVertex dest) {
        Objects.requireNonNull(src, "target vertex is required. It can't be null");
        Iterable descendingScopeEdges = src.getEdges(ODirection.OUT, new String[]{SCOPED_EDGE_LABEL});
        String ordString = (String)dest.getProperty(ID);
        this.updateScope(StreamSupport.stream(descendingScopeEdges.spliterator(), false), ordString, graph, dest, ODirection.OUT);
        Iterator childEdges = dest.getEdges(ODirection.IN, new String[]{SCOPED_EDGE_LABEL}).iterator();
        if (!childEdges.hasNext()) {
            this.buildLightweightEdge(src, dest);
        }
    }

    Entity vertexToBasicEntity(OElement vertex, BOrd entityOrd, boolean includeRelations) {
        BasicEntity entity = entityOrd == null ? new BasicEntity(BOrd.make((String)vertex.getProperty(ID).toString())) : new BasicEntity(entityOrd);
        this.convertElementPropertiesToTags(vertex, entity.tags());
        if (includeRelations) {
            this.convertVertexEdgesToRelations((OVertex)vertex, ODirection.IN, entity.relations());
            this.convertVertexEdgesToRelations((OVertex)vertex, ODirection.OUT, entity.relations());
        }
        return entity;
    }

    private void convertVertexEdgesToRelations(OVertex vertex, ODirection direction, Relations relations) {
        vertex.getEdges(direction).forEach(edge -> {
            String label = ((OClass)edge.getSchemaType().get()).getName();
            if (!SCOPED_EDGE_LABEL.equals(label)) {
                TagSet tags = new TagSet();
                this.convertElementPropertiesToTags((OElement)edge, (Tags)tags);
                OVertex otherVertex = edge.getVertex(direction.opposite());
                relations.add((Relation)new BasicRelation(Id.newId((String)OrientSystemDbConnection.unescapeFromOrientForm(label)), BOrd.make((String)otherVertex.getProperty(ID).toString()), (Tags)tags, direction == ODirection.IN));
            }
        });
    }

    private void convertElementPropertiesToTags(OElement element, Tags tags) {
        Map<String, BIDataValue> tagIdsToDataValueType;
        Object tagTypes = element.getProperty("TagTypes");
        if (tagTypes == null) {
            tagIdsToDataValueType = COMMON_NON_INFERRABLE_TAG_CONVERSIONS;
        } else {
            tagIdsToDataValueType = new HashMap<String, BIDataValue>(COMMON_NON_INFERRABLE_TAG_CONVERSIONS);
            for (String tagIdAndTypeSymbol : tagTypes.toString().split(";")) {
                int idx = tagIdAndTypeSymbol.lastIndexOf(61);
                String tagId = tagIdAndTypeSymbol.substring(0, idx);
                char typeSymbol = tagIdAndTypeSymbol.charAt(idx + 1);
                tagIdsToDataValueType.put(tagId, (BIDataValue)DataTypes.getBySymbol((char)typeSymbol).getInstance());
            }
        }
        element.getPropertyNames().forEach(k -> this.convertToNiagaraTypes((String)k, tagIdsToDataValueType, element, tags));
    }

    private void convertToNiagaraTypes(String propertyName, Map<String, BIDataValue> tagIdsToDataValueType, OElement element, Tags tags) {
        if (OrientSystemDbConnection.isTagProperty(propertyName)) {
            Object tagVal;
            Object val = element.getProperty(propertyName);
            if (val instanceof OIdentifiable || val instanceof OAutoConvertToRecord) {
                return;
            }
            String tagIdStr = OrientSystemDbConnection.unescapeFromOrientForm(propertyName);
            if (val instanceof Boolean) {
                BIDataValue defaultVal = tagIdsToDataValueType.get(tagIdStr);
                tagVal = defaultVal != null ? BBoolean.make((boolean)((Boolean)val)) : BMarker.MARKER;
            } else if (val instanceof Double) {
                tagVal = BDouble.make((double)((Double)val));
            } else if (val instanceof Float) {
                tagVal = BFloat.make((float)((Float)val).floatValue());
            } else if (val instanceof Long) {
                BIDataValue defaultVal = tagIdsToDataValueType.get(tagIdStr);
                tagVal = defaultVal != null ? BRelTime.make((long)((Long)val)) : BLong.make((long)((Long)val));
            } else if (val instanceof Integer) {
                tagVal = BInteger.make((int)((Integer)val));
            } else if (val instanceof Date) {
                tagVal = BAbsTime.make((long)((Date)val).getTime());
            } else {
                BIDataValue defaultVal = tagIdsToDataValueType.get(tagIdStr);
                if (defaultVal != null) {
                    try {
                        tagVal = (BIDataValue)defaultVal.decodeFromString(val.toString());
                    }
                    catch (IOException e) {
                        throw new BajaRuntimeException((Throwable)e);
                    }
                } else {
                    tagVal = BString.make((String)val.toString());
                }
            }
            tags.set(Id.newId((String)tagIdStr), (BIDataValue)tagVal);
        }
    }

    static boolean isTagProperty(String vertexPropertyName) {
        return !IN_SCOPED_EDGE_LABEL.equals(vertexPropertyName) && !OUT_SCOPED_EDGE_LABEL.equals(vertexPropertyName) && !ID.equals(vertexPropertyName) && !"CategoryMask".equals(vertexPropertyName) && !"TagTypes".equals(vertexPropertyName);
    }

    public static String escapeToOrientForm(String unescapedName) {
        return orientEsc.escape(unescapedName);
    }

    public static String unescapeFromOrientForm(String escapedName) {
        return orientEsc.unescape(escapedName);
    }

    private void updateScope(Stream<OEdge> scopeEdges, String idString, ODatabaseDocumentEmbedded graph, OVertex src, ODirection direction) {
        String idStringToCheck = idString.endsWith("/") ? idString : idString + '/';
        scopeEdges.forEach(edge -> {
            OVertex parentVertex = edge.getVertex(direction.opposite());
            String descIdString = parentVertex.getProperty(ID).toString();
            if (descIdString.length() != idString.length() && descIdString.startsWith(idStringToCheck)) {
                this.buildLightweightEdge(src, parentVertex);
                graph.delete((ORecord)edge);
            }
        });
    }

    private static class EntityVertexPair {
        private final Entity entity;
        private OVertex vertex;

        EntityVertexPair(Entity entity) {
            this.entity = entity;
        }
    }

    static class NoGraphOpenException
    extends Exception {
        NoGraphOpenException(String msg) {
            super(msg);
        }
    }

    private static class OrientEsc
    extends EscUtil {
        private static final char ESCAPE_CHAR = '_';
        private static final byte[] orientCharMap = (byte[])charMap.clone();

        private OrientEsc() {
        }

        public boolean isStart(int c) {
            return c < 128 && (orientCharMap[c] & 2) != 0;
        }

        public boolean isPart(int c) {
            return c < 128 && (orientCharMap[c] & 4) != 0;
        }

        protected char getEscChar() {
            return '_';
        }

        protected byte[] getCharMap() {
            return orientCharMap;
        }

        static {
            OrientEsc.orientCharMap[95] = 0;
        }
    }
}

