/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb.orient;

import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBConfigBuilder;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BReachableStationInfo;
import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.nd.virtual.BNiagaraVirtualDeviceExt;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemDb.BSystemDbService;
import com.tridium.systemDb.orient.BDatabaseEncryptionState;
import com.tridium.systemDb.orient.NiagaraPermissionOrientHook;
import com.tridium.systemDb.orient.OrientSystemDbConnection;
import com.tridium.systemDb.orient.OrientSystemDbSpy;
import com.tridium.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.FileUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.tag.Entity;
import javax.baja.user.BUser;
import javax.baja.util.CloseableIterator;
import javax.baja.util.IFuture;
import javax.baja.virtual.VirtualPath;
import jnr.constants.PlatformConstants;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="databaseEncryption", type="BDatabaseEncryptionState", defaultValue="BDatabaseEncryptionState.encrypted", flags=5), @NiagaraProperty(name="orientDbServerConfigFile", type="BOrd", defaultValue="BOrd.make(\"module://orientSystemDb/rc/orientdb-server-config.xml\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:IFile\")")}), @NiagaraProperty(name="schemaVersion", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="excludedFromBackup", type="boolean", defaultValue="false", flags=4)})
@NiagaraAction(name="changeDatabaseEncryption", parameterType="BBoolean", defaultValue="BBoolean.TRUE", flags=148, facets={@Facet(name="BFacets.TRUE_TEXT", value="BString.make(\"%lexicon(orientSystemDb:orientSystemDb.enableEncryption)%\")"), @Facet(name="BFacets.FALSE_TEXT", value="BString.make(\"%lexicon(orientSystemDb:orientSystemDb.disableEncryption)%\")")})
public final class BOrientSystemDb
extends BSystemDb
implements IPropertyValidator {
    @Generated
    public static final Property databaseEncryption = BOrientSystemDb.newProperty((int)5, (BValue)BDatabaseEncryptionState.encrypted, null);
    @Generated
    public static final Property orientDbServerConfigFile = BOrientSystemDb.newProperty((int)0, (BValue)BOrd.make((String)"module://orientSystemDb/rc/orientdb-server-config.xml"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:IFile")));
    @Generated
    public static final Property schemaVersion = BOrientSystemDb.newProperty((int)5, (int)0, null);
    @Generated
    public static final Property excludedFromBackup = BOrientSystemDb.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Action changeDatabaseEncryption = BOrientSystemDb.newAction((int)148, (BValue)BBoolean.TRUE, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(orientSystemDb:orientSystemDb.enableEncryption)%")), (BFacets)BFacets.make((String)"falseText", (BIDataValue)BString.make((String)"%lexicon(orientSystemDb:orientSystemDb.disableEncryption)%"))));
    @Generated
    public static final Type TYPE = Sys.loadType(BOrientSystemDb.class);
    public static final String DISTINCT_TAG_FACET = "distinctTag";
    public static final String ID = "__id";
    private static final String VERTEX_INDEX_NAME = "V.__id";
    private static final String STATION = "n_3astation";
    private static final String STATION_INDEX_NAME = "V.n_3astation";
    private static final LazyEntityIterator emptyIterator = new LazyEntityIterator(Collections.emptyIterator(), null, false, false, null);
    private static final OServerEntryConfiguration[] EMPTY_CONFIG_ARRAY = new OServerEntryConfiguration[0];
    private static final String DATABASE_TYPE = "orientSystemDb";
    private static final String KEY_RING_ROOT_ALIAS = "orientSystemDb.root";
    private static final String KEY_RING_ADMIN_ALIAS = "orientSystemDb.admin";
    private static final String KEY_RING_DB_ALIAS = "orientSystemDb.database";
    private static final int ORIENT_V3_2_SCHEMA = 2;
    private static final boolean SHUTDOWN_ORIENT_SERVICES_ON_EXIT = false;
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private static final String DB_NAME = "systemDb";
    private static final String AES_ENCRYPTION_METHOD = "aes";
    private static final Context SET_ENCRYPTION_CONTEXT = new BasicContext();
    private OServer server;
    private String serverPath;
    private OrientDB dbEngine;
    private final AtomicBoolean resettingDb = new AtomicBoolean(false);
    private final Object OSERVER_MUTEX = new Object();
    private BDatabaseEncryptionState currentEncryptionState = BDatabaseEncryptionState.encrypted;

    @Generated
    public BDatabaseEncryptionState getDatabaseEncryption() {
        return (BDatabaseEncryptionState)this.get(databaseEncryption);
    }

    @Generated
    public void setDatabaseEncryption(BDatabaseEncryptionState v) {
        this.set(databaseEncryption, (BValue)v, null);
    }

    @Generated
    public BOrd getOrientDbServerConfigFile() {
        return (BOrd)this.get(orientDbServerConfigFile);
    }

    @Generated
    public void setOrientDbServerConfigFile(BOrd v) {
        this.set(orientDbServerConfigFile, (BValue)v, null);
    }

    @Generated
    public int getSchemaVersion() {
        return this.getInt(schemaVersion);
    }

    @Generated
    public void setSchemaVersion(int v) {
        this.setInt(schemaVersion, v, null);
    }

    @Generated
    public boolean getExcludedFromBackup() {
        return this.getBoolean(excludedFromBackup);
    }

    @Generated
    public void setExcludedFromBackup(boolean v) {
        this.setBoolean(excludedFromBackup, v, null);
    }

    @Generated
    public void changeDatabaseEncryption(BBoolean parameter) {
        this.invoke(changeDatabaseEncryption, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BValue getActionParameterDefault(Action action) {
        if (changeDatabaseEncryption.equals(action)) {
            BComponentSpace space = this.getComponentSpace();
            if (space == null || !space.isProxyComponentSpace() && !this.isRunning()) {
                throw new LocalizableRuntimeException(DATABASE_TYPE, "orientSystemDb.illegalOfflineEncryptionChange");
            }
            if (this.getDatabaseEncryption().equals((Object)BDatabaseEncryptionState.changingToEncrypted) || this.getDatabaseEncryption().equals((Object)BDatabaseEncryptionState.changingToUnencrypted)) {
                throw new LocalizableRuntimeException(DATABASE_TYPE, "orientSystemDb.encryptionChangeInProgress");
            }
        }
        return super.getActionParameterDefault(action);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (changeDatabaseEncryption.equals(action)) {
            if (!this.isRunning()) {
                throw new LocalizableRuntimeException(DATABASE_TYPE, "orientSystemDb.illegalOfflineEncryptionChange");
            }
            boolean enableEncryption = ((BIBoolean)argument).getBoolean();
            BDatabaseEncryptionState currentState = this.getDatabaseEncryption();
            if (enableEncryption && (currentState.equals((Object)BDatabaseEncryptionState.encrypted) || currentState.equals((Object)BDatabaseEncryptionState.changingToEncrypted))) {
                return null;
            }
            if (!enableEncryption && (currentState.equals((Object)BDatabaseEncryptionState.unencrypted) || currentState.equals((Object)BDatabaseEncryptionState.changingToUnencrypted))) {
                return null;
            }
            if (currentState.equals((Object)BDatabaseEncryptionState.changingToEncrypted) || currentState.equals((Object)BDatabaseEncryptionState.changingToUnencrypted)) {
                throw new LocalizableRuntimeException(DATABASE_TYPE, "orientSystemDb.encryptionChangeInProgress");
            }
            this.set(databaseEncryption, (BValue)(enableEncryption ? BDatabaseEncryptionState.changingToEncrypted : BDatabaseEncryptionState.changingToUnencrypted), SET_ENCRYPTION_CONTEXT);
        }
        return super.post(action, argument, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doChangeDatabaseEncryption(BBoolean enableEncryption) {
        Object object = this.OSERVER_MUTEX;
        synchronized (object) {
            boolean encrypt = enableEncryption.getBoolean();
            if (encrypt && this.getDatabaseEncryption().equals((Object)BDatabaseEncryptionState.encrypted) || !encrypt && this.getDatabaseEncryption().equals((Object)BDatabaseEncryptionState.unencrypted)) {
                return;
            }
            this.set(databaseEncryption, (BValue)(encrypt ? BDatabaseEncryptionState.changingToEncrypted : BDatabaseEncryptionState.changingToUnencrypted), SET_ENCRYPTION_CONTEXT);
            if (this.isDbServerRunning()) {
                this.checkForSchemaUpgradeOrEncryptionChange();
            }
        }
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (databaseEncryption.equals(property)) {
            return this;
        }
        return null;
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        if (ArrayUtil.indexOf((Object[])properties, (Object)databaseEncryption) >= 0) {
            return this;
        }
        return null;
    }

    public void validateSet(Validatable validatable, Context context) {
        Object[] props = validatable.getModifiedProperties();
        if (ArrayUtil.indexOf((Object[])props, (Object)databaseEncryption) >= 0) {
            throw new UnsupportedOperationException("Illegal attempt to directly set the databaseEncryption property. Use the changeDatabaseEncryption action instead.");
        }
    }

    public void started() {
        this.setFlags((Slot)databaseEncryption, this.getFlags((Slot)databaseEncryption) & 0xFFFFFFFB);
        this.setFlags((Slot)changeDatabaseEncryption, this.getFlags((Slot)changeDatabaseEncryption) & 0xFFFFFFFB);
        this.currentEncryptionState = this.getDatabaseEncryption();
        Spy.ROOT.add(DATABASE_TYPE, (Spy)new OrientSystemDbSpy((Object)this, 0));
    }

    public void stopped() throws Exception {
        Spy.ROOT.remove(DATABASE_TYPE);
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && databaseEncryption.equals(property)) {
            if (context == SET_ENCRYPTION_CONTEXT) {
                this.currentEncryptionState = this.getDatabaseEncryption();
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Illegal attempt to directly set the databaseEncryption property. Use the changeDatabaseEncryption action instead.");
                }
                this.set(databaseEncryption, (BValue)this.currentEncryptionState, SET_ENCRYPTION_CONTEXT);
                return;
            }
        }
        super.changed(property, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initializeDbServer() throws Exception {
        long start = DiagnosticUtil.startIfLoggable((String)"BOrientSystemDb.initializeDbServer");
        try {
            Object object = this.OSERVER_MUTEX;
            synchronized (object) {
                if (!this.isDbServerRunning() && !this.resettingDb.get()) {
                    this.checkForSchemaUpgradeOrEncryptionChange();
                    try {
                        BIFile orientServerConfigFile = (BIFile)this.getOrientDbServerConfigFile().get((BObject)this);
                        AccessController.doPrivileged(() -> {
                            block4: {
                                System.setProperty("ORIENTDB_HOME", this.getServerPath());
                                System.setProperty("orientdb.installCustomFormatter", "false");
                                if (!OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows)) {
                                    System.setProperty("jnr.ffi.library.path", "/usr/local/lib64" + File.pathSeparator + "/usr/lib64" + File.pathSeparator + "/lib64");
                                }
                                boolean platformConstantsFake = PlatformConstants.FAKE;
                                if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.log(Level.FINEST, "Warmed up PlatFormConstants class. PlatformConstants.FAKE = " + platformConstantsFake);
                                }
                                this.server = OServerMain.create((boolean)false);
                                OServerConfigurationManager configManager = new OServerConfigurationManager(orientServerConfigFile.getInputStream());
                                this.processConfiguration(configManager);
                                OGlobalConfiguration.SERVER_SECURITY_FILE.setValue((Object)OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/config/security.json"));
                                OGlobalConfiguration.SCRIPT_POLYGLOT_USE_GRAAL.setValue((Object)Boolean.FALSE);
                                OGlobalConfiguration.CREATE_DEFAULT_USERS.setValue((Object)Boolean.FALSE);
                                System.setProperty("ORIENTDB_ROOT_PASSWORD", BOrientSystemDb.getRootPassword());
                                configManager.setUser("root", BOrientSystemDb.getRootPassword(), "*");
                                this.server.startup(configManager.getConfiguration());
                                this.server.activate();
                                try {
                                    configManager.dropUser("guest");
                                    this.server.getSystemDatabase().execute(rs -> null, "delete from OUser where name = ?", new Object[]{"guest"});
                                }
                                catch (Throwable t) {
                                    if (!LOGGER.isLoggable(Level.INFO)) break block4;
                                    LOGGER.log(Level.INFO, "Could not delete Orient 'guest' user. Proceeding with initialization.", t);
                                }
                            }
                            return null;
                        });
                        boolean dbExists = AccessController.doPrivileged(() -> this.server.existsDatabase(DB_NAME));
                        if (this.dbEngine != null) {
                            this.dbEngine.close();
                        }
                        if (!dbExists) {
                            AccessController.doPrivileged(() -> {
                                OrientDBConfig configTemp;
                                OrientDBConfig config = this.getDatabaseEncryption().equals((Object)BDatabaseEncryptionState.unencrypted) || this.getDatabaseEncryption().equals((Object)BDatabaseEncryptionState.changingToUnencrypted) ? OrientDBConfig.defaultConfig() : (configTemp = OrientDBConfig.builder().addConfig(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD, (Object)AES_ENCRYPTION_METHOD).addConfig(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY, (Object)BOrientSystemDb.getDbEncryptionPassword()).build());
                                this.server.createDatabase(DB_NAME, ODatabaseType.PLOCAL, config);
                                return null;
                            });
                            AccessController.doPrivileged(() -> {
                                try (ODatabaseDocumentEmbedded connection = (ODatabaseDocumentEmbedded)this.server.openDatabase(DB_NAME, "root", BOrientSystemDb.getRootPassword());){
                                    BOrientSystemDb.setDateTimeFormat(connection);
                                    BOrientSystemDb.configureOrientDbUsers(connection);
                                }
                                return null;
                            });
                        }
                        this.dbEngine = this.server.getContext();
                        if (!this.getExcludedFromBackup()) {
                            this.excludeDirectoryFromBackup();
                        }
                        BOrientSystemDb.excludeFileFromBackup();
                        this.createIndex(VERTEX_INDEX_NAME, ID, OType.STRING);
                        this.createIndex(STATION_INDEX_NAME, STATION, OType.STRING);
                        try (ODatabaseDocumentAbstract localGraph = BOrientSystemDb.openDatabaseSession(this.dbEngine);){
                            String currentSelectedEncryption = localGraph.getConfiguration().getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD);
                            if (AES_ENCRYPTION_METHOD.equalsIgnoreCase(currentSelectedEncryption)) {
                                this.set(databaseEncryption, (BValue)BDatabaseEncryptionState.encrypted, SET_ENCRYPTION_CONTEXT);
                            } else {
                                this.set(databaseEncryption, (BValue)BDatabaseEncryptionState.unencrypted, SET_ENCRYPTION_CONTEXT);
                            }
                        }
                    }
                    catch (PrivilegedActionException e) {
                        throw e.getException();
                    }
                    catch (Exception e) {
                        throw new Exception("Unable to resolve Orient server config file.", e);
                    }
                }
            }
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"BOrientSystemDb.initializeDbServer");
        }
    }

    private void checkForSchemaUpgradeOrEncryptionChange() {
        boolean needsAlert;
        if ((this.getSchemaVersion() < 2 || this.getDatabaseEncryption().equals((Object)BDatabaseEncryptionState.changingToEncrypted) || this.getDatabaseEncryption().equals((Object)BDatabaseEncryptionState.changingToUnencrypted)) && (needsAlert = AccessController.doPrivileged(() -> {
            try {
                File orientSystemDbDirectory = new File(this.getServerPath());
                boolean deleteOccurred = false;
                if (orientSystemDbDirectory.exists()) {
                    this.deleteAndRebuildDatabase();
                    deleteOccurred = true;
                }
                this.setSchemaVersion(2);
                return deleteOccurred;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error rebuilding Orient System Db", e);
                throw new BajaRuntimeException("Error rebuilding Orient System Db. Unable to delete old DB files.", (Throwable)e);
            }
        }).booleanValue())) {
            this.dbRebuildAlert();
        }
    }

    private void dbRebuildAlert() {
        try {
            String lexiconMsg = this.getLexicon().getText("orientSystemDb.deleteAll.updateAlert");
            LOGGER.warning(lexiconMsg);
            BSystemDbService dbService = (BSystemDbService)this.getParent();
            String[] keys = new String[]{"hyperlinkOrd", "msgText"};
            BIDataValue[] values = new BIDataValue[]{BString.make((String)dbService.getNavOrd().relativizeToSession().toString()), BString.make((String)lexiconMsg)};
            AlarmSupport alarmSupport = (AlarmSupport)dbService.fw(502);
            BFacets facets = BFacets.make((String[])keys, (BIDataValue[])values);
            alarmSupport.newAlert(facets);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error alerting user about Orient System Db replacement.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(String indexName, String propertyName, OType propertyType) {
        long start = DiagnosticUtil.startIfLoggable((String)"BOrientSystemDb.createIndex");
        try (OrientSystemDbConnection connection = new OrientSystemDbConnection(this.dbEngine, null);){
            OClass vertexClass = connection.getGraph().getClass("V");
            AccessController.doPrivileged(() -> {
                if (vertexClass.getClassIndex(indexName) == null) {
                    if (vertexClass.getProperty(propertyName) == null) {
                        vertexClass.createProperty(propertyName, propertyType).setMandatory(false).setNotNull(false);
                    }
                    vertexClass.createIndex(indexName, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{propertyName});
                }
                return null;
            });
        }
        catch (Exception e) {
            if (BOrientSystemDb.getLogger().isLoggable(Level.WARNING)) {
                BOrientSystemDb.getLogger().log(Level.WARNING, "Unable to create an Orient index for " + propertyName, e);
            }
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"BOrientSystemDb.createIndex");
        }
    }

    private void excludeDirectoryFromBackup() {
        try {
            BComponent backupService = Sys.getService((Type)Sys.getType((String)"backup:BackupService"));
            if (backupService != null) {
                Property excludeDirProp = backupService.getProperty("excludeDirectories");
                Property offlineExcludeDirProp = backupService.getProperty("offlineExcludeDirectories");
                BOrd excludeOrd = BOrd.make((String)"file:^^orientSystemDb");
                BOrdList excludedDirList = (BOrdList)backupService.get(excludeDirProp).asValue();
                BOrdList offlineExcludedDirList = (BOrdList)backupService.get(offlineExcludeDirProp).asValue();
                boolean excludedDirExists = false;
                for (BOrd ord : excludedDirList) {
                    if (!ord.equals((Object)excludeOrd)) continue;
                    excludedDirExists = true;
                    break;
                }
                boolean offlineExcludedDirExists = false;
                for (BOrd ord : offlineExcludedDirList) {
                    if (!ord.equals((Object)excludeOrd)) continue;
                    offlineExcludedDirExists = true;
                    break;
                }
                if (!excludedDirExists || excludedDirList.isNull() || excludedDirList.size() == 0) {
                    excludedDirList = BOrdList.add((BOrdList)excludedDirList, (BOrd)excludeOrd);
                    backupService.set(excludeDirProp, (BValue)excludedDirList);
                }
                if (!offlineExcludedDirExists || offlineExcludedDirList.isNull() || offlineExcludedDirList.size() == 0) {
                    offlineExcludedDirList = BOrdList.add((BOrdList)offlineExcludedDirList, (BOrd)excludeOrd);
                    backupService.set(offlineExcludeDirProp, (BValue)offlineExcludedDirList);
                }
            }
            this.setExcludedFromBackup(true);
        }
        catch (Exception e) {
            LOGGER.info(() -> "OrientDb folder could not be added to the backup service exclude directories properties");
            LOGGER.log(Level.FINE, "", e);
        }
    }

    private static void excludeFileFromBackup() {
        try {
            BComponent backupService = Sys.getService((Type)Sys.getType((String)"backup:BackupService"));
            if (backupService != null) {
                Property excludeProp = backupService.getProperty("excludeFiles");
                Property offlineExcludeProp = backupService.getProperty("offlineExcludeFiles");
                String excludedFileList = ((BString)backupService.get(excludeProp).asValue()).getString();
                String offlineExcludedFileList = ((BString)backupService.get(offlineExcludeProp).asValue()).getString();
                if (!excludedFileList.contains("dirty.fl")) {
                    BString exclude = BString.make((String)(excludedFileList + ";dirty.fl"));
                    backupService.set(excludeProp, (BValue)exclude);
                }
                if (!offlineExcludedFileList.contains("dirty.fl")) {
                    BString offlineExclude = BString.make((String)(offlineExcludedFileList + ";dirty.fl"));
                    backupService.set(offlineExcludeProp, (BValue)offlineExclude);
                }
            }
        }
        catch (Exception e) {
            LOGGER.info(() -> "OrientDb dirty.fl file could not be added to the backup service exclude files properties.");
            LOGGER.log(Level.FINE, "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void shutdownDbServer() throws PrivilegedActionException {
        Object object = this.OSERVER_MUTEX;
        synchronized (object) {
            try {
                if (this.isDbServerRunning()) {
                    AccessController.doPrivileged(() -> {
                        if (this.dbEngine != null) {
                            this.dbEngine.close();
                            Orient.instance().shutdown();
                            this.dbEngine = null;
                        }
                        return this.server.shutdown();
                    });
                }
            }
            finally {
                NiagaraPermissionOrientHook.OPEN_CONNECTIONS.set(0);
                this.server = null;
            }
        }
    }

    protected final boolean isDbServerRunning() {
        return this.server != null && this.server.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OrientSystemDbConnection makeConnection(Context cx) throws Exception {
        long start = DiagnosticUtil.startIfLoggable((String)"BOrientSystemDb.makeConnection");
        try {
            if (this.isFatalFault()) {
                throw new LocalizableRuntimeException(DB_NAME, "systemDb.error.unavailable");
            }
            if (this.dbEngine == null || !this.dbEngine.isOpen()) {
                throw new IllegalStateException("No connection factory available for connection to the OrientSystemDb");
            }
            OrientSystemDbConnection connection = new OrientSystemDbConnection(this.dbEngine, cx);
            connection.connect();
            OrientSystemDbConnection orientSystemDbConnection = connection;
            return orientSystemDbConnection;
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"BOrientSystemDb.makeConnection");
        }
    }

    private String getServerPath() throws IOException {
        if (this.serverPath == null) {
            File protectedHome = Sys.getProtectedStationHome();
            this.serverPath = new File(protectedHome, DATABASE_TYPE).getCanonicalPath();
        }
        return this.serverPath;
    }

    private static boolean isTemporary(OElement vertex) {
        return vertex.getIdentity().getClusterId() < 0;
    }

    private void processConfiguration(OServerConfigurationManager configurationManager) {
        long start = DiagnosticUtil.startIfLoggable((String)"BOrientSystemDb.processConfiguration");
        if (configurationManager.getConfiguration().users != null) {
            Set users = configurationManager.getUsers();
            for (OServerUserConfiguration user : users) {
                configurationManager.dropUser(user.name);
                LOGGER.warning(() -> this.getLexicon().getText("orientSystemDb.processConfig.users", new Object[]{user.name}));
            }
        }
        ArrayList<OServerEntryConfiguration> properties = new ArrayList<OServerEntryConfiguration>();
        for (OServerEntryConfiguration property : configurationManager.getConfiguration().properties) {
            if (!"server.security.file".equalsIgnoreCase(property.name)) {
                properties.add(property);
                continue;
            }
            LOGGER.warning(() -> this.getLexicon().getText("orientSystemDb.processConfig.securityFile"));
        }
        configurationManager.getConfiguration().properties = properties.toArray(EMPTY_CONFIG_ARRAY);
        DiagnosticUtil.complete((long)start, (String)"BOrientSystemDb.processConfiguration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OrientDB deleteAndRebuildDatabase() throws Exception {
        long start = DiagnosticUtil.startIfLoggable((String)"BOrientSystemDb.deleteAndRebuildDatabase");
        try {
            boolean wasRunning = this.isDbServerRunning();
            if (this.resettingDb.compareAndSet(false, true)) {
                try {
                    if (wasRunning) {
                        this.doStopDatabase();
                    }
                    FileUtil.delete((File)new File(this.getServerPath()));
                }
                finally {
                    this.resettingDb.set(false);
                }
                if (wasRunning) {
                    this.doStartDatabase();
                }
            }
            OrientDB orientDB = this.dbEngine;
            return orientDB;
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"BOrientSystemDb.deleteAndRebuildDatabase");
        }
    }

    private static void setDateTimeFormat(ODatabaseDocumentEmbedded orientGraph) {
        if (!orientGraph.get(ODatabase.ATTRIBUTES.DATETIMEFORMAT).equals(DATE_TIME_FORMAT)) {
            AccessController.doPrivileged(() -> {
                orientGraph.set(ODatabase.ATTRIBUTES.DATETIMEFORMAT, (Object)DATE_TIME_FORMAT);
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void configureOrientDbUsers(ODatabaseDocumentEmbedded orientGraph) {
        long start = DiagnosticUtil.startIfLoggable((String)"BOrientSystemDb.configureOrientDbUsers");
        try {
            OSecurity oSecurity = orientGraph.getMetadata().getSecurity();
            boolean retry = true;
            int count = 0;
            while (retry) {
                retry = false;
                try {
                    ODocument document;
                    OUser adminUser = oSecurity.getUser("admin");
                    if (adminUser != null) {
                        adminUser.setPassword(OUser.encryptPassword((String)BOrientSystemDb.getAdminPassword()));
                        document = adminUser.getDocument();
                        document.getDatabase().save((Object)document);
                        orientGraph.commit();
                    } else {
                        oSecurity.createUser("admin", OUser.encryptPassword((String)BOrientSystemDb.getAdminPassword()), new ORole[]{oSecurity.getRole("admin")});
                        orientGraph.commit();
                        adminUser = oSecurity.getUser("admin");
                    }
                    document = adminUser.getDocument();
                    document.getDatabase().save((Object)document);
                }
                catch (OConcurrentCreateException e) {
                    if (++count >= 5) throw e;
                    retry = true;
                    continue;
                    return;
                }
            }
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"BOrientSystemDb.configureOrientDbUsers");
        }
    }

    private static String getRootPassword() {
        if (KeyRingAttributeHolder.KEY_RING_ROOT_HEX_PSWD == null) {
            throw new SecurityException("Could not acquire Niagara OrientDb password for root user");
        }
        return KeyRingAttributeHolder.KEY_RING_ROOT_HEX_PSWD;
    }

    private static String getAdminPassword() {
        if (KeyRingAttributeHolder.KEY_RING_ADMIN_HEX_PSWD == null) {
            throw new SecurityException("Could not acquire Niagara OrientDb password for admin user");
        }
        return KeyRingAttributeHolder.KEY_RING_ADMIN_HEX_PSWD;
    }

    private static String getDbEncryptionPassword() {
        if (KeyRingAttributeHolder.KEY_RING_DB_BASE64_PSWD == null) {
            throw new SecurityException("Could not acquire Niagara OrientDb password for database encryption");
        }
        return KeyRingAttributeHolder.KEY_RING_DB_BASE64_PSWD;
    }

    static ODatabaseDocumentAbstract openDatabaseSession(OrientDB dbEngine) {
        if (KeyRingAttributeHolder.ORIENT_DB_CONFIG_BUILDER == null) {
            throw new SecurityException("Could not acquire OrientDBConfig for database encryption");
        }
        return AccessController.doPrivileged(() -> (ODatabaseDocumentAbstract)dbEngine.open(DB_NAME, "admin", BOrientSystemDb.getAdminPassword(), KeyRingAttributeHolder.ORIENT_DB_CONFIG_BUILDER.build()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkLicense() {
        long start = DiagnosticUtil.startIfLoggable((String)"OrientSystemDb.checkLicense");
        try {
            Feature feature = Sys.getLicenseManager().getFeature("tridium", DB_NAME);
            feature.check();
            if (!feature.getb("orientDb", false)) {
                throw new FeatureNotLicensedException("\"systemDb\" feature is missing enabled \"orientDb\" attribute");
            }
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"OrientSystemDb.checkLicense");
        }
    }

    public void spy(SpyWriter out) throws Exception {
        if (Sys.isStation()) {
            this.spyOrientTotals(out, true);
        }
        super.spy(out);
    }

    void spyOrientTotals(SpyWriter out, boolean addLinkToOrientSpy) {
        out.startProps();
        out.trTitle((Object)"OrientDB Diagnostics", 2);
        out.prop((Object)"Open DB Connections", NiagaraPermissionOrientHook.OPEN_CONNECTIONS.get());
        if (this.isDbServerRunning()) {
            try (OrientSystemDbConnection conn2 = this.makeConnection(null);){
                out.prop((Object)"Total Vertices (Entities) in DB", (int)conn2.getGraph().countClass("V"));
                out.prop((Object)"Total Edges in DB", (int)conn2.getGraph().countClass("E"));
            }
            catch (Exception conn2) {
                // empty catch block
            }
        }
        if (addLinkToOrientSpy) {
            String orientSpyOrd = "spy:/orientSystemDb";
            out.propValueLink((Object)"Detailed Orient Spy", (Object)orientSpyOrd, (Object)orientSpyOrd);
        }
        out.endProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableIterator<Entity> doQuery(OrdTarget scope, OrdQuery query, boolean useLightweightResults, boolean includeLightweightRelations) {
        long start = DiagnosticUtil.startIfLoggable((String)"BOrientSystemDb.doQuery");
        try {
            LazyEntityIterator entityIterator = emptyIterator;
            try {
                OrientSystemDbConnection connection = this.makeConnection((Context)scope);
                if (connection.permissionHook != null && (scope == null || scope.getFacets().gets(DISTINCT_TAG_FACET, null) == null)) {
                    connection.permissionHook.skipReadPermissionCheck = true;
                }
                OResultSet resultSet = connection.getVertices(scope, query);
                entityIterator = new LazyEntityIterator((Iterator)resultSet, connection, useLightweightResults, includeLightweightRelations, BReachableStations.findAllReachableStations((BObject)this, (boolean)false, (boolean)true, (boolean)false, (Context)scope, (String[])new String[0]));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, () -> String.format("Unexpected exception : %s", e.getMessage()));
                throw new RuntimeException(e);
            }
            LazyEntityIterator lazyEntityIterator = entityIterator;
            return lazyEntityIterator;
        }
        finally {
            if (start > -1L) {
                DiagnosticUtil.complete((long)start, (String)"BOrientSystemDb.doQuery", (Object)(scope + ", " + query));
            }
        }
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    private static class LazyEntityIterator
    implements CloseableIterator<Entity> {
        private final Iterator<OResult> vertices;
        private OrientSystemDbConnection connection;
        private final BUser user;
        private final BCategoryService categoryService;
        private final boolean useLightweightResults;
        private final boolean includeLightweightRelations;
        private final BNiagaraNetwork niagaraNetwork;
        private final String localStationName;
        private final Map<String, List<BReachableStationInfo>> reachableStationInfos;
        private boolean hasNextCalled;
        private Entity next;

        private LazyEntityIterator(Iterator<OResult> vertices, OrientSystemDbConnection connection, boolean useLightweightResults, boolean includeLightweightRelations, Map<String, List<BReachableStationInfo>> reachableStationInfos) {
            this.vertices = vertices;
            if (connection != null) {
                this.connection = connection;
                this.user = NiagaraPermissionOrientHook.computeNiagaraUser(connection.cx);
                this.categoryService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
                this.useLightweightResults = useLightweightResults;
                this.includeLightweightRelations = useLightweightResults && includeLightweightRelations;
                this.reachableStationInfos = reachableStationInfos;
                this.localStationName = Sys.getStation().getStationName();
                this.niagaraNetwork = Sys.findService((Type)BNiagaraNetwork.TYPE).orElse(null);
            } else {
                this.connection = null;
                this.user = null;
                this.categoryService = null;
                this.useLightweightResults = false;
                this.includeLightweightRelations = false;
                this.reachableStationInfos = null;
                this.localStationName = null;
                this.niagaraNetwork = null;
            }
        }

        public boolean hasNext() {
            if (!this.hasNextCalled) {
                this.hasNextCalled = true;
                this.next = this.computeNext();
            }
            return this.next != null;
        }

        public Entity next() {
            if (!this.hasNextCalled) {
                this.next = this.computeNext();
            }
            this.hasNextCalled = false;
            if (this.next == null) {
                throw new NoSuchElementException("There are no more elements in the iterator");
            }
            return this.next;
        }

        private Entity computeNext() {
            if (this.connection == null) {
                return null;
            }
            Entity entity = null;
            try {
                this.connection.getGraph();
                while (entity == null && this.vertices.hasNext()) {
                    OResult result = this.vertices.next();
                    entity = this.getEntity(result.toElement());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Connection to Orient DB was lost", e);
            }
            return entity;
        }

        private Entity getEntity(OElement vertex) {
            Entity obj = null;
            BOrd ord = null;
            OrdQuery[] queries = null;
            Exception e = null;
            BNiagaraVirtualDeviceExt gateway = null;
            BOrd virtualOrd = null;
            try {
                String stationName;
                if (BOrientSystemDb.isTemporary(vertex)) {
                    return this.connection.vertexToBasicEntity(vertex, BOrd.NULL, false);
                }
                ord = BOrd.make((String)vertex.getProperty(BOrientSystemDb.ID).toString());
                queries = ord.parse();
                OrdQuery nspaceQuery = queries[0];
                if ("nspace".equals(nspaceQuery.getScheme()) && !this.localStationName.equals(stationName = nspaceQuery.getBody())) {
                    BNiagaraStation station = (BNiagaraStation)this.niagaraNetwork.getStation(stationName);
                    if (station != null && station.getEnabled()) {
                        gateway = station.getVirtual();
                        if (this.user != null && !this.user.getPermissions().isSuperUser() && !this.hasOperatorReadPermission(virtualOrd = LazyEntityIterator.computeVirtualOrd((BComponent)gateway, queries), (BComponent)gateway)) {
                            return null;
                        }
                        if (this.useLightweightResults) {
                            if (virtualOrd == null) {
                                virtualOrd = LazyEntityIterator.computeVirtualOrd((BComponent)gateway, queries);
                            }
                            obj = this.connection.vertexToBasicEntity(vertex, virtualOrd, this.includeLightweightRelations);
                        }
                    } else {
                        List<BReachableStationInfo> infosForStation = this.reachableStationInfos.get(stationName);
                        BReachableStationInfo bestInfo = null;
                        if (infosForStation != null && !infosForStation.isEmpty()) {
                            for (BReachableStationInfo info : infosForStation) {
                                if (info.getRouteEnabled() && !info.getReachableStationsContainer().isDisabled()) {
                                    bestInfo = info;
                                    break;
                                }
                                if (bestInfo != null) continue;
                                bestInfo = info;
                            }
                        }
                        if (bestInfo != null) {
                            for (int i = 1; i < queries.length; ++i) {
                                String body;
                                if (!(queries[i] instanceof SlotPath)) continue;
                                queries[i] = VirtualPath.convertFromSlotPath((SlotPath)((SlotPath)queries[i]));
                                if (i != 1 || !(body = queries[1].getBody()).startsWith("/")) continue;
                                queries[1] = body.length() == 1 ? VirtualPath.EMPTY_VIRTUAL_PATH : new VirtualPath(body.substring(1));
                            }
                            virtualOrd = BOrd.make((BOrd)bestInfo.getVirtualSpaceOrd(), (BOrd)BOrd.make((OrdQuery[])queries, (int)1, (int)queries.length)).normalize();
                            if (!this.hasOperatorReadPermission(virtualOrd, (BComponent)(gateway = bestInfo.getReachableStationsContainer().getNiagaraStation().getVirtual()))) {
                                return null;
                            }
                            if (this.useLightweightResults) {
                                obj = this.connection.vertexToBasicEntity(vertex, virtualOrd, this.includeLightweightRelations);
                            }
                        }
                    }
                }
                if (obj == null) {
                    obj = (Entity)ord.get();
                }
            }
            catch (Exception ex) {
                e = ex;
            }
            if (obj == null) {
                BOrd ordToLog = ord;
                LOGGER.log(Level.FINE, e, () -> "Could not resolve SystemDb Entity for ORD: " + ordToLog + ". Reverting to lightweight result for SystemDb Entity.");
                if (virtualOrd == null && gateway != null) {
                    virtualOrd = LazyEntityIterator.computeVirtualOrd(gateway, queries);
                }
                obj = this.connection.vertexToBasicEntity(vertex, virtualOrd != null ? virtualOrd : ord, !this.useLightweightResults || this.includeLightweightRelations);
            }
            if (this.user != null && obj instanceof BIProtected && !this.user.getPermissionsFor((BIProtected)obj).hasOperatorRead()) {
                return null;
            }
            return obj;
        }

        private static BOrd computeVirtualOrd(BComponent virtualGateway, OrdQuery[] queries) {
            for (int i = 1; i < queries.length; ++i) {
                if (!(queries[i] instanceof SlotPath)) continue;
                queries[i] = VirtualPath.convertFromSlotPath((SlotPath)((SlotPath)queries[i]));
            }
            return BOrd.make((BOrd)virtualGateway.getNavOrd().relativizeToSession(), (BOrd)BOrd.make((OrdQuery[])queries, (int)1, (int)queries.length)).normalize();
        }

        private boolean hasOperatorReadPermission(BOrd virtualOrd, BComponent gateway) {
            if (this.user == null || this.user.getPermissions().isSuperUser()) {
                return true;
            }
            BCategoryMask mask = this.categoryService.getOrdMap().getAppliedCategoryMask(virtualOrd);
            if (mask == null) {
                mask = gateway.getAppliedCategoryMask();
            }
            BPermissions permissions = this.user.getPermissions().getCategoryPermissions(mask);
            return permissions.hasOperatorRead();
        }

        public void close() {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class KeyRingAttributeHolder {
        private static final String KEY_RING_ROOT_HEX_PSWD;
        private static final String KEY_RING_ADMIN_HEX_PSWD;
        private static final String KEY_RING_DB_BASE64_PSWD;
        private static final OrientDBConfigBuilder ORIENT_DB_CONFIG_BUILDER;

        private KeyRingAttributeHolder() {
        }

        private static byte[] getPasswordFromKeyRing(String keyAlias) {
            try {
                return (byte[])AccessController.doPrivileged(() -> {
                    KeyRing keyRing = SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing();
                    byte[] k = keyRing.getKey(keyAlias);
                    if (k == null) {
                        k = keyRing.createKey(keyAlias, true);
                    }
                    return k;
                });
            }
            catch (PrivilegedActionException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Could not acquire Niagara OrientDb password for keyAlias: " + keyAlias, e);
                }
                throw new SecurityException("Could not acquire Niagara OrientDb password for keyAlias: " + keyAlias);
            }
        }

        static {
            OrientDBConfigBuilder configBuilder;
            String str;
            try {
                str = ByteArrayUtil.toHexString((byte[])KeyRingAttributeHolder.getPasswordFromKeyRing(BOrientSystemDb.KEY_RING_ROOT_ALIAS));
            }
            catch (Exception e) {
                str = null;
            }
            KEY_RING_ROOT_HEX_PSWD = str;
            try {
                str = ByteArrayUtil.toHexString((byte[])KeyRingAttributeHolder.getPasswordFromKeyRing(BOrientSystemDb.KEY_RING_ADMIN_ALIAS));
            }
            catch (Exception e) {
                str = null;
            }
            KEY_RING_ADMIN_HEX_PSWD = str;
            try {
                str = Base64.getEncoder().encodeToString(KeyRingAttributeHolder.getPasswordFromKeyRing(BOrientSystemDb.KEY_RING_DB_ALIAS));
                configBuilder = OrientDBConfig.builder().addConfig(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY, (Object)str);
            }
            catch (Exception e) {
                str = null;
                configBuilder = null;
            }
            KEY_RING_DB_BASE64_PSWD = str;
            ORIENT_DB_CONFIG_BUILDER = configBuilder;
        }
    }
}

