/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.mysql;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.jdbc.trans.BSqlType;
import com.tridium.rdb.mysql.BMySQLDatabase;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.baja.history.BTrendFlags;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"rdbMySQL:MySQLDatabase"})})
public class BMySQLDeprecatedDialect
extends BRdbmsDeprecatedDialect {
    @Generated
    public static final Type TYPE = Sys.loadType(BMySQLDeprecatedDialect.class);
    private static final boolean useBigintDataTypeForIdColumn = AccessController.doPrivileged(() -> System.getProperty("niagara.rdb.useBigintDataTypeForIdColumn", "false")).equals("true");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean tableExists(BRdbms db, Connection conn, String tableName) throws SQLException {
        try (ResultSet rs = conn.getMetaData().getTables(((BMySQLDatabase)db).getDatabaseName(), null, tableName, new String[]{"TABLE"});){
            boolean bl = rs.next();
            return bl;
        }
    }

    public String makeCreateTableSql(String name, Property[] template, String[] extraFields, Type[] extraFieldTypes, BFacets[] extraFacets) {
        String sql = super.makeCreateTableSql(name, template, extraFields, extraFieldTypes, extraFacets);
        if (this.database != null && this.database.getUseUnicodeEncodingScheme()) {
            return sql + " CHARACTER SET utf8 COLLATE utf8_unicode_ci";
        }
        return super.makeCreateTableSql(name, template, extraFields, extraFieldTypes, extraFacets);
    }

    public String makeAddColumnSql(String tableName, String columnName, BSqlType columnType, int columnSize, String defaultValue) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(tableName).append(" ");
        sql.append("ADD COLUMN ").append(columnName).append(" ").append(this.getDataType(columnType) + "(" + columnSize + ") ");
        if (columnType.equals((Object)BSqlType.sqlNVarchar)) {
            sql.append("CHARACTER SET utf8 COLLATE utf8_unicode_ci ");
        }
        sql.append("NOT NULL DEFAULT ");
        if (columnType.equals((Object)BSqlType.sqlVarchar) || columnType.equals((Object)BSqlType.sqlNVarchar)) {
            defaultValue = "'" + defaultValue + "'";
        }
        sql.append(defaultValue);
        return sql.toString();
    }

    public String makeAlterColumnTypeSql(String tableName, String columnName, BSqlType targetType, int columnSize) {
        String sql = "ALTER TABLE " + tableName + " MODIFY COLUMN " + columnName + " " + this.getDataType(targetType) + "(" + columnSize + ")";
        if (targetType.equals((Object)BSqlType.sqlNVarchar)) {
            sql = sql + " CHARACTER SET utf8 COLLATE utf8_unicode_ci";
        }
        return sql;
    }

    public String makeCreateIndexSql(String indexName, String tableName, String columnNames, boolean online) {
        String idx = "CREATE INDEX " + indexName + " ON " + tableName + " (" + columnNames + ") LOCK=NONE";
        return idx;
    }

    public String makeDropIndexSql(String indexName, String tableName) {
        return "DROP INDEX " + indexName + " ON " + tableName;
    }

    public String getSqlType(Type type, BFacets facets) {
        int width = this.getVarcharSize(facets);
        if (type.equals(BString.TYPE)) {
            return "VARCHAR(" + width + ")";
        }
        if (type.equals(BInteger.TYPE)) {
            return "INT";
        }
        if (type.equals(BLong.TYPE)) {
            return "BIGINT";
        }
        if (type.equals(BFloat.TYPE)) {
            return "FLOAT";
        }
        if (type.equals(BDouble.TYPE)) {
            return "DOUBLE";
        }
        if (type.equals(BAbsTime.TYPE)) {
            return "BIGINT";
        }
        if (type.equals(BRelTime.TYPE)) {
            return "BIGINT";
        }
        if (type.equals(BBoolean.TYPE)) {
            return "TINYINT";
        }
        if (type.equals(BStatus.TYPE)) {
            return "INT";
        }
        if (type.equals(BTrendFlags.TYPE)) {
            return "INT";
        }
        return "VARCHAR(" + width + ")";
    }

    public long getTimestampAccuracy() {
        return 1L;
    }

    public String getPrimaryKeySql() {
        if (useBigintDataTypeForIdColumn) {
            return "BIGINT AUTO_INCREMENT PRIMARY KEY";
        }
        return "INT AUTO_INCREMENT PRIMARY KEY";
    }

    public int getMaxTableName() {
        return 64;
    }

    public int getMaxIndexName() {
        return 64;
    }

    public int getMaxColumnName() {
        return 64;
    }

    public int getMaxSequenceName() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSequences() {
        return false;
    }

    public boolean allowsUnicode() {
        return true;
    }

    public String makeColumnName(String name) {
        return name;
    }

    public boolean supportsTimestamp() {
        return false;
    }
}

