/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.mysql;

import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.rdb.BEncryptableTransportRdbms;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.mysql.BMySQLConnectionPool;
import com.tridium.rdb.mysql.BMySQLConnectionPoolWithCredentials;
import com.tridium.rdb.mysql.history.BMySQLHistoryDeviceExt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timestampStorage", type="BRdbmsTimestampStorage", defaultValue="BRdbmsTimestampStorage.dialectDefault", flags=5, override=true), @NiagaraProperty(name="databaseName", type="String", defaultValue=""), @NiagaraProperty(name="port", type="int", defaultValue="3306"), @NiagaraProperty(name="histories", type="BMySQLHistoryDeviceExt", defaultValue="new BMySQLHistoryDeviceExt()"), @NiagaraProperty(name="connectionPool", type="BMySQLConnectionPool", defaultValue="new BMySQLConnectionPool()", flags=4), @NiagaraProperty(name="extraConnectionProperties", type="String", defaultValue=""), @NiagaraProperty(name="mySqlServerCert", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:UserTrustCertificateAliasFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:CertificateAliasEditor\"))"), @Facet(value="BFacets.make(\"storeId\", BString.make(\"USER_TRUST_STORE\"))"), @Facet(value="BFacets.make(\"purposeId\", BString.make(\"\"))")}), @NiagaraProperty(name="nonPrivilegedConnectionPool", type="BMySQLConnectionPoolWithCredentials", defaultValue="new BMySQLConnectionPoolWithCredentials()", flags=4)})
public class BMySQLDatabase
extends BEncryptableTransportRdbms {
    @Generated
    public static final Property timestampStorage = BMySQLDatabase.newProperty((int)5, (BValue)BRdbmsTimestampStorage.dialectDefault, null);
    @Generated
    public static final Property databaseName = BMySQLDatabase.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property port = BMySQLDatabase.newProperty((int)0, (int)3306, null);
    @Generated
    public static final Property histories = BMySQLDatabase.newProperty((int)0, (BValue)new BMySQLHistoryDeviceExt(), null);
    @Generated
    public static final Property connectionPool = BMySQLDatabase.newProperty((int)4, (BValue)new BMySQLConnectionPool(), null);
    @Generated
    public static final Property extraConnectionProperties = BMySQLDatabase.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property mySqlServerCert = BMySQLDatabase.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:UserTrustCertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"storeId", (BIDataValue)BString.make((String)"USER_TRUST_STORE"))), (BFacets)BFacets.make((String)"purposeId", (BIDataValue)BString.make((String)""))));
    @Generated
    public static final Property nonPrivilegedConnectionPool = BMySQLDatabase.newProperty((int)4, (BValue)new BMySQLConnectionPoolWithCredentials(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMySQLDatabase.class);
    private final RdbmsDialect DIALECT = new RdbmsDialect(){

        public String getValidationQuery() {
            return "select 1;";
        }

        public void issueCheckpoint(Connection conn) throws SQLException {
        }

        public boolean supportsBatchInsert() {
            return true;
        }

        public boolean supportsBatchUpdate() {
            return true;
        }

        public boolean supportsBatchDelete() {
            return true;
        }

        public int getInsertionMode() {
            return 1;
        }

        public String getIdentityCreation() {
            return "AUTO_INCREMENT";
        }

        public String getIdentityLookup() {
            throw new UnsupportedOperationException();
        }

        public String getSequenceName(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getSequenceLookup(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getAlterColumn() {
            return "MODIFY";
        }

        public String getAlterColumnSuffix() {
            return null;
        }

        public boolean getAlterColumnSupportsNotNull() {
            return true;
        }

        public String getStringLengthFunctionName() {
            return "CHAR_LENGTH";
        }

        public int getMaxTableName() {
            return 64;
        }

        public int getMaxIndexName() {
            return 64;
        }

        public int getMaxConstraintName() {
            return 64;
        }

        public int getMaxColumnName() {
            return 64;
        }

        public boolean allowsUnicodeNames() {
            return true;
        }

        public String getColumnIdentifier(String schemaName, String tableName, String columnName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName + ".`" + columnName + "`";
            }
            return tableName + ".`" + columnName + "`";
        }

        public String getTableIdentifier(String schemaName, String tableName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName;
            }
            return tableName;
        }

        public String getDropIndex(String tableName, String indexName) {
            return "ALTER TABLE " + tableName + " DROP INDEX " + indexName;
        }

        public String getDropConstraint(String tableName, Constraint constraint) {
            String keyword = "CONSTRAINT";
            if (constraint.getConstraintType() == 1) {
                keyword = "PRIMARY KEY";
            } else if (constraint.getConstraintType() == 2) {
                keyword = "FOREIGN KEY";
            }
            return "ALTER TABLE " + tableName + " DROP  " + keyword + " " + constraint.getName();
        }

        public String getIntType() {
            return "INTEGER";
        }

        public String getLongType() {
            return "BIGINT";
        }

        public String getFloatType() {
            return "FLOAT";
        }

        public String getDoubleType() {
            return "DOUBLE";
        }

        public String getCharType() {
            return BMySQLDatabase.this.getUseUnicodeEncodingScheme() ? "NCHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BMySQLDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR" : "VARCHAR";
        }

        public String getUuidType() {
            return "BINARY(16)";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getBooleanType() {
            return "TINYINT";
        }

        public String getTimestampType() {
            throw new UnsupportedOperationException();
        }

        public boolean supportsBooleanType() {
            return true;
        }

        public boolean supportsDateType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return false;
        }

        public boolean useUtcTimestamps() {
            return false;
        }

        public String getBlobType() {
            return "MEDIUMBLOB";
        }

        public boolean usesDefaultBlobTranslator() {
            return true;
        }

        public void setBlobValue(RdbmsPreparedStatement prep, int index, byte[] bytes) {
            throw new UnsupportedOperationException();
        }

        public String getClobType() {
            if (!BMySQLDatabase.this.getUseUnicodeEncodingScheme()) {
                return "TEXT";
            }
            return "TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci";
        }

        public boolean usesDefaultClobTranslator() {
            return true;
        }

        public void setClobValue(RdbmsPreparedStatement prep, int index, String str) {
            throw new UnsupportedOperationException();
        }

        public AesSysKeyEncoder getSysEncoder() {
            return BMySQLDatabase.this.getEncoder();
        }

        public String getOnDelete(int onDelete) {
            switch (onDelete) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "NO ACTION";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return true;
        }

        public boolean supportsRenameTable() {
            return false;
        }

        public boolean supportsClusteredIndex() {
            return false;
        }

        public int getJdbcTypeBlob() {
            return -4;
        }

        public int getJdbcTypeBoolean() {
            return -6;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return -1;
        }

        public int getJdbcTypeDouble() {
            return 8;
        }

        public int getJdbcTypeFloat() {
            return 7;
        }

        public int getJdbcTypeInt() {
            return 4;
        }

        public int getJdbcTypeLong() {
            return -5;
        }

        public int getJdbcTypeTimestamp() {
            return -5;
        }

        public int getJdbcTypeUuid() {
            return -2;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return 91;
        }
    };
    private static final File MYSQL_RDB_DIR = new File(Sys.getProtectedStationHome(), Objects.requireNonNull(TYPE.getModule().getModuleName()));
    private final File trustStore = new File(MYSQL_RDB_DIR, BUuid.make() + "." + this.getTrustStoreType());
    private static final String TRUST_STORE_PASSWORD_KEYRING_ALIAS = "rdbMySQL.trustStore";
    private static final Lexicon RDB_LEX = Lexicon.make((String)"rdb");

    @Generated
    public String getDatabaseName() {
        return this.getString(databaseName);
    }

    @Generated
    public void setDatabaseName(String v) {
        this.setString(databaseName, v, null);
    }

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public BMySQLHistoryDeviceExt getHistories() {
        return (BMySQLHistoryDeviceExt)this.get(histories);
    }

    @Generated
    public void setHistories(BMySQLHistoryDeviceExt v) {
        this.set(histories, (BValue)v, null);
    }

    @Generated
    public BMySQLConnectionPool getConnectionPool() {
        return (BMySQLConnectionPool)this.get(connectionPool);
    }

    @Generated
    public void setConnectionPool(BMySQLConnectionPool v) {
        this.set(connectionPool, (BValue)v, null);
    }

    @Generated
    public String getExtraConnectionProperties() {
        return this.getString(extraConnectionProperties);
    }

    @Generated
    public void setExtraConnectionProperties(String v) {
        this.setString(extraConnectionProperties, v, null);
    }

    @Generated
    public String getMySqlServerCert() {
        return this.getString(mySqlServerCert);
    }

    @Generated
    public void setMySqlServerCert(String v) {
        this.setString(mySqlServerCert, v, null);
    }

    @Generated
    public BMySQLConnectionPoolWithCredentials getNonPrivilegedConnectionPool() {
        return (BMySQLConnectionPoolWithCredentials)this.get(nonPrivilegedConnectionPool);
    }

    @Generated
    public void setNonPrivilegedConnectionPool(BMySQLConnectionPoolWithCredentials v) {
        this.set(nonPrivilegedConnectionPool, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMySQLDatabase() {
    }

    public BMySQLDatabase(BOrd address, int port) {
        this.setHostAddress(address);
        this.setPort(port);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbMySQL");
    }

    public Connection getConnection(String userName, BPassword password) throws SQLException {
        if (!this.isRunning()) {
            throw new BajaRuntimeException("Database not running");
        }
        BStatus status = this.getStatus();
        if (status.isFault()) {
            return null;
        }
        return this.getConnectionPool().getConnection(userName, AccessController.doPrivileged(() -> ((BPassword)password).getValue()));
    }

    public boolean isPrivilegedConnection(Connection connection) {
        try {
            return this.getConnectionPool().isConnectionFromPool(connection);
        }
        catch (SQLException e) {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, "Exception occurred while attempting determine privilege level of Connection in " + this.getName(), e);
            }
            return false;
        }
    }

    public boolean isPrivilegeSeparationEnabled(Context cx) {
        return this.getNonPrivilegedConnectionPool().getEnabled();
    }

    public Connection getNonPrivilegedConnection(Context cx) throws SQLException {
        if (this.getStatus().isFault()) {
            return null;
        }
        if (!this.getNonPrivilegedConnectionPool().getEnabled()) {
            return this.getPrivilegedConnection(cx);
        }
        String nonPrivilegedAccountUserName = this.getNonPrivilegedConnectionPool().getUsername();
        BPassword nonPrivilegedAccountPassword = this.getNonPrivilegedConnectionPool().getPassword();
        return this.getNonPrivilegedConnectionPool().getConnectionPool().getConnection(nonPrivilegedAccountUserName, AccessController.doPrivileged(() -> ((BPassword)nonPrivilegedAccountPassword).getValue()));
    }

    public void doPing() {
        Object statement;
        if (!this.getEnabled() || this.getStatus().isFault()) {
            return;
        }
        Throwable privilegedConnectionFailureEx = null;
        try (Connection conn = AccessController.doPrivileged(() -> this.getPrivilegedConnection(null));){
            statement = conn.createStatement();
            Throwable throwable = null;
            try {
                statement.execute(this.DIALECT.getValidationQuery());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof PrivilegedActionException && e.getCause() != null) {
                cause = e.getCause();
            }
            this.getLogger().log(Level.WARNING, "Unable to establish connection for connectionPool", this.getLogger().isLoggable(Level.FINE) ? cause : null);
            privilegedConnectionFailureEx = cause;
        }
        Throwable nonPrivilegedConnectionFailureEx = null;
        if (this.getNonPrivilegedConnectionPool().getEnabled()) {
            try {
                Connection conn = AccessController.doPrivileged(() -> this.getNonPrivilegedConnection(null));
                statement = null;
                try (Statement statement2 = conn.createStatement();){
                    statement2.execute(this.DIALECT.getValidationQuery());
                }
                catch (Throwable throwable) {
                    statement = throwable;
                    throw throwable;
                }
                finally {
                    if (conn != null) {
                        if (statement != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)statement).addSuppressed(throwable);
                            }
                        } else {
                            conn.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                Throwable cause = e;
                if (e instanceof PrivilegedActionException && e.getCause() != null) {
                    cause = e.getCause();
                }
                this.getLogger().log(Level.WARNING, "Unable to establish connection for nonPrivilegedConnectionPool", this.getLogger().isLoggable(Level.FINE) ? cause : null);
                nonPrivilegedConnectionFailureEx = cause;
            }
        }
        if (privilegedConnectionFailureEx == null && nonPrivilegedConnectionFailureEx == null) {
            this.pingOk();
        } else {
            String pingFailCause = privilegedConnectionFailureEx != null && nonPrivilegedConnectionFailureEx != null ? RDB_LEX.getText("rdbms.pingFail.getConnection.multipleCombinedPools.exceptions", new Object[]{RDB_LEX.getText("rdbms.pingFail.getPrivilegedConnection.exception", new Object[]{privilegedConnectionFailureEx.getMessage()}), RDB_LEX.getText("rdbms.pingFail.getNonPrivilegedConnection.exception", new Object[]{nonPrivilegedConnectionFailureEx.getMessage()})}) : (privilegedConnectionFailureEx != null ? RDB_LEX.getText("rdbms.pingFail.getPrivilegedConnection.exception", new Object[]{privilegedConnectionFailureEx.getMessage()}) : RDB_LEX.getText("rdbms.pingFail.getNonPrivilegedConnection.exception", new Object[]{nonPrivilegedConnectionFailureEx.getMessage()}));
            this.pingFail(pingFailCause);
        }
    }

    public void rdbmsStarted() throws Exception {
        super.rdbmsStarted();
        int nonPrivilegedConnectionPoolSlotFlags = this.getFlags((Slot)nonPrivilegedConnectionPool);
        if ((nonPrivilegedConnectionPoolSlotFlags & 0x10000000) == 0) {
            this.setFlags((Slot)nonPrivilegedConnectionPool, nonPrivilegedConnectionPoolSlotFlags & 0xFFFFFFFB | 0x10000000);
        }
    }

    public RdbmsContext getRdbmsContext() {
        return this.DIALECT;
    }

    protected void initializeTrustStore() throws IOException {
        block3: {
            try {
                AccessController.doPrivileged(() -> {
                    if (!this.trustStore.getParentFile().exists() && !this.trustStore.getParentFile().mkdirs()) {
                        throw new IOException("Unable to create rdbMySQL directory for MySQL Database: " + this.getDisplayName(Context.NULL));
                    }
                    this.trustStore.deleteOnExit();
                    if (this.getUseEncryptedConnection()) {
                        this.updateCertificateInTrustStore(this.getMySqlServerCert(), Context.NULL);
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getException();
                }
                if (!(e.getCause() instanceof SecurityException)) break block3;
                throw (SecurityException)e.getCause();
            }
        }
    }

    protected void loadTrustStore(KeyStore keyStore, Context context) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                try (InputStream is = this.trustStore.exists() ? Files.newInputStream(this.getTrustStorePath(), new OpenOption[0]) : null;
                     SecretChars trustStorePassword = this.getTrustStorePassword();){
                    keyStore.load(is, trustStorePassword.get());
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new BajaRuntimeException(String.format("Unable to load KeyStore for MySQL database: %s", this.getDisplayName(context)), (Throwable)e);
        }
    }

    protected void saveTrustStore(KeyStore keyStore, Context context) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                try (OutputStream os = Files.newOutputStream(this.getTrustStorePath(), new OpenOption[0]);
                     SecretChars trustStorePassword = this.getTrustStorePassword();){
                    keyStore.store(os, trustStorePassword.get());
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new BajaRuntimeException(String.format("Unable to store KeyStore for MySQL database: %s", this.getDisplayName(context)), (Throwable)e);
        }
    }

    protected Property getServerCertificateProperty() {
        return mySqlServerCert;
    }

    public Path getTrustStorePath() {
        return this.trustStore.toPath();
    }

    public String getServerCertificateSubjectIdentifier() {
        return null;
    }

    SecretChars getTrustStorePassword() {
        try {
            return AccessController.doPrivileged(() -> {
                byte[] trustStorePassword = BMySQLDatabase.getTrustStorePasswordFromKeyRing((String)TRUST_STORE_PASSWORD_KEYRING_ALIAS);
                try (SecretBytes passwordBytes = new SecretBytes(trustStorePassword, true);){
                    SecretChars secretChars = SecretChars.fromSecretBytes((SecretBytes)passwordBytes);
                    return secretChars;
                }
            });
        }
        catch (PrivilegedActionException e) {
            String exceptionMessageFormat = "Could not acquire Trust Store password from Key Ring for MySQL Database: %s";
            String exceptionMessage = String.format(exceptionMessageFormat, this.getDisplayName(Context.NULL));
            if (Logger.getLogger("rdb").isLoggable(Level.WARNING)) {
                Logger.getLogger("rdb").log(Level.WARNING, exceptionMessage, e.getException());
            }
            throw new SecurityException(e.getException());
        }
    }
}

