/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.mysql;

import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.rdb.BAbstractConnectionPool;
import com.tridium.rdb.jdbc.NiagaraPooledDataSource;
import com.tridium.rdb.mysql.BMySQLDatabase;
import com.tridium.util.CompUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.commons.dbcp2.BasicDataSource;

@NiagaraType
public class BMySQLConnectionPool
extends BAbstractConnectionPool {
    @Generated
    public static final Type TYPE = Sys.loadType(BMySQLConnectionPool.class);
    private BasicDataSource ds;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doUpdateConnectionStats() {
        if (this.ds != null) {
            this.setNumActive(this.ds.getNumActive());
            if (this.getNumActive() > this.getPeakNumActive()) {
                this.setPeakNumActive(this.getNumActive());
            }
            this.setNumIdle(this.ds.getNumIdle());
        }
    }

    protected Connection obtainConnection(String userName, String password) throws SQLException {
        Optional optionalDb = CompUtil.closestAncestor((BComplex)this, BMySQLDatabase.class);
        if (!optionalDb.isPresent()) {
            throw new BajaRuntimeException("Database not found");
        }
        BMySQLDatabase db = (BMySQLDatabase)((Object)optionalDb.get());
        if (!db.isRunning()) {
            throw new BajaRuntimeException("Database not running");
        }
        String url = this.makeUrl(db);
        if (this.ds == null) {
            Logger.getLogger("rdb").fine("initializing connection pool for " + url);
            this.ds = this.makeDataSource(url, userName, password);
        } else {
            boolean passwordChanged;
            boolean bl = passwordChanged = !this.ds.getPassword().equals(password);
            if (!this.ds.getUrl().equals(url) || !this.ds.getUserName().equals(userName) || passwordChanged) {
                Logger.getLogger("rdb").fine("re-initializing connection pool for " + url);
                this.ds.close();
                this.ds = this.makeDataSource(url, userName, password);
            }
        }
        try {
            return AccessController.doPrivileged(() -> this.ds.getConnection());
        }
        catch (NoClassDefFoundError | PrivilegedActionException connectionIssue) {
            Throwable e;
            String faultCause = "";
            Throwable cause = connectionIssue.getCause();
            faultCause = cause instanceof SQLException ? ((e = cause.getCause()) instanceof ClassNotFoundException ? this.getLexicon().getText("rdbMySql.throwable.mySqlConnectorJarIssue") : cause.getLocalizedMessage()) : (connectionIssue instanceof NoClassDefFoundError ? this.getLexicon().getText("rdbMySql.throwable.mySqlConnectorJarIssue") : connectionIssue.getLocalizedMessage());
            db.pingFail(faultCause);
            db.getLogger().log(Level.SEVERE, faultCause, connectionIssue);
            throw new BajaRuntimeException(faultCause);
        }
    }

    private BasicDataSource makeDataSource(String url, String userName, String password) {
        NiagaraPooledDataSource dataSource = new NiagaraPooledDataSource((BAbstractConnectionPool)this);
        dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        dataSource.setUrl(url);
        dataSource.setUsername(userName);
        dataSource.setPassword(password);
        dataSource.setMaxTotal(this.getMaxActive());
        dataSource.setMaxIdle(this.getMaxIdle());
        dataSource.setMaxWait(Duration.ofMillis(this.getMaxWait()));
        return dataSource;
    }

    private String makeUrl(BMySQLDatabase db) throws SQLException {
        String separator;
        BValue val;
        StringBuilder url = new StringBuilder("jdbc:mysql:");
        url.append("//").append(db.getHostname());
        url.append(':').append(db.getPort());
        String dbName = db.getDatabaseName();
        if (!dbName.isEmpty()) {
            url.append('/').append(dbName);
        }
        String extra = "";
        BComplex parent = this.getParent();
        if (parent != null && (val = parent.get("extraConnectionProperties")) instanceof BString) {
            extra = val.toString();
        }
        String string = separator = !extra.isEmpty() ? "&" : "?";
        if (!extra.isEmpty()) {
            url.append('?').append(extra);
        }
        if (url.indexOf("serverTimezone=") == -1) {
            url.append(separator).append("serverTimezone=UTC");
            separator = "&";
        }
        if (db.getUseUnicodeEncodingScheme()) {
            url.append(separator).append("useUnicode=true&characterEncoding=UTF-8");
            separator = "&";
        }
        String ssl = db.getUseEncryptedConnection() ? "true" : "false";
        String sslProperties = "useSSL=" + ssl + "&requireSSL=" + ssl;
        url.append(separator).append(sslProperties);
        if (db.getUseEncryptedConnection()) {
            String enabledTlsProtocols = String.join((CharSequence)",", (CharSequence[])CryptoSupport.TYPE_LISTS.get(db.getTlsMinProtocol().getTag()));
            url.append(separator).append("enabledTLSProtocols=" + enabledTlsProtocols);
            boolean verifyCA = db.getVerifySubjectInCertificate();
            url.append('&').append("verifyServerCertificate=" + verifyCA);
            if (verifyCA) {
                url.append('&').append("trustCertificateKeyStoreUrl=" + db.getTrustStorePath().toUri());
                try {
                    url.append('&').append("trustCertificateKeyStorePassword=" + db.getTrustStorePassword().asString(true));
                    url.append('&').append("trustCertificateKeyStoreType=" + db.getTrustStoreType());
                }
                catch (Exception e) {
                    throw new SQLException("Failed to configure trust store connection parameters");
                }
            }
        }
        return url.toString();
    }
}

