/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.rpc;

import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONObject;
import com.tridium.lonworks.datatypes.BAppDownloadParameter;
import com.tridium.lonworks.discover.BLonCreationEntry;
import com.tridium.lonworks.discover.LonLearnUtil;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.util.AppDownloadUtil;
import com.tridium.lonworks.util.DeviceDef;
import com.tridium.lonworks.util.NxeUtil;
import java.util.List;
import javax.baja.file.BIFile;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.proxy.BLonPointDeviceExt;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUnrestrictedFolder;

@NiagaraType
public final class BLonworksRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BLonworksRpc.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box)}, permissions="unrestricted")
    public static String getPointDiscoveryBson(String ordString, Context cx) throws Exception {
        OrdTarget target = BOrd.make((String)ordString).resolve(null, cx);
        if (!target.canRead()) {
            throw new UnresolvedException();
        }
        BLonPointDeviceExt pointDeviceExt = (BLonPointDeviceExt)target.get();
        BLonCreationEntry[] entries = LonLearnUtil.discoverPointEntries((BComponent)pointDeviceExt, (Context)cx);
        BUnrestrictedFolder folder = new BUnrestrictedFolder();
        for (BLonCreationEntry entry : entries) {
            folder.add(null, (BValue)entry);
        }
        return BsonEncoderPlugin.marshal((BValue)folder, (Context)cx);
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box)}, permissions="unrestricted")
    public static boolean isProgramIdWildCardMatch(String source, String target, Context cx) throws Exception {
        BProgramId srcProgramId = (BProgramId)BProgramId.DEFAULT.decodeFromString(source);
        BProgramId targetProgramId = (BProgramId)BProgramId.DEFAULT.decodeFromString(target);
        return new DeviceDef(srcProgramId).wildCardMatch(targetProgramId);
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box)}, permissions="unrestricted")
    public static JSONObject getParameters(List<String> selectedDeviceOrds, String appFileOrd, String xifFileOrd, String lnmlFileOrd, boolean useZero, boolean bindLinks, Context cx) throws Exception {
        BLonDevice[] devices = BLonworksRpc.loadDevices(selectedDeviceOrds, cx);
        BIFile appFile = BLonworksRpc.resolveFileFromOrd(appFileOrd, cx);
        BIFile xifFile = BLonworksRpc.resolveFileFromOrd(xifFileOrd, cx);
        BIFile lnmlFile = BLonworksRpc.resolveFileFromOrd(lnmlFileOrd, cx);
        BAppDownloadParameter param = AppDownloadUtil.buildParameter((BLonDevice[])devices, (BIFile)appFile, (BIFile)xifFile, (BIFile)lnmlFile, (boolean)useZero, (boolean)bindLinks);
        BProgramId appPid = NxeUtil.findProgramId((byte[])param.getAppFile().copyBytes());
        String paramStr = BsonEncoderPlugin.marshal((BValue)param);
        String appPidStr = appPid.encodeToString();
        JSONObject obj = new JSONObject();
        obj.put("param", (Object)paramStr);
        obj.put("appPid", (Object)appPidStr);
        return obj;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box)}, permissions="unrestricted")
    public static String startJob(String paramBson, String netmgmtOrd, List<String> selectedDeviceOrds, String xifFileOrd, String lnmlFileOrd, Context cx) throws Exception {
        BAppDownloadParameter param = (BAppDownloadParameter)BsonDecoderPlugin.unmarshal((String)paramBson, null);
        BLonDevice[] devices = BLonworksRpc.loadDevices(selectedDeviceOrds, cx);
        BLonNetmgmt netmgmt = (BLonNetmgmt)BLonworksRpc.getTarget(netmgmtOrd, cx).get();
        BIFile xifFile = BLonworksRpc.resolveFileFromOrd(xifFileOrd, cx);
        BIFile lnmlFile = BLonworksRpc.resolveFileFromOrd(lnmlFileOrd, cx);
        return AppDownloadUtil.startJob((BAppDownloadParameter)param, (BLonNetmgmt)netmgmt, (BLonDevice[])devices, (BIFile)xifFile, (BIFile)lnmlFile).encodeToString();
    }

    private static BLonDevice[] loadDevices(List<String> selectedDeviceOrds, Context cx) throws Exception {
        BLonDevice[] devices = new BLonDevice[selectedDeviceOrds.size()];
        for (int i = 0; i < selectedDeviceOrds.size(); ++i) {
            devices[i] = (BLonDevice)BLonworksRpc.getTarget(selectedDeviceOrds.get(i), cx).get();
        }
        return devices;
    }

    private static BIFile resolveFileFromOrd(String fileOrd, Context cx) throws Exception {
        if (fileOrd != null && !fileOrd.isEmpty() && !"null".equals(fileOrd)) {
            return (BIFile)BLonworksRpc.getTarget(fileOrd, cx).get();
        }
        return null;
    }

    private static OrdTarget getTarget(String ord, Context cx) throws Exception {
        OrdTarget target = BOrd.make((String)ord).resolve((BObject)BLocalHost.INSTANCE, cx);
        if (!target.canRead()) {
            throw new UnresolvedException();
        }
        return target;
    }
}

