/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.queryTable.ui;

import com.tridium.bql.filter.BFilterSet;
import com.tridium.data.BDataRow;
import com.tridium.query.BQueryEngine;
import com.tridium.queryTable.BQueryTable;
import com.tridium.queryTable.QueryUtil;
import com.tridium.queryTable.ui.BQueryTableOptions;
import com.tridium.smartTableHx.BCommandBoundTable;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.CommandBindings;
import com.tridium.workbench.bql.filter.BFilterSetEditor;
import com.tridium.workbench.util.CollectionTableModel;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BPredicate;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.space.BSpace;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"queryTable:QueryTable"}, requiredPermissions="r")})
public class BWbQueryTableView
extends BWbView
implements CommandBindings.Support {
    @Generated
    public static final Type TYPE = Sys.loadType(BWbQueryTableView.class);
    BEdgePane main;
    Command hyperlinkCommand;
    Command filter;
    BTable table;
    private CommandBindings bindings = this.getCommandBindings();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWbQueryTableView() {
        this.table = new BCommandBoundTable((TableModel)new DefaultTableModel(), (CommandBindings.TableController)new ResultController());
        BTitlePane mainTable = BTitlePane.makePane((String)"", (BTable)this.table, (String)Lexicon.make((String)"workbench").getText("collectionTable.rows"));
        this.main = new BEdgePane();
        this.main.setCenter((BWidget)mainTable);
        this.setContent((BWidget)this.main);
    }

    public void doLoadValue(BObject value, Context cx) {
        BExpression exp;
        BQuery query = ((BQueryTable)value).getQuery();
        query.lease(4);
        BQuery working = QueryUtil.getWorkingCopy(query, cx);
        BQueryTableOptions options = BQueryTableOptions.make();
        BFilterSet filterSet = options.getFilterSet(working);
        BPredicate queryPredicate = working.getPredicate();
        BExpression queryExp = null;
        if (queryPredicate != null) {
            queryExp = queryPredicate.getPredicateExpr();
        }
        if (QueryUtil.hasDefaultFilters(working) && filterSet == null) {
            filterSet = BQueryTableOptions.rebuildFilterSet(working, filterSet, cx);
        }
        ExpressionBuilder builder = new ExpressionBuilder(queryExp);
        if (filterSet != null && filterSet.getQueryPredicate() != null && filterSet.getQueryPredicate().getPredicateExpr() != null) {
            builder = builder.and((BExpression)filterSet.getQueryPredicate().getPredicateExpr().newCopy(true));
        }
        if ((exp = builder.getExpression()) != null) {
            working.where(new BPredicate((BExpression)exp.newCopy(true)));
        }
        BQueryEngine engine = BQueryEngine.make((BSpace)query.getSpace());
        BOrd base = BOrd.make((String)"slot:/");
        if (query.get("base") instanceof BOrd) {
            base = (BOrd)query.get("base");
        }
        BOrd ord = BOrd.make((BOrd)query.getSpace().getAbsoluteOrd(), (BOrd)base);
        BITable collection = engine.compile(working, ord).execute();
        QueryCollectionTableModel model = new QueryCollectionTableModel((BITable<? extends BIObject>)collection, working, cx);
        this.table.setModel((TableModel)model);
        this.table.relayout();
        Command[] commands = this.getButtonCommands();
        if (commands != null) {
            BGridPane buttons = new BGridPane(commands.length);
            buttons.setUniformColumnWidth(true);
            buttons.setColumnGap(5.0);
            buttons.setColumnAlign(BHalign.fill);
            for (int i = 0; i < commands.length; ++i) {
                buttons.add(null, (BValue)new BButton(commands[i]));
            }
            this.main.setBottom((BWidget)new BBorderPane((BWidget)buttons, BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0)));
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        command.setEnabled(bindingBasedState);
    }

    public Command[] getButtonCommands() {
        ArrayList<Command> a = new ArrayList<Command>();
        if (this.hyperlinkCommand != null) {
            a.add(this.hyperlinkCommand);
        }
        this.filter = new FilterCommand();
        a.add(this.filter);
        return a.toArray(new Command[0]);
    }

    public CommandBindings makeCommandBindings() {
        CommandBindings result = new CommandBindings();
        this.hyperlinkCommand = new HyperlinkCommand();
        result.addCommand(this.hyperlinkCommand, BCommandEnablePolicy.singleSelection);
        return result;
    }

    public Command getDoubleClickCommand() {
        return this.hyperlinkCommand;
    }

    public final CommandBindings getCommandBindings() {
        if (this.bindings == null) {
            this.bindings = this.makeCommandBindings();
        }
        return this.bindings;
    }

    public void configFilters() {
        BQuery query;
        BQuery working;
        BQueryTableOptions options = BQueryTableOptions.make();
        BFilterSet filterSet = options.getFilterSet(working = QueryUtil.getWorkingCopy(query = ((BQueryTable)this.getCurrentValue()).getQuery(), this.getCurrentContext()));
        if (filterSet == null || !BQueryTableOptions.isFilterSetValid(working, filterSet)) {
            filterSet = BQueryTableOptions.rebuildFilterSet(working, filterSet, this.getCurrentContext());
            options.setFilterSet(working, filterSet);
        }
        BFilterSetEditor setEditor = new BFilterSetEditor();
        setEditor.loadValue((BObject)filterSet);
        BBorderPane borderPane = new BBorderPane((BWidget)setEditor, 10.0, 10.0, 10.0, 10.0);
        if (BDialog.open((BWidget)this, (String)"Filters", (Object)borderPane, (int)3) != 2) {
            try {
                if (setEditor.isModified()) {
                    options.setFilterSet(working, (BFilterSet)setEditor.saveValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (!(filterSet = options.getFilterSet(working)).anyActive()) {
            boolean custom = false;
            BProjectionColumn[] columns = working.getProjection().getProjectionColumns();
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].get("defaultFilter") == null) continue;
                custom = true;
            }
            if (!custom) {
                options.removeFilterSet(working);
            }
        }
    }

    protected class FilterCommand
    extends Command {
        public FilterCommand() {
            super((BWidget)BWbQueryTableView.this, TYPE.getModule(), "command.filter");
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbQueryTableView.this.configFilters();
            BWbQueryTableView.this.loadValue(BWbQueryTableView.this.getCurrentValue());
            return null;
        }

        public BImage getIcon() {
            BQueryTableOptions options = BQueryTableOptions.make();
            BQuery query = ((BQueryTable)BWbQueryTableView.this.getCurrentValue()).getQuery();
            if (query == null) {
                return super.getIcon();
            }
            BQuery working = QueryUtil.getWorkingCopy(query, BWbQueryTableView.this.getCurrentContext());
            BFilterSet filterSet = options.getFilterSet(working);
            boolean defaultFilters = QueryUtil.hasDefaultFilters(working);
            if (filterSet == null && !defaultFilters || filterSet != null && !filterSet.anyActive()) {
                return super.getIcon();
            }
            return super.getIcon().getHighlightedImage();
        }
    }

    protected class HyperlinkCommand
    extends Command {
        public HyperlinkCommand() {
            super((BWidget)BWbQueryTableView.this, TYPE.getModule(), "command.hyperlink");
        }

        public CommandArtifact doInvoke() {
            try {
                int[] queryion = BWbQueryTableView.this.table.getSelection().getRows();
                if (queryion.length == 0) {
                    return null;
                }
                BDataRow row = (BDataRow)BWbQueryTableView.this.table.getModel().getSubject(queryion[0]);
                CollectionTableModel model = (CollectionTableModel)BWbQueryTableView.this.table.getModel();
                Column[] list = model.getBITable().getColumns().list();
                String slotPath = row.cell(model.getBITable().getColumns().get("slotPath")).toString();
                BOrd hyperlinkOrd = BOrd.make((String)("station:|" + slotPath));
                BWbShell shell = BWbQueryTableView.this.getWbShell();
                if (shell != null) {
                    shell.hyperlink(hyperlinkOrd);
                }
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                BDialog.error((BWidget)BWbQueryTableView.this, (String)"Hyperlink failed.", (Object)ex);
                return null;
            }
        }
    }

    public class ResultController
    extends CommandBindings.TableController {
        public ResultController() {
            super(BWbQueryTableView.this.bindings);
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            try {
                if (BWbQueryTableView.this.getDoubleClickCommand() != null) {
                    BWbQueryTableView.this.getDoubleClickCommand().invoke();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class QueryCollectionTableModel
    extends CollectionTableModel {
        private BQuery working;

        public QueryCollectionTableModel(BITable<? extends BIObject> collection, BQuery working, Context cx) {
            super(collection, cx);
            this.working = working;
        }

        public int getColumnCount() {
            return super.getColumnCount() - QueryUtil.getHiddenColumnsCount(this.working);
        }
    }
}

