/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall.export;

import com.tridium.oncall.BOnCallService;
import com.tridium.oncall.util.BOnCallContactUserEventInfo;
import com.tridium.oncall.util.OnCallToolkit;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;

@NiagaraType(agent={@AgentOn(types={"baja:User", "onCall:OnCallContact"})})
@NiagaraProperties(value={@NiagaraProperty(name="start", type="BAbsTime", defaultValue="BAbsTime.now()", facets={@Facet(value="BFacets.make(BFacets.SHOW_DATE, BBoolean.TRUE, BFacets.SHOW_TIME, BBoolean.FALSE)")}), @NiagaraProperty(name="end", type="BAbsTime", defaultValue="BAbsTime.now().nextMonth()", facets={@Facet(value="BFacets.make(BFacets.SHOW_DATE, BBoolean.TRUE, BFacets.SHOW_TIME, BBoolean.FALSE)")})})
public final class BOnCallUserReportPdfExporter
extends BPdfExporter {
    @Generated
    public static final Property start = BOnCallUserReportPdfExporter.newProperty((int)0, (BValue)BAbsTime.now(), (BFacets)BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE, (String)"showTime", (BIDataValue)BBoolean.FALSE));
    @Generated
    public static final Property end = BOnCallUserReportPdfExporter.newProperty((int)0, (BValue)BAbsTime.now().nextMonth(), (BFacets)BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE, (String)"showTime", (BIDataValue)BBoolean.FALSE));
    @Generated
    public static final Type TYPE = Sys.loadType(BOnCallUserReportPdfExporter.class);

    @Generated
    public BAbsTime getStart() {
        return (BAbsTime)this.get(start);
    }

    @Generated
    public void setStart(BAbsTime v) {
        this.set(start, (BValue)v, null);
    }

    @Generated
    public BAbsTime getEnd() {
        return (BAbsTime)this.get(end);
    }

    @Generated
    public void setEnd(BAbsTime v) {
        this.set(end, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void export(PdfOp op) throws Exception {
        this.export(op, op.getComponent());
    }

    void export(PdfOp op, BComponent comp) throws Exception {
        BOnCallService srv = (BOnCallService)BOrd.make((String)"service:onCall:OnCallService").get((BObject)comp);
        BComponent info = new BComponent();
        info.add("ord", (BValue)comp.getHandleOrd());
        info.add("start", (BValue)this.getStart());
        info.add("end", (BValue)this.getEnd());
        BComponent result = srv.createUserReport(info);
        BOnCallContactUserEventInfo[] evs = (BOnCallContactUserEventInfo[])result.getChildren(BOnCallContactUserEventInfo.class);
        if (OnCallToolkit.log.isTraceOn()) {
            for (int i = 0; i < evs.length; ++i) {
                OnCallToolkit.log.trace(evs[i].toDebugString());
            }
        }
        PdfDocument doc = new PdfDocument(op.getOutputStream(), op.getWidth(), op.getHeight());
        BTable table = new BTable((TableModel)new Model(evs, (Context)op));
        BLabel date = new BLabel(BAbsTime.now().toString((Context)op));
        BLabel name = new BLabel(result.get("userName").toString());
        date.setHalign(BHalign.left);
        name.setHalign(BHalign.left);
        BPdfFlowPane flow = new BPdfFlowPane();
        flow.add(null, (BValue)date);
        flow.add(null, (BValue)name);
        flow.add(null, (BValue)new BLabel(""));
        flow.add(null, (BValue)table);
        flow.setupPane();
        BWidgetToPdf exporter = new BWidgetToPdf();
        exporter.renderDocument((BWidget)flow, doc, op);
    }

    public static class Model
    extends TableModel {
        private final BOnCallContactUserEventInfo[] infos;
        private static final BOnCallContactUserEventInfo SAMPLE_INFO = new BOnCallContactUserEventInfo();
        private final Context cx;

        public Model(BOnCallContactUserEventInfo[] infos, Context cx) {
            this.infos = infos;
            this.cx = cx;
        }

        public int getColumnCount() {
            return SAMPLE_INFO.getPropertiesArray().length;
        }

        public int getRowCount() {
            return this.infos.length;
        }

        public String getColumnName(int col) {
            Property[] props = SAMPLE_INFO.getPropertiesArray();
            return props[col].getDefaultDisplayName(this.cx);
        }

        public Object getValueAt(int row, int col) {
            Property p = SAMPLE_INFO.getPropertiesArray()[col];
            return this.infos[row].get(p);
        }
    }
}

