/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetOws.ui.device;

import com.tridium.bacnet.asn.NAlarmSummary;
import com.tridium.bacnet.asn.NEnrollmentSummary;
import com.tridium.bacnet.asn.NEventSummary;
import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import com.tridium.bacnet.ui.device.BacnetDeviceLearn;
import com.tridium.bacnetOws.job.BGetEnrollmentSummaryJob;
import com.tridium.bacnetOws.job.BGetEventInformationJob;
import com.tridium.bacnetOws.ui.device.BBacnetOwsDeviceManager;
import java.text.MessageFormat;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.sys.BString;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.util.UiLexicon;

public class BacnetOwsDeviceLearn
extends BacnetDeviceLearn {
    UiLexicon owslex = UiLexicon.makeUiLexicon(BacnetOwsDeviceLearn.class);

    public BacnetOwsDeviceLearn(BBacnetOwsDeviceManager mgr) {
        super((BBacnetDeviceManager)mgr);
    }

    public void jobComplete(BJob job) {
        Type jobType = job.getType();
        job.lease(1);
        if (jobType == BGetEnrollmentSummaryJob.TYPE) {
            if (job.getJobState() == BJobState.success) {
                BTextEditorPane pane = new BTextEditorPane("", 20, 120, false);
                StringBuilder sb = new StringBuilder(this.owslex.getText("getESumm.header"));
                sb.append("Filter:").append(job.get("filter"));
                sb.append("\n\n");
                BString[] esums = (BString[])job.getChildren(BString.class);
                for (int i = 0; i < esums.length; ++i) {
                    sb.append(NEnrollmentSummary.fromJob((String)esums[i].getString()));
                }
                pane.setText(sb.toString());
                BDialog.message((BWidget)this.getManager(), (String)this.owslex.getText("getESumm.title"), (Object)pane);
            } else {
                BString s = (BString)job.get("failureCause");
                String cause = s != null ? s.getString() : "";
                String msg = MessageFormat.format(this.owslex.getText("getESumm.fail"), cause);
                BDialog.message((BWidget)this.getManager(), (String)this.owslex.getText("getESumm.title"), (Object)msg);
            }
        } else if (jobType == BGetEventInformationJob.TYPE) {
            if (job.getJobState() == BJobState.success) {
                BTextEditorPane pane = new BTextEditorPane("", 20, 120, false);
                StringBuilder sb = new StringBuilder();
                String msg = null;
                String cause = null;
                BString s = null;
                switch (((BGetEventInformationJob)job).getServiceChoice()) {
                    case 29: {
                        sb.append(this.owslex.getText("getEventInfo.header")).append("\n\n");
                        BString[] events = (BString[])job.getChildren(BString.class);
                        for (int i = 0; i < events.length; ++i) {
                            sb.append(NEventSummary.fromJob((String)events[i].getString()));
                        }
                        pane.setText(sb.toString());
                        BDialog.message((BWidget)this.getManager(), (String)this.owslex.getText("getEventInfo.title"), (Object)pane);
                        break;
                    }
                    case 3: {
                        s = (BString)job.get("failureCause");
                        cause = s != null ? s.getString() : "";
                        msg = MessageFormat.format(this.owslex.getText("getEventInfo.fail"), cause);
                        sb.append(this.owslex.getText("getEventInfo.unsupported")).append("\n").append(this.owslex.getText("getEventInfo.alarmSummary")).append("\n(").append(this.owslex.getText("getASumm.warning")).append(")");
                        BDialog.message((BWidget)this.getManager(), (String)this.owslex.getText("getEventInfo.title"), (Object)sb.toString());
                        sb.setLength(0);
                        sb.append(this.owslex.getText("getASumm.header")).append("\n\n");
                        BString[] alarms = (BString[])job.getChildren(BString.class);
                        for (int i = 0; i < alarms.length; ++i) {
                            sb.append(NAlarmSummary.fromJob((String)alarms[i].getString()));
                        }
                        pane.setText(sb.toString());
                        BDialog.message((BWidget)this.getManager(), (String)this.owslex.getText("getASumm.title"), (Object)pane);
                        break;
                    }
                    default: {
                        s = (BString)job.get("failureCause");
                        cause = s != null ? s.getString() : "";
                        msg = MessageFormat.format(this.owslex.getText("getEventInfo.fail"), cause);
                        pane.setText(msg);
                        BDialog.message((BWidget)this.getManager(), (String)this.owslex.getText("getEventInfo.title"), (Object)pane);
                        break;
                    }
                }
            } else {
                BString s = (BString)job.get("failureCause");
                String cause = s != null ? s.getString() : "";
                String msg = MessageFormat.format(this.owslex.getText("getEventInfo.fail"), cause);
                BDialog.message((BWidget)this.getManager(), (String)this.owslex.getText("getEventInfo.title"), (Object)msg);
            }
        } else {
            super.jobComplete(job);
        }
    }
}

