/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetOws.ui.device;

import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import com.tridium.bacnet.ui.device.BacnetDeviceController;
import com.tridium.bacnetOws.datatypes.BGetESummConfig;
import com.tridium.bacnetOws.datatypes.BGetEventInfoConfig;
import com.tridium.bacnetOws.ui.device.BBacnetOwsDeviceManager;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrController;

public class BacnetOwsDeviceController
extends BacnetDeviceController {
    public final MgrController.MgrCommand getEventInformation;
    public final MgrController.MgrCommand getEnrollmentSummary;
    private static final Logger logger = Logger.getLogger("bacnetOws.ui");

    protected BacnetOwsDeviceController(BBacnetOwsDeviceManager manager) {
        super((BBacnetDeviceManager)manager);
        this.getEventInformation = new GetEventInformation((BWidget)manager);
        this.getEnrollmentSummary = new GetEnrollmentSummary((BWidget)manager);
        this.getEventInformation.setFlags(7);
        this.getEnrollmentSummary.setFlags(7);
    }

    protected MgrController.IMgrCommand[] makeBacnetCommands() {
        return BacnetOwsDeviceController.append((MgrController.IMgrCommand[])super.makeBacnetCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.getEventInformation, this.getEnrollmentSummary});
    }

    protected void setBacnetCommandsEnable(boolean enable) {
        super.setBacnetCommandsEnable(enable);
        if (enable) {
            BComponent[] devs = this.getSelectedComponentsWithoutFolders();
            boolean selection = false;
            if (devs.length == 1) {
                selection = true;
            }
            this.getEventInformation.setEnabled(selection);
            this.getEnrollmentSummary.setEnabled(selection);
        } else {
            this.getEventInformation.setEnabled(false);
            this.getEnrollmentSummary.setEnabled(false);
        }
    }

    public CommandArtifact doGetEventInformation() throws Exception {
        try {
            int ok = BDialog.confirm((BWidget)this.getManager(), (String)this.lex().get("getEventInfo.label"), (Object)this.lex().get("getEventInfo.confirm"), (int)3);
            if (ok == 2) {
                return null;
            }
            BComponent[] devs = this.getSelectedComponentsWithoutFolders();
            BBacnetDevice dev = (BBacnetDevice)devs[0];
            BBacnetNetwork bacnet = ((BBacnetDeviceManager)this.getManager()).getNetwork();
            BGetEventInfoConfig params = new BGetEventInfoConfig();
            params.setObjectId(dev.getObjectId());
            this.setJob(bacnet.submitDeviceManagerJob((BValue)params));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in doGetEventInformation", e);
            String msg = MessageFormat.format(this.lex().get("getEventInfo.fail"), e);
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("getEventInfo.title"), (Object)msg);
        }
        return null;
    }

    public CommandArtifact doGetEnrollmentSummary() throws Exception {
        try {
            BGetESummConfig params = (BGetESummConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)this.lex().get("getESumm.title"), (BObject)new BGetESummConfig());
            if (params != null) {
                BComponent[] devs = this.getSelectedComponentsWithoutFolders();
                BBacnetDevice dev = (BBacnetDevice)devs[0];
                BBacnetNetwork bacnet = ((BBacnetDeviceManager)this.getManager()).getNetwork();
                params.setDeviceAddress((BBacnetAddress)dev.getAddress().newCopy());
                this.setJob(bacnet.submitDeviceManagerJob((BValue)params));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception occurred in doGetEnrollmentSummary", e);
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("getESumm.title"), (Object)this.lex().get("getESumm.fail"));
        }
        return null;
    }

    private UiLexicon lex() {
        return BBacnetOwsDeviceManager.owslex;
    }

    class GetEnrollmentSummary
    extends MgrController.MgrCommand {
        GetEnrollmentSummary(BWidget owner) {
            super(owner, (Lexicon)BacnetOwsDeviceController.this.lex(), "getESumm");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BacnetOwsDeviceController.this.doGetEnrollmentSummary();
        }
    }

    class GetEventInformation
    extends MgrController.MgrCommand {
        GetEventInformation(BWidget owner) {
            super(owner, (Lexicon)BacnetOwsDeviceController.this.lex(), "getEventInfo");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BacnetOwsDeviceController.this.doGetEventInformation();
        }
    }
}

