/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email.ui;

import com.tridium.email.BOAuthEmailClientSecretAuthenticator;
import com.tridium.util.CompUtil;
import com.tridium.workbench.fieldeditors.BStringFE;
import com.tridium.workbench.fieldeditors.BStringMgrColFE;
import java.util.Optional;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BEmailAuthenticatorTypeConfig;
import javax.baja.email.BEmailClientAuthenticator;
import javax.baja.email.BIncomingAccount;
import javax.baja.email.BIncomingAccountClientAuthenticatorTypeConfig;
import javax.baja.email.BOutgoingAccount;
import javax.baja.email.BOutgoingAccountClientAuthenticatorTypeConfig;
import javax.baja.email.BStore;
import javax.baja.email.BTransport;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"email:EmailService"})})
public class BEmailAccountManager
extends BAbstractManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BEmailAccountManager.class);
    static Lexicon emailLexicon = Lexicon.make((String)"email");
    MgrColumn colName = new MgrColumn.Name(1);
    MgrColumn colEnabled = new MgrColumn.Prop(BEmailAccount.enabled.getDefaultDisplayName(null), BEmailAccount.enabled, 3);
    MgrColumn colProtocol = new EmailProtocol(BOutgoingAccount.transport.getDefaultDisplayName(null), 1);
    MgrColumn colHostName = new MgrColumn.Prop(BEmailAccount.hostname.getDefaultDisplayName(null), BEmailAccount.hostname, 1);
    MgrColumn colPort = new MgrColumn.Prop(BEmailAccount.port.getDefaultDisplayName(null), BEmailAccount.port, 3);
    MgrColumn colPollrate = new MgrColumn.Prop(BEmailAccount.pollrate.getDefaultDisplayName(null), BEmailAccount.pollrate, 1);
    MgrColumn colStatus = new MgrColumn.Prop(BEmailAccount.status.getDefaultDisplayName(null), BEmailAccount.status, 4);
    MgrColumn colSsl = new MgrColumn.Prop(BEmailAccount.useSsl.getDefaultDisplayName(null), BEmailAccount.useSsl, 3);
    final MgrColumn colAccount = new MgrColumn.Prop(emailLexicon.get("EmailAccountManager.column.account"), BEmailAccount.emailAuthenticator, 4){

        public String toDisplayString(Object row, Object value, Context context) {
            String account;
            BEmailAccount emailAccount = (BEmailAccount)row;
            if (!Flags.isUserDefined2((BComplex)emailAccount, (Slot)BEmailAccount.emailAuthenticator)) {
                Property deprecatedAccountProperty = BEmailAccount.account;
                account = emailAccount.getString(deprecatedAccountProperty);
            } else {
                Optional<Property> accountProp = Optional.ofNullable(((BComponent)value).getProperty("account"));
                account = accountProp.isPresent() ? emailAccount.getEmailAuthenticator().getString(accountProp.get()) : BString.DEFAULT.getString();
            }
            return account;
        }
    };
    MgrColumn colAuthenticationType = new MgrColumn.Prop(emailLexicon.get("EmailAccountManager.column.authenticationType"), BEmailAccount.emailAuthenticator, 1){

        public String toDisplayString(Object row, Object value, Context cx) {
            String authenticationType;
            BEmailAccount emailAccount = (BEmailAccount)row;
            if (!Flags.isUserDefined2((BComplex)emailAccount, (Slot)BEmailAccount.emailAuthenticator)) {
                boolean useAuthentication = emailAccount instanceof BIncomingAccount || emailAccount instanceof BOutgoingAccount && ((BOutgoingAccount)emailAccount).getUseAuthentication();
                String useAuthLexiconKey = String.format("EmailAccountManager.EmailAccount.useAuthentication.%s", useAuthentication);
                authenticationType = emailLexicon.get(useAuthLexiconKey);
            } else {
                String authenticatorTypeLexiconKey = String.format("EmailAccountManager.EmailClientAuthenticator.%s", ((BEmailAuthenticatorTypeConfig)value).getTypeSpec().getTypeName());
                authenticationType = emailLexicon.get(authenticatorTypeLexiconKey);
            }
            return authenticationType;
        }

        public BValue load(MgrEditRow row) {
            BEmailAuthenticatorTypeConfig currentAuthenticatorTypeConfig = (BEmailAuthenticatorTypeConfig)row.getTarget().get(this.prop);
            BEmailClientAuthenticator authenticatorInstanceFromTypeConfig = (BEmailClientAuthenticator)currentAuthenticatorTypeConfig.getTypeSpec().getInstance();
            currentAuthenticatorTypeConfig.syncTo((BObject)authenticatorInstanceFromTypeConfig);
            BEmailAuthenticatorTypeConfig newAuthenticatorTypeConfig = (BEmailAuthenticatorTypeConfig)currentAuthenticatorTypeConfig.newCopy();
            newAuthenticatorTypeConfig.setTypeSpec(currentAuthenticatorTypeConfig.getTypeSpec());
            newAuthenticatorTypeConfig.syncFrom((BObject)authenticatorInstanceFromTypeConfig);
            return newAuthenticatorTypeConfig;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent target = row.getTarget();
            BValue old = target.get(this.prop);
            if (!old.equivalent((Object)value)) {
                BEmailAuthenticatorTypeConfig oldTypeConfig = (BEmailAuthenticatorTypeConfig)old;
                BEmailAuthenticatorTypeConfig valueTypeConfig = (BEmailAuthenticatorTypeConfig)value;
                if (valueTypeConfig.getTypeSpec().equivalent((Object)oldTypeConfig.getTypeSpec())) {
                    for (Property dynamic : oldTypeConfig.getProperties()) {
                        CompUtil.setOrAdd((BComponent)oldTypeConfig, (String)dynamic.getName(), (BValue)valueTypeConfig.get(dynamic.getName()), (Context)cx);
                    }
                } else {
                    target.set(this.prop, value.newCopy(), cx);
                }
            }
        }
    };
    protected MgrColumn[] cols = new MgrColumn[]{this.colName, this.colEnabled, this.colProtocol, this.colHostName, this.colAccount, this.colAuthenticationType, this.colPort, this.colPollrate, this.colStatus, this.colSsl};

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    private class EmailProtocol
    extends MgrColumn {
        protected EmailProtocol(String displayName, int flags) {
            super(displayName, flags);
        }

        public Object get(Object row) {
            if ((BEmailAccount)row instanceof BOutgoingAccount) {
                return ((BOutgoingAccount)row).getTransport();
            }
            if ((BEmailAccount)row instanceof BIncomingAccount) {
                return ((BIncomingAccount)row).getStore();
            }
            return null;
        }

        public BValue load(MgrEditRow row) {
            if ((BEmailAccount)row.getTarget() instanceof BOutgoingAccount) {
                return ((BOutgoingAccount)row.getTarget()).getTransport().newCopy();
            }
            if ((BEmailAccount)row.getTarget() instanceof BIncomingAccount) {
                return ((BIncomingAccount)row.getTarget()).getStore().newCopy();
            }
            return null;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            if ((BEmailAccount)row.getTarget() instanceof BOutgoingAccount) {
                ((BOutgoingAccount)row.getTarget()).setTransport((BTransport)value);
            } else if ((BEmailAccount)row.getTarget() instanceof BIncomingAccount) {
                ((BIncomingAccount)row.getTarget()).setStore((BStore)value);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            Context cx;
            boolean outgoing = false;
            boolean incoming = false;
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i].getTarget() instanceof BOutgoingAccount) {
                    outgoing = true;
                }
                if (!(rows[i].getTarget() instanceof BIncomingAccount)) continue;
                incoming = true;
            }
            if (outgoing && incoming) {
                return null;
            }
            BValue val = rows[0].getCell(colIndex);
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, (Context)(cx = rows[0].getManager().getCurrentContext()));
            if (editor instanceof BStringFE) {
                editor = new BStringMgrColFE(colIndex);
            }
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, cx);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            BValue val = (BValue)editor.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val);
            }
        }
    }

    class Model
    extends MgrModel {
        Model(BAbstractManager mgr) {
            super(mgr);
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            return this.appendMixInColumns(BEmailAccountManager.this.cols, BEmailAccount.TYPE);
        }

        public int getSubscribeDepth() {
            return 2;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BEmailAccount.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((TypeInfo[])new TypeInfo[]{BOutgoingAccount.TYPE.getTypeInfo(), BIncomingAccount.TYPE.getTypeInfo()});
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BEmailAccount newInstance = (BEmailAccount)super.newInstance(type);
            int authenticatorFlags = newInstance.getFlags((Slot)BEmailAccount.emailAuthenticator);
            newInstance.setFlags((Slot)BEmailAccount.emailAuthenticator, authenticatorFlags | 0x20000000);
            BIncomingAccountClientAuthenticatorTypeConfig defaultSecureAuthenticator = newInstance instanceof BIncomingAccount ? new BIncomingAccountClientAuthenticatorTypeConfig() : new BOutgoingAccountClientAuthenticatorTypeConfig();
            defaultSecureAuthenticator.setTypeSpec(BOAuthEmailClientSecretAuthenticator.TYPE.getTypeSpec());
            defaultSecureAuthenticator.syncFrom((BObject)new BOAuthEmailClientSecretAuthenticator());
            newInstance.setEmailAuthenticator((BEmailAuthenticatorTypeConfig)defaultSecureAuthenticator);
            newInstance.setUseSsl(true);
            if (newInstance instanceof BIncomingAccount) {
                ((BIncomingAccount)newInstance).setStore(BStore.imap);
                int defaultIMAPSPort = 993;
                newInstance.setPort(993);
            } else {
                int defaultSMTPSPort = 587;
                newInstance.setPort(587);
            }
            return newInstance;
        }
    }
}

