/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupRegionNameResponse;
import com.tridium.aapup.messages.PupResponse;

public class PupCreateNamedRegionMessage
extends PupMessage
implements AaPupConst {
    private String regionName;
    private int regionNameLength;
    private int regionType;
    private int regionSize;

    public PupCreateNamedRegionMessage(int targetUnitNumber, String name, int type, int size) {
        super(targetUnitNumber);
        String tmpName = name.trim();
        this.regionName = tmpName.length() > 8 ? tmpName.substring(0, 8) : (tmpName.length() == 0 ? "?" : tmpName);
        this.regionNameLength = this.regionName.length();
        this.regionType = type;
        this.regionSize = size;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String name) {
        String tmpName = name.trim();
        this.regionName = tmpName.length() > 8 ? tmpName.substring(0, 8) : (tmpName.length() == 0 ? "?" : tmpName);
        this.regionNameLength = this.regionName.length();
    }

    public int getRegionType() {
        return this.regionType;
    }

    public void setRegionType(int type) {
        this.regionType = type;
        if (type < 0) {
            this.regionType = 0;
        }
        if (type > 127) {
            this.regionType = 127;
        }
    }

    public int getRegionSize() {
        return this.regionSize;
    }

    public void setRegionSize(int size) {
        this.regionSize = size;
        if (size < 0) {
            this.regionSize = 0;
        }
        if (size > 65535) {
            this.regionSize = 65535;
        }
    }

    @Override
    void writeBytes(PupOutputStream out) {
        out.write(9 + this.regionNameLength);
        out.write(7);
        out.write(this.regionType);
        out.writeInt(this.regionSize);
        out.write(this.regionNameLength);
        out.writeString(this.regionName);
    }

    @Override
    PupResponse getResponse(PupReceivedMessage rcvdMsg) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (rcvdMsg.getData()[4] == -128) {
            return new PupErrorResponse(rcvdMsg);
        }
        if (rcvdMsg.getData()[4] == -121) {
            return new PupRegionNameResponse(rcvdMsg);
        }
        return new PupErrorResponse(rcvdMsg);
    }

    @Override
    public String toString() {
        return "PupCreateNamedRegionMessage::unit:" + this.unitNumber + " regionName:" + this.regionName + " regionType:" + this.regionType + " regionSize:" + this.regionSize;
    }
}

