/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.comm;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupReportExceptionResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BBasicUnsolicitedReceive;
import java.util.Arrays;
import java.util.logging.Level;
import javax.baja.driver.BDevice;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BPupUnsolicitedReceive
extends BBasicUnsolicitedReceive
implements AaPupConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BPupUnsolicitedReceive.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    BPupNetwork getNetwork() {
        return (BPupNetwork)this.getParent();
    }

    protected void processUnsolicitedMessage(ReceivedMessage unsolicitedMsg) {
        BPupNetwork network = this.getNetwork();
        PupReceivedMessage msg = (PupReceivedMessage)unsolicitedMsg;
        PupResponse rsp = new PupResponse(msg);
        network.getPupLog().fine("UNSOLIC:" + ByteArrayUtil.toHexString((byte[])msg.getData()));
        if (rsp.getIn().isChecksumOK()) {
            if (!this.getNetwork().getTokenPassConfig().getTokenRecoveryType()) {
                this.getNetwork().initializeTokenRecoveryTimer();
            }
            if (rsp.getIn().getUnitNumber() == this.getNetwork().getUnitNumber()) {
                if (rsp.getIn().getCommand() == 3) {
                    int fromWho = rsp.getIn().readInt();
                    if (this.getNetwork().hasToken()) {
                        this.getNetwork().getTokenPassConfig().appendTokenSnoop("[!" + fromWho + ">" + rsp.getIn().getUnitNumber() + "!]\n");
                    } else {
                        this.getNetwork().getTokenPassConfig().appendTokenSnoop("[" + fromWho + ">" + rsp.getIn().getUnitNumber() + "]\n");
                    }
                    this.getNetwork().receivedToken(fromWho);
                } else {
                    this.getNetwork().getTokenPassConfig().appendTokenSnoop("<!" + rsp.getIn().getUnitNumber() + "!>");
                }
            } else if (rsp.getIn().getCommand() == 3) {
                int fromWhom = rsp.getIn().readInt();
                if (this.getNetwork().hasToken()) {
                    this.getNetwork().getTokenPassConfig().appendTokenSnoop("[!" + fromWhom + ">" + rsp.getIn().getUnitNumber() + "!]");
                } else {
                    this.getNetwork().getTokenPassConfig().appendTokenSnoop("[" + fromWhom + ">" + rsp.getIn().getUnitNumber() + "]");
                }
                this.getNetwork().initializeTokenRecoveryTimer();
            } else {
                if ((rsp.getIn().getUnitNumber() == 65535 || rsp.getIn().getUnitNumber() == network.getUnitNumber()) && rsp.getIn().getCommand() == 15) {
                    PupReportExceptionResponse exceptionRsp = new PupReportExceptionResponse(msg);
                    this.handleUnsolicitedExceptionResponse(exceptionRsp, network);
                }
                if (this.getNetwork().hasToken()) {
                    this.getNetwork().getTokenPassConfig().appendTokenSnoop("<!" + rsp.getIn().getUnitNumber() + "!>");
                } else {
                    this.getNetwork().getTokenPassConfig().appendTokenSnoop("<" + rsp.getIn().getUnitNumber() + ">");
                }
                this.getNetwork().initializeTokenRecoveryTimer();
            }
        } else if (network.getPupLog().isLoggable(Level.FINE)) {
            network.getPupLog().fine("unsolicited message with bad checksum: " + Arrays.toString(msg.getData()));
        }
    }

    protected void handleUnsolicitedExceptionResponse(PupReportExceptionResponse rsp, BPupNetwork network) {
        int source = rsp.getExceptionSource();
        network.getPupLog().fine("received unsolicited exception broadcast message from device " + source);
        BDevice[] devices = network.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            BPupDevice dev = (BPupDevice)devices[i];
            if (dev.getUnitNumber() != source) continue;
            dev.generateAlarm(rsp);
        }
    }
}

