/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import javax.baja.gx.Geom;
import javax.baja.gx.IPathGeom;

public final class PathGeom
extends Geom
implements IPathGeom {
    private IPathGeom.Segment[] segments;
    private int size;

    public PathGeom(IPathGeom path) {
        this.segments = path.segments();
        this.size = path.size();
    }

    public PathGeom(IPathGeom.Segment[] segments, int size) {
        this.segments = (IPathGeom.Segment[])segments.clone();
        this.size = size;
    }

    public PathGeom() {
        this.segments = new IPathGeom.Segment[10];
        this.size = 0;
    }

    @Override
    public int getGeomCase() {
        return 5;
    }

    @Override
    public IPathGeom.Segment[] segments() {
        IPathGeom.Segment[] copy = new IPathGeom.Segment[this.size];
        System.arraycopy(this.segments, 0, copy, 0, this.size);
        return copy;
    }

    @Override
    public IPathGeom.Segment segment(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.segments[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    public void closePath() {
        this.add(new IPathGeom.ClosePath());
    }

    public void moveTo(boolean abs, double x, double y) {
        this.add(new IPathGeom.MoveTo(abs, x, y));
    }

    public void lineTo(boolean abs, double x, double y) {
        this.add(new IPathGeom.LineTo(abs, x, y));
    }

    public void hlineTo(boolean abs, double x) {
        this.add(new IPathGeom.HLineTo(abs, x));
    }

    public void vlineTo(boolean abs, double y) {
        this.add(new IPathGeom.VLineTo(abs, y));
    }

    public void curveTo(boolean abs, double x2, double y2, double x1, double y1, double x, double y) {
        this.add(new IPathGeom.CurveTo(abs, x2, y2, x1, y1, x, y));
    }

    public void smoothCurveTo(boolean abs, double x2, double y2, double x, double y) {
        this.add(new IPathGeom.SmoothCurveTo(abs, x2, y2, x, y));
    }

    public void quadTo(boolean abs, double x1, double y1, double x, double y) {
        this.add(new IPathGeom.QuadTo(abs, x1, y1, x, y));
    }

    public void smoothQuadTo(boolean abs, double x, double y) {
        this.add(new IPathGeom.SmoothQuadTo(abs, x, y));
    }

    public void arcTo(boolean abs, double rx, double ry, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) {
        this.add(new IPathGeom.ArcTo(abs, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y));
    }

    public void add(IPathGeom.Segment segment) {
        if (this.size >= this.segments.length) {
            int newSize = Math.max(this.size * 2, 4);
            IPathGeom.Segment[] temp = new IPathGeom.Segment[newSize];
            System.arraycopy(this.segments, 0, temp, 0, this.size);
            this.segments = temp;
        }
        this.segments[this.size++] = segment;
        this.dirty();
    }

    public void clear() {
        this.size = 0;
        this.dirty();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathGeom) {
            PathGeom o = (PathGeom)obj;
            if (this.size != o.size) {
                return false;
            }
            return PathGeom.equals(this.segments, o.segments, this.size);
        }
        return false;
    }

    public String toString() {
        return PathGeom.toString(this.segments, this.size);
    }

    static boolean equals(IPathGeom.Segment[] a, IPathGeom.Segment[] b, int size) {
        for (int i = 0; i < size; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    static String toString(IPathGeom.Segment[] segments, int size) {
        IPathGeom.Segment lastSeg = null;
        char lastCommand = '\u0000';
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            IPathGeom.Segment thisSeg;
            char thisCommand;
            if (i > 0) {
                s.append(' ');
            }
            if (lastCommand != (thisCommand = (thisSeg = segments[i]).getCommand())) {
                s.append(thisCommand);
                lastCommand = thisCommand;
            }
            thisSeg.toString(s);
            lastSeg = thisSeg;
        }
        return s.toString();
    }
}

