/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BPen
extends BSimple {
    public static final int CAP_BUTT = 101;
    public static final int CAP_SQUARE = 102;
    public static final int CAP_ROUND = 103;
    public static final int JOIN_MITER = 201;
    public static final int JOIN_ROUND = 202;
    public static final int JOIN_BEVEL = 203;
    private static double[] noDash = new double[0];
    public static final BPen DEFAULT = BPen.make(1.0);
    public static final Type TYPE = Sys.loadType(BPen.class);
    private double width;
    private int cap;
    private int join;
    private double[] dash;
    private String string;
    private Object awtSupport;

    public static BPen make(double width) {
        return BPen.make(width, 101, 201, null);
    }

    public static BPen make(double width, double[] dash) {
        return BPen.make(width, 101, 201, dash);
    }

    public static BPen make(double width, int cap, int join, double[] dash) {
        return new BPen(width, cap, join, dash);
    }

    public static BPen make(String s) {
        Parser parser = new Parser(s);
        BPen x = parser.parsePen();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    private BPen(double width, int cap, int join, double[] dash) {
        if (width < 0.0) {
            throw new IllegalArgumentException("width " + width);
        }
        if (cap != 101 && cap != 102 && cap != 103) {
            throw new IllegalArgumentException("cap " + cap);
        }
        if (join != 201 && join != 202 && join != 203) {
            throw new IllegalArgumentException("join " + join);
        }
        if (dash == null) {
            dash = noDash;
        }
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.dash = dash;
    }

    public double getWidth() {
        return this.width;
    }

    public int getCap() {
        return this.cap;
    }

    public int getJoin() {
        return this.join;
    }

    public double[] getDash() {
        if (this.dash.length == 0) {
            return this.dash;
        }
        return (double[])this.dash.clone();
    }

    public int hashCode() {
        int len = this.dash != null ? this.dash.length : 0;
        long hash = 23L + (long)len;
        for (int i = 0; i < len; ++i) {
            hash = hash * 37L + Double.doubleToRawLongBits(this.dash[i]);
        }
        hash = hash * 37L + Double.doubleToRawLongBits(this.width);
        hash = hash * 37L + (long)this.cap;
        hash = hash * 37L + (long)this.join;
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BPen) {
            BPen x = (BPen)((Object)obj);
            if (this.dash.length != x.dash.length) {
                return false;
            }
            for (int i = 0; i < this.dash.length; ++i) {
                if (this.dash[i] == x.dash[i]) continue;
                return false;
            }
            return this.width == x.width && this.cap == x.cap && this.join == x.join;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.string == null) {
            StringBuilder s = new StringBuilder();
            s.append(BDouble.encode((double)this.width));
            if (this.cap != 101) {
                s.append(' ').append(this.getCapString());
            }
            if (this.join != 201) {
                s.append(' ').append(this.getJoinString());
            }
            if (this.dash.length > 0) {
                s.append(" dash(");
                for (int i = 0; i < this.dash.length; ++i) {
                    if (i > 0) {
                        s.append(',');
                    }
                    s.append(BDouble.encode((double)this.dash[i]));
                }
                s.append(')');
            }
            this.string = s.toString();
        }
        return this.string;
    }

    String getCapString() {
        switch (this.cap) {
            case 101: {
                return "capButt";
            }
            case 102: {
                return "capSquare";
            }
            case 103: {
                return "capRound";
            }
        }
        throw new IllegalStateException();
    }

    String getJoinString() {
        switch (this.join) {
            case 201: {
                return "joinMiter";
            }
            case 202: {
                return "joinRound";
            }
            case 203: {
                return "joinBevel";
            }
        }
        throw new IllegalStateException();
    }

    public BObject decodeFromString(String s) throws IOException {
        return BPen.make(s);
    }

    public Type getType() {
        return TYPE;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = a;
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }
}

