/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.IOException;
import javax.baja.gx.BGeom;
import javax.baja.gx.IEllipseGeom;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BEllipseGeom
extends BGeom
implements IEllipseGeom {
    public static final BEllipseGeom DEFAULT = new BEllipseGeom(0.0, 0.0, 0.0, 0.0);
    public static final BEllipseGeom NULL = new BEllipseGeom(0.0, 0.0, 0.0, 0.0);
    public static final Type TYPE = Sys.loadType(BEllipseGeom.class);
    public final double x;
    public final double y;
    public final double width;
    public final double height;

    public static BEllipseGeom make(double x, double y, double width, double height) {
        return new BEllipseGeom(x, y, width, height);
    }

    public static BEllipseGeom make(IEllipseGeom r) {
        if (r instanceof BEllipseGeom) {
            return (BEllipseGeom)r;
        }
        return BEllipseGeom.make(r.x(), r.y(), r.width(), r.height());
    }

    public static BEllipseGeom make(String s) {
        Parser parser = new Parser(s);
        BEllipseGeom x = parser.parseEllipse();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    private BEllipseGeom(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getGeomCase() {
        return 3;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double width() {
        return this.width;
    }

    @Override
    public double height() {
        return this.height;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int hashCode() {
        long hash = 23L + Double.doubleToRawLongBits(this.x);
        hash = hash * 37L + Double.doubleToRawLongBits(this.y);
        hash = hash * 37L + Double.doubleToRawLongBits(this.width);
        hash = hash * 37L + Double.doubleToRawLongBits(this.height);
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BEllipseGeom) {
            BEllipseGeom r = (BEllipseGeom)obj;
            return this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
        }
        return false;
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(BDouble.encode((double)this.x)).append(',').append(BDouble.encode((double)this.y)).append(',').append(BDouble.encode((double)this.width)).append(',').append(BDouble.encode((double)this.height));
        return sb.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        return BEllipseGeom.make(s);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

