/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BPoint;
import javax.baja.gx.IPoint;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BBrush
extends BSimple {
    public static final int PAD = 1;
    public static final int REFLECT = 2;
    public static final int REPEAT = 3;
    public static final int TILE_FALSE = 0;
    public static final int TILE_TRUE = 1;
    public static final int TILE_X = 2;
    public static final int TILE_Y = 3;
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final BBrush NULL = BBrush.makeSolid(BColor.NULL);
    public static final BBrush DEFAULT = BBrush.makeSolid(BColor.black);
    public static final Type TYPE = Sys.loadType(BBrush.class);
    private Paint paint;
    private Object awtSupport;

    public static BBrush makeSolid(BColor solid) {
        if (solid.brush == null) {
            solid.brush = new BBrush(new Solid(solid));
        }
        return solid.brush;
    }

    public static BBrush makeInverse(BColor inverse) {
        return new BBrush(new Inverse(inverse));
    }

    public static BBrush makeLinearGradient(Stop[] stops) {
        return BBrush.makeLinearGradient(stops, 1, 0.0);
    }

    public static BBrush makeLinearGradient(Stop[] stops, int spread, double angle) {
        return new BBrush(new LinearGradient(stops, spread, angle));
    }

    public static BBrush makeRadialGradient(Stop[] stops) {
        return BBrush.makeRadialGradient(stops, 1, BPoint.make(50.0, 50.0), 50.0);
    }

    public static BBrush makeRadialGradient(Stop[] stops, int spread, IPoint center, double radius) {
        return BBrush.makeRadialGradient(stops, spread, center, radius, center);
    }

    public static BBrush makeRadialGradient(Stop[] stops, int spread, IPoint center, double radius, IPoint focal) {
        return new BBrush(new RadialGradient(stops, spread, center, radius, focal));
    }

    public static BBrush makeImage(BImage image, int tile, int halign, int valign) {
        return new BBrush(new Image(image, tile, halign, valign));
    }

    public static BBrush makeImage(BImage image) {
        return BBrush.makeImage(image, 0, 0, 0);
    }

    public static BBrush make(String s) {
        Parser parser = new Parser(s);
        BBrush x = parser.parseBrush();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    private BBrush(Paint paint) {
        this.paint = paint;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int hashCode() {
        String paintStr = this.paint != null ? this.paint.toString() : null;
        return paintStr != null ? paintStr.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BBrush) {
            return this.paint.equals(((BBrush)((Object)obj)).paint);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        return this.paint.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        return BBrush.make(s);
    }

    public static Stop stop(double offset, BColor color) {
        return new Stop(offset, color);
    }

    public Type getType() {
        return TYPE;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = a;
                return null;
            }
            case 205: {
                this.setBaseOrd((BOrd)a);
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void setBaseOrd(BOrd baseOrd) {
        if (this.paint instanceof Image) {
            BImage img = ((Image)this.paint).getImage();
            img.setBaseOrd(baseOrd);
        }
    }

    public static class Image
    extends Paint {
        final BImage image;
        final int tile;
        final int halign;
        final int valign;
        String string;

        Image(BImage image, int tile, int halign, int valign) {
            if (image == null) {
                throw new NullPointerException("image");
            }
            if (tile != 1 && tile != 0 && tile != 2 && tile != 3) {
                throw new IllegalArgumentException("tile");
            }
            if (halign != 3 && halign != 0 && halign != 4) {
                throw new IllegalArgumentException("halign");
            }
            if (valign != 1 && valign != 0 && valign != 2) {
                throw new IllegalArgumentException("valign");
            }
            this.image = image;
            this.tile = tile;
            this.halign = halign;
            this.valign = valign;
        }

        public BImage getImage() {
            return this.image;
        }

        public int getTile() {
            return this.tile;
        }

        public int getHalign() {
            return this.halign;
        }

        public int getValign() {
            return this.valign;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Image) {
                Image x = (Image)obj;
                return this.image.equals((Object)x.image) && this.tile == x.tile && this.halign == x.halign && this.valign == x.valign;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.image, this.tile, this.halign, this.valign});
        }

        @Override
        public String toString() {
            if (this.string == null) {
                StringBuilder s = new StringBuilder();
                String source = this.image.toString();
                s.append("image( source(").append(source).append(") ");
                switch (this.tile) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        s.append("tile(true) ");
                        break;
                    }
                    case 2: {
                        s.append("tile(x) ");
                        break;
                    }
                    case 3: {
                        s.append("tile(y) ");
                    }
                }
                switch (this.halign) {
                    case 3: {
                        s.append("halign(left) ");
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 4: {
                        s.append("halign(right) ");
                    }
                }
                switch (this.valign) {
                    case 1: {
                        s.append("valign(top) ");
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 2: {
                        s.append("valign(bottom) ");
                    }
                }
                s.append(")");
                this.string = s.toString();
            }
            return this.string;
        }
    }

    public static final class Stop {
        final double offset;
        final BColor color;

        Stop(double offset, BColor color) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.offset = offset;
            this.color = color;
        }

        public double getOffset() {
            return this.offset;
        }

        public BColor getColor() {
            return this.color;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Stop) {
                Stop x = (Stop)obj;
                return this.offset == x.offset && this.color.equals((Object)x.color);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.offset, this.color});
        }

        public String toString() {
            return "stop(" + BDouble.encode((double)this.offset) + "% " + (Object)((Object)this.color) + ")";
        }
    }

    public static class RadialGradient
    extends Gradient {
        final BPoint center;
        final double radius;
        final BPoint focal;

        RadialGradient(Stop[] stops, int spread, IPoint center, double radius, IPoint focal) {
            super(stops, spread);
            this.center = BPoint.make(center);
            this.radius = radius;
            this.focal = BPoint.make(focal);
        }

        public BPoint getCenter() {
            return this.center;
        }

        public double getRadius() {
            return this.radius;
        }

        public BPoint getFocal() {
            return this.focal;
        }

        @Override
        boolean doEquals(Gradient g) {
            RadialGradient x = (RadialGradient)g;
            return this.center.equals(x.center) && this.radius == x.radius && this.focal.equals(x.focal);
        }

        @Override
        String getStringStart() {
            return "radialGradient";
        }

        @Override
        void doString(StringBuffer s) {
            if (this.center.x != 50.0 || this.center.y != 50.0) {
                s.append(" c(").append(BDouble.encode((double)this.center.x)).append("% ").append(BDouble.encode((double)this.center.y)).append("%)");
            }
            if (this.radius != 50.0) {
                s.append(" r(").append(BDouble.encode((double)this.radius)).append("%)");
            }
            if (this.focal.x != this.center.x || this.focal.y != this.center.y) {
                s.append(" f(").append(BDouble.encode((double)this.focal.x)).append("% ").append(BDouble.encode((double)this.focal.y)).append("%)");
            }
        }
    }

    public static class LinearGradient
    extends Gradient {
        final double angle;

        LinearGradient(Stop[] stops, int spread, double angle) {
            super(stops, spread);
            this.angle = angle;
        }

        public double getAngle() {
            return this.angle;
        }

        @Override
        boolean doEquals(Gradient g) {
            LinearGradient x = (LinearGradient)g;
            return this.angle == x.angle;
        }

        @Override
        String getStringStart() {
            return "linearGradient";
        }

        @Override
        void doString(StringBuffer s) {
            if (this.angle != 0.0) {
                s.append(" angle(").append(BDouble.encode((double)this.angle)).append(')');
            }
        }
    }

    public static abstract class Gradient
    extends Paint {
        final Stop[] stops;
        final int spread;
        String string;

        Gradient(Stop[] stops, int spread) {
            if (spread != 1 && spread != 2 && spread != 3) {
                throw new IllegalArgumentException("spread");
            }
            this.stops = (Stop[])stops.clone();
            this.spread = spread;
        }

        public Stop[] getStops() {
            return (Stop[])this.stops.clone();
        }

        public int getSpread() {
            return this.spread;
        }

        public final boolean equals(Object obj) {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Gradient x = (Gradient)obj;
            if (this.spread != x.spread) {
                return false;
            }
            if (this.stops.length != x.stops.length) {
                return false;
            }
            for (int i = 0; i < this.stops.length; ++i) {
                if (this.stops[i].equals(x.stops[i])) continue;
                return false;
            }
            return this.doEquals(x);
        }

        abstract boolean doEquals(Gradient var1);

        @Override
        public final String toString() {
            if (this.string == null) {
                StringBuffer s = new StringBuffer(64);
                s.append(this.getStringStart());
                s.append('(');
                if (this.spread == 2) {
                    s.append(" reflect");
                } else if (this.spread == 3) {
                    s.append(" repeat");
                }
                this.doString(s);
                for (int i = 0; i < this.stops.length; ++i) {
                    s.append(' ').append(this.stops[i]);
                }
                s.append(" )");
                this.string = s.toString();
            }
            return this.string;
        }

        abstract String getStringStart();

        abstract void doString(StringBuffer var1);
    }

    public static class Inverse
    extends Solid {
        Inverse(BColor color) {
            super(color);
        }

        @Override
        public String toString() {
            return "inverse(" + this.color.encodeToString() + ")";
        }
    }

    public static class Solid
    extends Paint {
        final BColor color;

        Solid(BColor color) {
            this.color = color;
        }

        public BColor getColor() {
            return this.color;
        }

        public boolean equals(Object obj) {
            return this.getClass() == obj.getClass() && this.color.equals((Object)((Solid)obj).color);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.color});
        }

        @Override
        public String toString() {
            return this.color.encodeToString();
        }
    }

    public static abstract class Paint {
        Paint() {
        }

        public abstract String toString();
    }
}

