/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.util;

import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;

public abstract class GeomUtil {
    public static final double NEAR = 3.0;

    public static int nearest(Point pnt, Point[] segs, boolean closed) {
        double d;
        double dist = GeomUtil.dist(pnt, segs[0], segs[1]);
        int idx = 0;
        for (int i = 1; i < segs.length - 1; ++i) {
            double d2 = GeomUtil.dist(pnt, segs[i], segs[i + 1]);
            if (!(d2 < dist)) continue;
            dist = d2;
            idx = i;
        }
        if (closed && (d = GeomUtil.dist(pnt, segs[segs.length - 1], segs[0])) < dist) {
            dist = d;
            idx = segs.length - 1;
        }
        return idx;
    }

    public static double dist(Point pnt, Point[] segs) {
        double dist = GeomUtil.dist(pnt, segs[0], segs[1]);
        for (int i = 1; i < segs.length - 1; ++i) {
            dist = Math.min(dist, GeomUtil.dist(pnt, segs[i], segs[i + 1]));
        }
        return dist;
    }

    public static double dist(Point pntA, Point pnt1, Point pnt2) {
        double dist;
        if (pnt1.equals(pnt2)) {
            dist = GeomUtil.dist(pntA, pnt1);
        } else if (pnt1.y == pnt2.y) {
            double minX = Math.min(pnt1.x, pnt2.x);
            double maxX = Math.max(pnt1.x, pnt2.x);
            dist = pntA.x < minX || pntA.x > maxX ? Math.min(GeomUtil.dist(pntA, pnt1), GeomUtil.dist(pntA, pnt2)) : Math.abs(pntA.y - pnt1.y);
        } else if (pnt1.x == pnt2.x) {
            double minY = Math.min(pnt1.y, pnt2.y);
            double maxY = Math.max(pnt1.y, pnt2.y);
            dist = pntA.y < minY || pntA.y > maxY ? Math.min(GeomUtil.dist(pntA, pnt1), GeomUtil.dist(pntA, pnt2)) : Math.abs(pntA.x - pnt1.x);
        } else {
            Point foot = GeomUtil.getFoot(pntA, pnt1, pnt2);
            double minX = Math.min(pnt1.x, pnt2.x);
            double maxX = Math.max(pnt1.x, pnt2.x);
            dist = foot.x >= minX && foot.x <= maxX ? GeomUtil.dist(pntA, foot) : Math.min(GeomUtil.dist(pntA, pnt1), GeomUtil.dist(pntA, pnt2));
        }
        return dist;
    }

    public static double dist(Point pntA, Point pntB) {
        return Math.sqrt(Math.pow(pntA.x - pntB.x, 2.0) + Math.pow(pntA.y - pntB.y, 2.0));
    }

    public static RectGeom makeRectangle(double X0, double Y0, double X1, double Y1) {
        double minX = Math.min(X0, X1);
        double minY = Math.min(Y0, Y1);
        double maxX = Math.max(X0, X1);
        double maxY = Math.max(Y0, Y1);
        return new RectGeom(minX, minY, maxX - minX, maxY - minY);
    }

    public static boolean contains(IRectGeom outer, IRectGeom inner) {
        if (GeomUtil.isDegenerate(outer)) {
            return false;
        }
        if (GeomUtil.isDegenerate(inner)) {
            return outer.contains(inner.x(), inner.y()) && outer.contains(inner.x() + inner.width(), inner.y() + inner.height());
        }
        return outer.contains(inner);
    }

    private static boolean isDegenerate(IRectGeom rect) {
        return rect.width() == 0.0 || rect.height() == 0.0;
    }

    private static Point getFoot(Point pntA, Point pnt1, Point pnt2) {
        if (pnt1.equals(pnt2)) {
            throw new IllegalArgumentException();
        }
        if (pnt1.y == pnt2.y) {
            return new Point(pntA.x, pnt1.y);
        }
        if (pnt1.x == pnt2.x) {
            return new Point(pnt1.x, pntA.y);
        }
        double m = (pnt1.y - pnt2.y) / (pnt1.x - pnt2.x);
        double b = pnt1.y - m * pnt1.x;
        double fX = (m * pntA.y + pntA.x - m * b) / (m * m + 1.0);
        double fY = (m * m * pntA.y + m * pntA.x + b) / (m * m + 1.0);
        return new Point(fX, fY);
    }

    public static ArcDefinition calculateArc(double startX, double startY, double endX, double endY, double rx, double ry, double angleDegrees, boolean largeArcFlag, boolean sweepFlag) {
        double Pry;
        double Py1;
        double dx2 = (startX - endX) / 2.0;
        double dy2 = (startY - endY) / 2.0;
        double angle = Math.toRadians(angleDegrees % 360.0);
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        double x1 = cosAngle * dx2 + sinAngle * dy2;
        double y1 = -sinAngle * dx2 + cosAngle * dy2;
        double Px1 = x1 * x1;
        double Prx = (rx = Math.abs(rx)) * rx;
        double radiiCheck = Px1 / Prx + (Py1 = y1 * y1) / (Pry = (ry = Math.abs(ry)) * ry);
        if (radiiCheck > 1.0) {
            rx = Math.sqrt(radiiCheck) * rx;
            ry = Math.sqrt(radiiCheck) * ry;
            Prx = rx * rx;
            Pry = ry * ry;
        }
        double sign = largeArcFlag == sweepFlag ? -1.0 : 1.0;
        double sq = (Prx * Pry - Prx * Py1 - Pry * Px1) / (Prx * Py1 + Pry * Px1);
        sq = sq < 0.0 ? 0.0 : sq;
        double coef = sign * Math.sqrt(sq);
        double cx1 = coef * (rx * y1 / ry);
        double cy1 = coef * -(ry * x1 / rx);
        double sx2 = (startX + endX) / 2.0;
        double sy2 = (startY + endY) / 2.0;
        double cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        double cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (x1 - cx1) / rx;
        double uy = (y1 - cy1) / ry;
        double vx = (-x1 - cx1) / rx;
        double vy = (-y1 - cy1) / ry;
        double n = Math.sqrt(ux * ux + uy * uy);
        double p = ux;
        sign = uy < 0.0 ? -1.0 : 1.0;
        double angleStart = Math.toDegrees(sign * Math.acos(p / n));
        n = Math.sqrt((ux * ux + uy * uy) * (vx * vx + vy * vy));
        p = ux * vx + uy * vy;
        sign = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        double angleExtent = Math.toDegrees(sign * Math.acos(p / n));
        if (!sweepFlag && angleExtent > 0.0) {
            angleExtent -= 360.0;
        } else if (sweepFlag && angleExtent < 0.0) {
            angleExtent += 360.0;
        }
        ArcDefinition def = new ArcDefinition();
        def.centerX = cx;
        def.centerY = cy;
        def.startAngleDegrees = angleStart %= 360.0;
        def.endAngleDegrees = angleStart + (angleExtent %= 360.0);
        return def;
    }

    public static class ArcDefinition {
        public double centerX;
        public double centerY;
        public double startAngleDegrees;
        public double endAngleDegrees;
    }
}

