/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx;

import com.tridium.gx.FontPeer;
import com.tridium.gx.GeomPeer;
import com.tridium.gx.GraphPaper;
import com.tridium.gx.GxEnvListener;
import com.tridium.gx.Hatching;
import com.tridium.gx.ImagePeer;
import java.io.InputStream;
import java.security.AccessController;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.IGeom;
import javax.baja.sys.Sys;

public abstract class GxEnv {
    private static GxEnv env;
    private static final boolean FORCE_MICRO;
    private static final boolean FORCE_MICRO_STATION;
    GxEnvListener listener;
    private static final Logger LOG;
    private static final int FRACTIONAL_FONT_METRICS;
    private static final int FFM_OFF = 0;
    private static final int FFM_STATION_ONLY = 1;
    private static final int FFM_WB_ONLY = 2;
    private static final int FFM_ON = 3;

    public static GxEnv get() {
        if (env == null) {
            boolean forceMicro;
            boolean bl = forceMicro = FORCE_MICRO || FORCE_MICRO_STATION && Sys.getStation() != null;
            if (!forceMicro) {
                try {
                    env = (GxEnv)Sys.newInstance((String)"gx", (String)"com.tridium.gx.awt.se.AwtSeEnv");
                }
                catch (Throwable throwable) {
                    LOG.log(Level.FINE, "Unable to instantiate AwtSeEnv", throwable);
                }
            }
            if (env == null) {
                try {
                    if (forceMicro) {
                        LOG.log(Level.FINE, "Forcing gx MicroEnv");
                    }
                    env = (GxEnv)Sys.newInstance((String)"gx", (String)"com.tridium.gx.micro.MicroEnv");
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Cannot load gx:MicroEnv", e);
                }
            }
            if (env == null) {
                throw new IllegalStateException("No GxEnv available for VM");
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "GxEnv: " + env.getClass());
            }
        }
        return env;
    }

    public abstract boolean isRotationSupported();

    public abstract FontPeer makeFontPeer(BFont var1);

    public FontPeer makeFontPeer(BFont font, boolean useAntialiasing, boolean useFractionalFontMetrics) {
        return this.makeFontPeer(font);
    }

    public abstract GeomPeer makeGeomPeer(IGeom var1);

    public abstract ImagePeer makeImagePeer(BImage var1);

    public abstract BImage makeImage(double var1, double var3);

    public abstract BImage makeImage(byte[] var1);

    public BImage makeDisabled(BImage orig) {
        return orig;
    }

    public BImage makeHighlighted(BImage orig) {
        return orig;
    }

    public GxEnvListener getGxEnvListener() {
        return this.listener;
    }

    public void setGxEnvListener(GxEnvListener listener) {
        if (this.listener != null) {
            LOG.warning("GxEnv setGxEnvListener: " + this.listener);
        }
        this.listener = listener;
    }

    public void repaintAll() {
        try {
            if (this.listener != null) {
                this.listener.repaintAll();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public GraphPaper makeGraphPaper() {
        throw new UnsupportedOperationException("GraphPaper not supported.");
    }

    public Hatching makeHatching() {
        throw new UnsupportedOperationException("Hatching not supported.");
    }

    public boolean loadFont(InputStream in) {
        return true;
    }

    public String getValidFontName(String fontList) {
        return null;
    }

    public boolean hasFont(String fontName) {
        return false;
    }

    public void overrideFontFamily(String fontFamily, String valueName) {
    }

    public abstract List<String> getFontList();

    public static boolean shouldUseFractionalFontMetrics() {
        if (!FractionalFontMetricsHolder._CAN_USE_FRACTIONAL_FONT_METRICS) {
            return false;
        }
        switch (FRACTIONAL_FONT_METRICS) {
            case 3: {
                return true;
            }
            case 1: {
                return Sys.isStation();
            }
            case 2: {
                return !Sys.isStation();
            }
        }
        return false;
    }

    private static boolean getCanUseFractionFontMetrics() {
        return !"com.tridium.gx.micro.MicroEnv".equals(GxEnv.get().getClass().getName());
    }

    private static int getFractionalFontMetrics() {
        try {
            switch (AccessController.doPrivileged(() -> System.getProperty("gx.fractionalFontMetrics"))) {
                case "on": 
                case "true": {
                    return 3;
                }
                case "stationOnly": {
                    return 1;
                }
                case "wbOnly": {
                    return 2;
                }
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    static /* synthetic */ boolean access$000() {
        return GxEnv.getCanUseFractionFontMetrics();
    }

    static {
        FORCE_MICRO = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.ui.env.forceMicro"));
        FORCE_MICRO_STATION = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.ui.env.forceMicroStation"));
        LOG = Logger.getLogger("gx");
        FRACTIONAL_FONT_METRICS = GxEnv.getFractionalFontMetrics();
    }

    public static class FractionalFontMetricsHolder {
        public static boolean _CAN_USE_FRACTIONAL_FONT_METRICS = GxEnv.access$000();
    }
}

