/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagararemoteclient;

import java.nio.ByteBuffer;
import java.util.Objects;

public class NiagaraRemoteMessage {
    private final byte messageType;
    private final int header;
    private final byte[] messageData;

    public NiagaraRemoteMessage(byte messageType, int header, byte[] messageData) {
        this.messageType = messageType;
        this.header = header;
        this.messageData = messageData;
    }

    public static NiagaraRemoteMessage parseMessage(byte[] messageBytes, int offset, int length) {
        Objects.requireNonNull(messageBytes);
        if (length < 5) {
            throw new IllegalArgumentException("Message too short");
        }
        ByteBuffer buffer = ByteBuffer.wrap(messageBytes, offset, length);
        byte messageType = buffer.get();
        if (messageType != 5 && messageType != 3 && messageType != 1 && messageType != 2 && messageType != 4) {
            throw new IllegalArgumentException(String.format("Unrecognized message type 0x%02x", messageType));
        }
        int header = buffer.getInt();
        byte[] messageData = null;
        if (buffer.hasRemaining()) {
            messageData = new byte[buffer.remaining()];
            buffer.get(messageData);
        }
        return new NiagaraRemoteMessage(messageType, header, messageData);
    }

    public byte[] toBytes() {
        int messageLength = 5;
        if (this.messageData != null) {
            messageLength += this.messageData.length;
        }
        byte[] message = new byte[messageLength];
        ByteBuffer buffer = ByteBuffer.wrap(message);
        buffer.put(this.messageType);
        buffer.putInt(this.header);
        if (this.messageData != null) {
            buffer.put(this.messageData);
        }
        return message;
    }

    public byte getMessageType() {
        return this.messageType;
    }

    public int getHeader() {
        return this.header;
    }

    public byte[] getMessageData() {
        return this.messageData;
    }
}

