/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.util;

import com.tridium.cloudLink.util.IResettableCompressionStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public final class ResettableGZIPOutputStream
extends GZIPOutputStream
implements IResettableCompressionStream {
    private final ByteArrayOutputStream memoryStream;
    private static final int GZIP_MAGIC = 35615;

    public ResettableGZIPOutputStream(int size) throws IOException {
        super((OutputStream)new ByteArrayOutputStream(), size);
        this.memoryStream = (ByteArrayOutputStream)this.out;
    }

    public ResettableGZIPOutputStream(int size, boolean syncFlush) throws IOException {
        super((OutputStream)new ByteArrayOutputStream(), size, syncFlush);
        this.memoryStream = (ByteArrayOutputStream)this.out;
    }

    public ResettableGZIPOutputStream() throws IOException {
        super(new ByteArrayOutputStream());
        this.memoryStream = (ByteArrayOutputStream)this.out;
    }

    public ResettableGZIPOutputStream(boolean syncFlush) throws IOException {
        super((OutputStream)new ByteArrayOutputStream(), syncFlush);
        this.memoryStream = (ByteArrayOutputStream)this.out;
    }

    @Override
    public void reset() throws IOException {
        this.memoryStream.reset();
        this.def.reset();
        this.myWriteHeader();
        this.crc.reset();
    }

    @Override
    public byte[] toCompressedByteArray() {
        return this.memoryStream.toByteArray();
    }

    @Override
    public String getContentTypeExtension() {
        return "+gzip";
    }

    private void myWriteHeader() throws IOException {
        this.out.write(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0});
    }
}

