/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;

public class MergedListsView<T> {
    private List<List<T>> lists;
    private Cursor<T> cursor = null;
    private Context cursorContext;
    private Iterator<T> cursorIterator = null;
    private int cursorListIndex = -1;
    private T cursorItem = null;

    public MergedListsView() {
        this.lists = new LinkedList<List<T>>();
        this.cursorContext = Context.NULL;
    }

    public MergedListsView(List<T> list) {
        this.lists = new LinkedList<List>(Arrays.asList(list));
        this.cursorContext = Context.NULL;
    }

    public MergedListsView(List<T> list, Context cursorContext) {
        this.lists = new LinkedList<List>(Arrays.asList(list));
        this.cursorContext = cursorContext;
    }

    public void addList(List<T> list) {
        if (list != null) {
            this.lists.add(list);
        }
    }

    public void setCursorContext(Context cursorContext) {
        this.cursorContext = cursorContext;
    }

    public Cursor<T> getCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        this.cursorListIndex = 0;
        this.cursor = new Cursor<T>(){

            public Context getContext() {
                return MergedListsView.this.cursorContext;
            }

            public boolean next() {
                if (MergedListsView.this.lists.isEmpty()) {
                    return false;
                }
                if (MergedListsView.this.cursorIterator == null) {
                    MergedListsView.this.cursorIterator = ((List)MergedListsView.this.lists.get(MergedListsView.this.cursorListIndex)).listIterator();
                    if (MergedListsView.this.cursorIterator.hasNext()) {
                        MergedListsView.this.cursorItem = MergedListsView.this.cursorIterator.next();
                        return true;
                    }
                }
                if (MergedListsView.this.cursorIterator.hasNext()) {
                    MergedListsView.this.cursorItem = MergedListsView.this.cursorIterator.next();
                    return true;
                }
                while (++MergedListsView.this.cursorListIndex < MergedListsView.this.lists.size()) {
                    MergedListsView.this.cursorIterator = ((List)MergedListsView.this.lists.get(MergedListsView.this.cursorListIndex)).listIterator();
                    if (!MergedListsView.this.cursorIterator.hasNext()) continue;
                    MergedListsView.this.cursorItem = MergedListsView.this.cursorIterator.next();
                    return true;
                }
                return false;
            }

            public T get() {
                return MergedListsView.this.cursorItem;
            }

            public void close() {
                MergedListsView.this.cursor = null;
                MergedListsView.this.cursorIterator = null;
                MergedListsView.this.cursorListIndex = -1;
                MergedListsView.this.cursorItem = null;
            }
        };
        return this.cursor;
    }

    public T get(int i) {
        MergedIndex index = this.findMergedIndex(i);
        if (index == null) {
            return null;
        }
        return this.lists.get(index.globalIndex).get(index.localIndex);
    }

    public int size() {
        int size = 0;
        for (List<T> list : this.lists) {
            size += list.size();
        }
        return size;
    }

    public List<List<T>> getLists() {
        return this.lists;
    }

    public MergedListsView<T> subView(int start, int end) {
        if (start > end) {
            return null;
        }
        if (start == end) {
            MergedListsView<T> mergedListsView = new MergedListsView<T>();
            mergedListsView.setCursorContext((Context)new BasicContext(this.cursorContext));
            return mergedListsView;
        }
        MergedIndex startIndex = this.findMergedIndex(start);
        MergedIndex endIndex = this.findMergedIndex(end - 1);
        if (startIndex == null || endIndex == null) {
            return null;
        }
        MergedListsView<T> subView = new MergedListsView<T>();
        subView.setCursorContext((Context)new BasicContext(this.cursorContext));
        if (startIndex.globalIndex == endIndex.globalIndex) {
            subView.addList(this.lists.get(startIndex.globalIndex).subList(startIndex.localIndex, endIndex.localIndex + 1));
            return subView;
        }
        List<T> startList = this.lists.get(startIndex.globalIndex);
        List<T> endList = this.lists.get(endIndex.globalIndex);
        subView.addList(startList.subList(startIndex.localIndex, startList.size()));
        for (int i = startIndex.globalIndex + 1; i < endIndex.globalIndex - 1; ++i) {
            subView.addList(this.lists.get(i));
        }
        subView.addList(endList.subList(0, endIndex.localIndex + 1));
        return subView;
    }

    private MergedIndex findMergedIndex(int i) {
        if (i < 0 || this.lists.isEmpty()) {
            return null;
        }
        ListIterator<List<T>> it = this.lists.listIterator();
        List<T> list = it.next();
        while (i >= list.size() && it.hasNext()) {
            i -= list.size();
            list = it.next();
        }
        if (i < list.size()) {
            return new MergedIndex(it.previousIndex(), i);
        }
        return null;
    }

    private class MergedIndex {
        public int globalIndex;
        public int localIndex;

        public MergedIndex(int globalIndex, int localIndex) {
            this.globalIndex = globalIndex;
            this.localIndex = localIndex;
        }
    }
}

