/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.util;

import java.util.Objects;
import java.util.OptionalInt;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="jobName", type="String", defaultValue="Runnable Named Job", flags=7)
public class BRunnableNamedJob
extends BJob {
    @Generated
    public static final Property jobName = BRunnableNamedJob.newProperty((int)7, (String)"Runnable Named Job", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRunnableNamedJob.class);
    protected Thread thread;
    protected Runnable action;
    private int priority;

    @Generated
    public String getJobName() {
        return this.getString(jobName);
    }

    @Generated
    public void setJobName(String v) {
        this.setString(jobName, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRunnableNamedJob() {
        this.priority = 5;
    }

    public BRunnableNamedJob(Runnable action) {
        this(action, 5);
    }

    public BRunnableNamedJob(Runnable action, int priority) {
        Objects.requireNonNull(action);
        this.action = action;
        this.priority = priority;
    }

    public void doRun(Context cx) {
        this.thread = new Thread(this.action, this.toPathString());
        this.thread.setPriority(this.priority);
        this.thread.start();
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    public String toString(Context cx) {
        return this.getJobName();
    }

    public OptionalInt getThreadPriority() {
        return this.thread == null ? OptionalInt.empty() : OptionalInt.of(this.thread.getPriority());
    }
}

