/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.util;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperty(name="maxConcurrentExecutions", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="DEFAULT_MIN_THREAD_POOL_SIZE")})
public abstract class BCloudPolicyContainer
extends BComponent {
    private static final int DEFAULT_MIN_THREAD_POOL_SIZE = 1;
    @Generated
    public static final Property maxConcurrentExecutions = BCloudPolicyContainer.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (int)1));
    @Generated
    public static final Type TYPE = Sys.loadType(BCloudPolicyContainer.class);
    private static final int DEFAULT_QUEUE_SIZE = 500;
    private static final int QUEUE_SIZE;
    protected Queue asyncWorkQueue;
    private ThreadPoolWorker worker;

    @Generated
    public int getMaxConcurrentExecutions() {
        return this.getInt(maxConcurrentExecutions);
    }

    @Generated
    public void setMaxConcurrentExecutions(int v) {
        this.setInt(maxConcurrentExecutions, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected abstract Type getChannelType();

    protected abstract Type[] getPolicyTypes();

    protected abstract String getWorkerThreadName();

    public abstract Logger getLogger();

    protected int getMinThreadPoolSize() {
        return 1;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent != null && parent.getType().is(this.getChannelType());
    }

    public final boolean isChildLegal(BComponent child) {
        if (child != null) {
            return Arrays.stream(this.getPolicyTypes()).anyMatch(arg_0 -> ((Type)child.getType()).is(arg_0));
        }
        return false;
    }

    public void started() throws Exception {
        super.started();
        int maxPoolSize = this.getMaxConcurrentExecutions();
        if (maxPoolSize < this.getMinThreadPoolSize()) {
            maxPoolSize = this.getMinThreadPoolSize();
        }
        if (this.asyncWorkQueue == null) {
            this.asyncWorkQueue = new CoalesceQueue(QUEUE_SIZE);
        }
        if (this.worker == null) {
            this.worker = new ThreadPoolWorker((Worker.ITodo)this.asyncWorkQueue);
        }
        if (!this.worker.isRunning()) {
            this.worker.setMaxThreads(maxPoolSize);
            this.worker.start(this.getWorkerThreadName());
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.worker != null && this.worker.isRunning()) {
            try {
                this.worker.stop();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, e, () -> String.format("Unable to stop ThreadPoolWorker for %s", this.getName()));
            }
        }
    }

    public void changed(Property property, Context cx) {
        if (this.isRunning() && maxConcurrentExecutions.equals(property) && this.worker != null) {
            int maxPoolSize = this.getMaxConcurrentExecutions();
            if (maxPoolSize < this.getMinThreadPoolSize()) {
                maxPoolSize = this.getMinThreadPoolSize();
            }
            this.worker.setMaxThreads(maxPoolSize);
        }
        super.changed(property, cx);
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning() && this.worker != null) {
            this.worker.spy(out);
        }
        super.spy(out);
    }

    static {
        int size = Integer.getInteger("cloudLink.policyContainer.workerQueueSize", 500);
        if (size < 1) {
            size = 500;
        }
        QUEUE_SIZE = size;
    }
}

