/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport.internal;

import com.microsoft.azure.proton.transport.proxy.impl.ProxyHandlerImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;

public class ProxyHandler
extends ProxyHandlerImpl {
    @Override
    public String createProxyRequest(String hostName, Map<String, String> additionalHeaders) {
        StringBuilder connectRequestBuilder = new StringBuilder();
        URI uri = null;
        try {
            uri = new URI(hostName);
        }
        catch (URISyntaxException e) {
            return super.createProxyRequest(hostName, additionalHeaders);
        }
        connectRequestBuilder.append(String.format(Locale.ROOT, "CONNECT %1$s HTTP/1.1%2$sHost: %1$s%2$sConnection: Keep-Alive%2$s", uri.getAuthority(), "\r\n"));
        if (additionalHeaders != null) {
            additionalHeaders.forEach((header, value) -> {
                connectRequestBuilder.append(String.format("%s: %s", header, value));
                connectRequestBuilder.append("\r\n");
            });
        }
        connectRequestBuilder.append("\r\n");
        return connectRequestBuilder.toString();
    }
}

