/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport.internal;

import com.tridium.cloudLink.transport.AmqpMessage;
import com.tridium.cloudLink.transport.internal.AmqpReceiverLinkHandler;
import com.tridium.cloudLink.transport.internal.IAmqpSessionHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Receiver;

public class AmqpAuthReceiverLinkHandler
extends AmqpReceiverLinkHandler {
    private Set<UUID> correlationSet;

    AmqpAuthReceiverLinkHandler(Receiver receiver, IAmqpSessionHandler parent) {
        super(receiver, UUID.randomUUID().toString(), parent);
        this.linkAddress = "$cbs";
        this.correlationSet = new HashSet<UUID>();
    }

    @Override
    public void onDelivery(Event event) {
        log.finest(event.toString());
        Receiver receiverLink = (Receiver)event.getLink();
        Delivery delivery = event.getDelivery();
        log.fine("Received a message on the CBS receiver link");
        this.handleCBSResponseMessage(receiverLink);
        if (delivery != null) {
            delivery.free();
        }
    }

    private void handleCBSResponseMessage(Receiver receiver) {
        AmqpMessage amqpMessage = this.getMessageFromReceiverLink(receiver);
        if (amqpMessage != null) {
            if (amqpMessage.getMetadata() != null && amqpMessage.getAmqpProperties() != null) {
                Properties properties = amqpMessage.getAmqpProperties();
                Object correlationId = properties.getCorrelationId();
                Map<String, Object> applicationProperties = amqpMessage.getMetadata();
                if (!this.correlationSet.remove(correlationId)) {
                    log.config("Received cbs authentication message with no correlation id. Ignoring it...");
                    amqpMessage.getDelivery().disposition(Released.getInstance());
                    amqpMessage.getDelivery().settle();
                    return;
                }
                for (Map.Entry<String, Object> entry : applicationProperties.entrySet()) {
                    String propertyKey = entry.getKey();
                    if (!propertyKey.equals("status-code") || !(entry.getValue() instanceof Integer)) continue;
                    int authenticationResponseCode = (Integer)entry.getValue();
                    String statusDescription = applicationProperties.containsKey("status-description") ? (String)applicationProperties.get("status-description") : "";
                    if (authenticationResponseCode == 200) {
                        this.parentSessionHandler.getClient().authenticated();
                    } else {
                        log.config(() -> String.format("Authentication failed: %d %s", authenticationResponseCode, statusDescription));
                    }
                    amqpMessage.getDelivery().disposition(Accepted.getInstance());
                    amqpMessage.getDelivery().settle();
                    return;
                }
            } else {
                log.config("Could not handle authentication message because it had no application properties or had no system properties");
            }
            amqpMessage.getDelivery().disposition(Released.getInstance());
            amqpMessage.getDelivery().settle();
        }
    }

    void addAuthenticationMessageCorrelation(UUID correlationId) {
        this.correlationSet.add(correlationId);
    }
}

