/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport;

import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public class MessageWrapper<T extends IMessage> {
    private CompletableFuture<IMessageResponse> messageFuture;
    private CompletableFuture<IMessageResponse> transportFuture;
    private final T message;
    private final String messageId;
    private final AtomicInteger retryCounter;
    private static final int DEFAULT_RETRY_COUNT = 3;

    public MessageWrapper(T message) {
        this(message, null, UUID.randomUUID().toString(), 3);
    }

    public MessageWrapper(T message, CompletableFuture<IMessageResponse> future) {
        this(message, future, UUID.randomUUID().toString(), 3);
    }

    public MessageWrapper(T message, CompletableFuture<IMessageResponse> future, int numRetries) {
        this(message, future, UUID.randomUUID().toString(), numRetries);
    }

    public MessageWrapper(T message, CompletableFuture<IMessageResponse> future, String messageId, int numRetries) {
        this.message = message;
        this.messageFuture = future;
        this.transportFuture = new CompletableFuture();
        this.messageId = messageId;
        this.retryCounter = new AtomicInteger(numRetries);
    }

    public CompletableFuture<IMessageResponse> getMessageFuture() {
        return this.messageFuture;
    }

    public void setMessageFuture(CompletableFuture<IMessageResponse> future) {
        this.messageFuture = future;
    }

    public CompletableFuture<IMessageResponse> getTransportFuture() {
        return this.transportFuture;
    }

    public T getMessage() {
        return this.message;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public boolean canRetry() {
        boolean retry;
        boolean bl = retry = this.retryCounter.decrementAndGet() >= 0;
        if (retry) {
            this.transportFuture = new CompletableFuture();
        }
        return retry;
    }
}

