/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.transport.IMessage;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.baja.security.BCertificateAliasAndPassword;

public class HttpRequestMessage
implements IMessage {
    private static final int BT_LENGTH_COMPARISON = 35;
    private static final int BT_PREFIX_LEN = 12;
    private static final int BT_SUFFIX_LEN = 25;
    private static final int BT_NONTOKEN_PREFIX_LEN = 12;
    private final HttpMethod method;
    private final URL url;
    private final String mimeType;
    private final Map<String, Object> requestHeaders;
    private final byte[] body;
    private final BCertificateAliasAndPassword certAliasAndPass;
    private final File fileToUpload;
    private final Consumer<OutputStream> contentSupplier;

    protected HttpRequestMessage(HttpRequestMessageBuilder builder) {
        this.method = builder.method;
        this.url = builder.url;
        this.requestHeaders = builder.requestHeaders;
        this.mimeType = builder.mimeType;
        this.certAliasAndPass = builder.certAliasAndPass;
        this.body = builder.body;
        this.fileToUpload = builder.fileToUpload;
        this.contentSupplier = builder.contentSupplier;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Map<String, Object> getRequestHeaders() {
        return Collections.unmodifiableMap(this.requestHeaders);
    }

    public boolean hasBody() {
        return this.body != null || this.contentSupplier != null || this.fileToUpload != null;
    }

    public boolean isBodyStreamed() {
        return this.contentSupplier != null;
    }

    public boolean isFileUpload() {
        return this.fileToUpload != null;
    }

    public String getBody() {
        return this.body != null ? new String(this.body, StandardCharsets.UTF_8) : null;
    }

    public Consumer<OutputStream> getBodyStream() {
        return this.contentSupplier;
    }

    public File getFileToUpload() {
        return this.fileToUpload;
    }

    @Override
    public int getLength() {
        if (this.body != null) {
            return this.body.length;
        }
        return 0;
    }

    @Override
    public byte[] getPayload() {
        return this.body != null ? this.body : CloudLinkConstants.EMPTY_BYTES;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.getRequestHeaders();
    }

    public Optional<BCertificateAliasAndPassword> getCertificateAliasAndPassword() {
        return Optional.ofNullable(this.certAliasAndPass);
    }

    public String toString() {
        String sb = String.valueOf((Object)this.method) + ' ' + this.url + ' ' + this.mimeType + "\n  hdrs:" + this.safeHdrs() + '\n' + this.getBody();
        return sb;
    }

    private String safeHdrs() {
        Iterator<Map.Entry<String, Object>> i = this.requestHeaders.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<String, Object> e = i.next();
            String key = e.getKey();
            Object value = e.getValue();
            sb.append(key).append('=');
            if ("Authorization".equals(key)) {
                String s = Objects.toString(value);
                int slen = s.length();
                if (slen > 35) {
                    sb.append(s, 0, 12).append("...").append(s.substring(slen - 25));
                } else {
                    sb.append(s, 0, Math.min(12, slen)).append("...");
                }
            } else {
                sb.append(value);
            }
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public static class HttpRequestMessageBuilder {
        private final HttpMethod method;
        private final URL url;
        private final Map<String, Object> requestHeaders;
        private String mimeType;
        private BCertificateAliasAndPassword certAliasAndPass;
        private byte[] body;
        private File fileToUpload;
        private Consumer<OutputStream> contentSupplier;

        public HttpRequestMessageBuilder(HttpMethod method, URL url, Map<String, Object> requestHeaders) {
            Objects.requireNonNull(url, "HttpRequestMessage: url must not be null");
            this.method = method;
            this.url = url;
            this.requestHeaders = requestHeaders == null ? new HashMap<String, Object>() : new HashMap<String, Object>(requestHeaders);
        }

        public HttpRequestMessageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public HttpRequestMessageBuilder certificateAliasAndPassword(BCertificateAliasAndPassword certAliasAndPass) {
            this.certAliasAndPass = certAliasAndPass;
            return this;
        }

        public HttpRequestMessageBuilder body(String body) {
            this.body = body.getBytes(StandardCharsets.UTF_8);
            this.fileToUpload = null;
            this.contentSupplier = null;
            return this;
        }

        public HttpRequestMessageBuilder body(byte[] body) {
            this.body = (byte[])body.clone();
            this.fileToUpload = null;
            this.contentSupplier = null;
            return this;
        }

        public HttpRequestMessageBuilder fileToUpload(File fileToUpload) {
            this.fileToUpload = fileToUpload;
            this.body = null;
            this.contentSupplier = null;
            return this;
        }

        public HttpRequestMessageBuilder contentSupplier(Consumer<OutputStream> contentSupplier) {
            this.contentSupplier = contentSupplier;
            this.body = null;
            this.fileToUpload = null;
            return this;
        }

        public HttpRequestMessage build() {
            return new HttpRequestMessage(this);
        }
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH,
        OPTIONS,
        HEAD,
        CONNECT,
        TRACE;

    }
}

