/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.tag;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.command.BCloudWriteInfo;
import com.tridium.cloudLink.tag.BMaxOverrideTag;
import com.tridium.tagdictionary.condition.BIsTypeCondition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.control.BControlPoint;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.data.BIDataValue;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BLink;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.Tag;
import javax.baja.tagdictionary.BTagInfo;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="strict", type="boolean", defaultValue="false", flags=7), @NiagaraProperty(name="excluded", type="BString", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="validity", type="BTagRuleCondition", defaultValue="new BIsTypeCondition(BIWritablePoint.TYPE)", flags=3, override=true)})
public class BWritablePriorityLevelsTag
extends BTagInfo
implements IPropertyValidator {
    @Generated
    public static final Property strict = BWritablePriorityLevelsTag.newProperty((int)7, (boolean)false, null);
    @Generated
    public static final Property excluded = BWritablePriorityLevelsTag.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property validity = BWritablePriorityLevelsTag.newProperty((int)3, (BValue)new BIsTypeCondition(BIWritablePoint.TYPE), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWritablePriorityLevelsTag.class);
    private static final BPriorityLevel[] staticLevels = new BPriorityLevel[]{BPriorityLevel.DEFAULT, BPriorityLevel.level_1, BPriorityLevel.level_2, BPriorityLevel.level_3, BPriorityLevel.level_4, BPriorityLevel.level_5, BPriorityLevel.level_6, BPriorityLevel.level_7, BPriorityLevel.level_8, BPriorityLevel.level_9, BPriorityLevel.level_10, BPriorityLevel.level_11, BPriorityLevel.level_12, BPriorityLevel.level_13, BPriorityLevel.level_14, BPriorityLevel.level_15, BPriorityLevel.level_16};
    static final Logger log = Logger.getLogger("cloudLink.tag");
    public static final String SEPARATOR = ",";

    @Generated
    public boolean getStrict() {
        return this.getBoolean(strict);
    }

    @Generated
    public void setStrict(boolean v) {
        this.setBoolean(strict, v, null);
    }

    @Generated
    public String getExcluded() {
        return this.getString(excluded);
    }

    @Generated
    public void setExcluded(String v) {
        this.setString(excluded, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIDataValue getDefaultValue() {
        return BString.DEFAULT;
    }

    public Tag getTag(Entity entity) {
        if (!TagUtil.hasCloudId((BIEntity)((BIEntity)entity))) {
            return null;
        }
        ArrayList<String> levels = new ArrayList<String>();
        List<Object> xlist = new ArrayList();
        if (!this.getExcluded().isEmpty()) {
            xlist = Arrays.stream(this.getExcluded().split(SEPARATOR)).map(Integer::parseInt).collect(Collectors.toList());
        }
        if (entity instanceof BIWritablePoint) {
            BIWritablePoint pt = (BIWritablePoint)entity;
            for (int i = 2; i <= 16; ++i) {
                BPriorityLevel priorityLevel = staticLevels[i];
                try {
                    BStatusValue inStatusValue = pt.getInStatusValue(priorityLevel);
                    if (inStatusValue == null) continue;
                    Property inProp = pt.getInProperty(priorityLevel);
                    BLink[] links = ((BComponent)pt).getLinks((Slot)inProp);
                    Optional<BLink> link = Arrays.stream(links).filter(l -> BWritablePriorityLevelsTag.isUsed(l)).findFirst();
                    if (link.isPresent() || xlist.contains(i)) {
                        if (!this.getStrict()) continue;
                        levels.clear();
                        continue;
                    }
                    if (entity instanceof BIBoolean && i == 6) continue;
                    levels.add(String.valueOf(i));
                    continue;
                }
                catch (RuntimeException e) {
                    log.finest(String.format("Cannot access priority level %d of writable %s.", i, pt));
                }
            }
        } else if (entity instanceof BControlPoint && BMaxOverrideTag.isOverridable((BControlPoint)entity) && !xlist.contains(8)) {
            levels.add("8");
        }
        return new Tag(this.getTagId(), (BIDataValue)BString.make((String)String.join((CharSequence)SEPARATOR, levels)));
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        log.finest(() -> "Validating single property " + property.getDefaultDisplayName(context));
        BComponentSpace compSpace = this.getParentComponent().getComponentSpace();
        if (property.getName().equals(excluded.getName()) && (compSpace == null || !compSpace.isProxyComponentSpace())) {
            return this;
        }
        return null;
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        log.finest(() -> {
            StringBuilder logMsgBuilder = new StringBuilder();
            logMsgBuilder.append("Validating multiple properties: ");
            for (Property p : properties) {
                logMsgBuilder.append(" property: ");
                logMsgBuilder.append(p.getDefaultDisplayName(context));
            }
            return logMsgBuilder.toString();
        });
        BComponentSpace compSpace = this.getParentComponent().getComponentSpace();
        if (compSpace == null || !compSpace.isProxyComponentSpace()) {
            return this;
        }
        return null;
    }

    public void validateSet(Validatable validatable, Context context) {
        BString newValue = (BString)validatable.getProposedValue(excluded);
        try {
            String v = newValue.encodeToString();
            if (v.isEmpty()) {
                return;
            }
            List levels = Arrays.stream(v.split(SEPARATOR)).map(Integer::parseInt).collect(Collectors.toList());
            for (Integer l : levels) {
                if (l >= 2 && l <= 16) continue;
                throw new IllegalArgumentException("Illegal level " + l);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            log.warning("Invalid format of priority level list: " + this.getExcluded());
            throw new LocalizableRuntimeException("cloudLink", "tag.levels.format");
        }
    }

    private static boolean isUsed(BLink l) {
        BComponent source = null;
        try {
            source = l.getSourceComponent();
        }
        catch (UnresolvedException unresolvedException) {
            // empty catch block
        }
        return l.isInbound() && l.isEnabled() && !(source instanceof BCloudWriteInfo);
    }
}

