/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.tag;

import com.tridium.cloudLink.tag.CloudLinkTagUtil;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Tag;
import javax.baja.tagdictionary.BTagInfo;

@NiagaraType
public class BDataTypeTag
extends BTagInfo {
    @Generated
    public static final Type TYPE = Sys.loadType(BDataTypeTag.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIDataValue getDefaultValue() {
        return BString.DEFAULT;
    }

    public Tag getTag(Entity entity) {
        String dataType = "other";
        try {
            if (entity instanceof BControlPoint) {
                dataType = this.getDataType((BControlPoint)entity);
            } else if (entity instanceof BHistoryExt) {
                BControlPoint parent = ((BHistoryExt)entity).getParentPoint();
                if (parent == null) {
                    CloudLinkTagUtil.log.config("Unable to locate history extension parent point.");
                    return null;
                }
                dataType = this.getDataType(parent);
            }
            return new Tag(this.getTagId(), (BIDataValue)BString.make((String)dataType));
        }
        catch (Exception e) {
            CloudLinkTagUtil.log.info(String.format("Could not encode dataType tag value on %s: %s", entity, e.getMessage()));
            return null;
        }
    }

    protected String getDataType(BControlPoint point) {
        BStatusValue sv = point.getOutStatusValue();
        if (sv == null) {
            return "other";
        }
        BValue value = sv.getValueValue();
        if (value instanceof BINumeric) {
            return "numeric";
        }
        if (value instanceof BIBoolean) {
            return "boolean";
        }
        if (value instanceof BIEnum) {
            return "enum";
        }
        if (value instanceof BString) {
            return "string";
        }
        return "other";
    }
}

