/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.tag;

import com.tridium.cloudLink.tag.common.BLookupAttributeType;
import com.tridium.cloudLink.tag.common.BLookupType;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMarker;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tagdictionary.BTagInfo;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="entityLookupAttribute", type="BLookupAttributeType", defaultValue="BLookupAttributeType.entityObject"), @NiagaraProperty(name="lookupType", type="BLookupType", defaultValue="BLookupType.equalityCheck"), @NiagaraProperty(name="lookupTable", type="BFacets", defaultValue="BFacets.DEFAULT"), @NiagaraProperty(name="subPropertyPath", type="String", defaultValue="")})
public class BCustomLookupTag
extends BTagInfo {
    @Generated
    public static final Property entityLookupAttribute = BCustomLookupTag.newProperty((int)0, (BValue)BLookupAttributeType.entityObject, null);
    @Generated
    public static final Property lookupType = BCustomLookupTag.newProperty((int)0, (BValue)BLookupType.equalityCheck, null);
    @Generated
    public static final Property lookupTable = BCustomLookupTag.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Property subPropertyPath = BCustomLookupTag.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCustomLookupTag.class);
    private static final CharSequence DELIMIER = ".";
    private static final String REGEX_DELIMIER = "\\.";
    public static final String[] STRINGS = new String[0];

    @Generated
    public BLookupAttributeType getEntityLookupAttribute() {
        return (BLookupAttributeType)this.get(entityLookupAttribute);
    }

    @Generated
    public void setEntityLookupAttribute(BLookupAttributeType v) {
        this.set(entityLookupAttribute, (BValue)v, null);
    }

    @Generated
    public BLookupType getLookupType() {
        return (BLookupType)this.get(lookupType);
    }

    @Generated
    public void setLookupType(BLookupType v) {
        this.set(lookupType, (BValue)v, null);
    }

    @Generated
    public BFacets getLookupTable() {
        return (BFacets)this.get(lookupTable);
    }

    @Generated
    public void setLookupTable(BFacets v) {
        this.set(lookupTable, (BValue)v, null);
    }

    @Generated
    public String getSubPropertyPath() {
        return this.getString(subPropertyPath);
    }

    @Generated
    public void setSubPropertyPath(String v) {
        this.setString(subPropertyPath, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIDataValue getDefaultValue() {
        return BString.DEFAULT;
    }

    public Tag getTag(Entity entity) {
        BValue attribute = this.getKeyAttribute((BComponent)entity);
        if (attribute == null) {
            return null;
        }
        String lookupValue = this.getLookupValue(attribute);
        return lookupValue != null ? new Tag(Id.newId((String)lookupValue), (BIDataValue)BMarker.MARKER) : null;
    }

    private String getLookupValue(BValue attribute) {
        for (String key : this.getLookupTable().list()) {
            String unescapedKey = SlotPath.unescape((String)key);
            if (!this.isMappingMatch(attribute, unescapedKey)) continue;
            return this.getLookupTable().gets(key, null);
        }
        return null;
    }

    private boolean isMappingMatch(BValue attribute, String unescapedKey) {
        switch (this.getLookupType().getOrdinal()) {
            case 0: {
                return BCustomLookupTag.doEqualityCheck(attribute, unescapedKey);
            }
            case 1: {
                return BCustomLookupTag.doTypeCheck(attribute, unescapedKey);
            }
            case 2: {
                return BCustomLookupTag.doStringStartsWithCheck(attribute, unescapedKey);
            }
        }
        return false;
    }

    private static boolean doStringStartsWithCheck(BValue attribute, String unescapedKey) {
        return BCustomLookupTag.getStringValue(attribute).startsWith(unescapedKey);
    }

    private static boolean doTypeCheck(BValue attribute, String unescapedKey) {
        return attribute.getType().is(BTypeSpec.make((String)unescapedKey).getTypeInfo());
    }

    private static String getStringValue(BValue attribute) {
        return attribute instanceof BEnum ? ((BEnum)attribute).getTag() : attribute.toString();
    }

    private static boolean doEqualityCheck(BValue attribute, String unescapedKey) {
        return BCustomLookupTag.getStringValue(attribute).equals(unescapedKey);
    }

    private BValue getKeyAttribute(BComponent entity) {
        if (this.getEntityLookupAttribute() == BLookupAttributeType.entitySubProperty) {
            String[] subProps = this.getSubPropertyArray();
            BComponent parent = entity;
            BValue property = null;
            entity.lease(subProps.length + 1, 3000L);
            for (String propertyName : subProps) {
                if (!parent.isComplex()) {
                    throw new IllegalArgumentException("Cant find property on entity " + entity.getSlotPathOrd() + " as per sub path " + this.getSubPropertyPath());
                }
                property = ((BComplex)parent).get(propertyName);
                parent = property;
            }
            return property;
        }
        return entity;
    }

    private String[] getSubPropertyArray() {
        String path = this.getSubPropertyPath();
        if (path.trim().isEmpty()) {
            return STRINGS;
        }
        if (path.contains(DELIMIER)) {
            return path.split(REGEX_DELIMIER);
        }
        return new String[]{path};
    }
}

