/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.security;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.BCertificateAliasAndPassword;

public class FederatedIdentityAccessTokenRequest
implements IMessageBuilder {
    private final BCertificateAliasAndPassword certAliasAndPass;
    private final String urlString;
    private static final String GRANT_TYPE = "grantType";
    private static final String GRANT_TYPE_MTLS = "mtls";
    private static final String SCOPE = "scope";
    private static final String SCOPE_FOXWSS = "foxwss";
    private static final Logger log = Logger.getLogger("cloudLink.auth.federated");
    private static final String API_PATH = "/api/v1/accesstoken/devices/%s/token";

    public FederatedIdentityAccessTokenRequest(String server, String deviceId, BCertificateAliasAndPassword certAliasAndPass) {
        this.urlString = String.format("https://" + server + API_PATH, deviceId);
        this.certAliasAndPass = certAliasAndPass;
    }

    @Override
    public IMessage toMessage(boolean isFinal) {
        URL url = null;
        try {
            url = new URI(this.urlString).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            log.log(Level.WARNING, "Unable to build URL for access token request", log.isLoggable(Level.FINE) ? ex : null);
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending federated identity token request with correlation " + correlationId);
        StringWriter stringWriter = new StringWriter();
        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)stringWriter);
        jsonSerializer.object();
        jsonSerializer.key(GRANT_TYPE).value((Object)GRANT_TYPE_MTLS);
        jsonSerializer.key(SCOPE).value((Object)SCOPE_FOXWSS);
        jsonSerializer.endObject();
        stringWriter.flush();
        HashMap<String, Object> requestHeaders = new HashMap<String, Object>();
        requestHeaders.put("x-activity-id", correlationId);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, requestHeaders).certificateAliasAndPassword(this.certAliasAndPass).mimeType("application/json").body(stringWriter.toString()).build();
    }
}

