/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.security;

import com.tridium.cloudLink.security.BCloudAuthenticationScheme;
import com.tridium.cloudLink.security.BCloudRoleMappings;
import com.tridium.cloudLink.security.BRoleMapping;
import com.tridium.cloudLink.security.CloudCallback;
import com.tridium.cloudLink.util.LruLinkedHashMap;
import java.security.AccessController;
import java.security.Principal;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.authn.AuthenticationUtil;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

public class CloudLoginModule
implements LoginModule {
    private BCloudAuthenticationScheme scheme;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean succeeded;
    private boolean commitSucceeded;
    private BUser user;
    private static final LruLinkedHashMap<String, BComponent> users = new LruLinkedHashMap(100);
    private final Lexicon lexicon = Lexicon.make((String)"cloudLink");

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.scheme = (BCloudAuthenticationScheme)((Object)options.get("scheme"));
    }

    @Override
    public boolean login() throws LoginException {
        String messageId;
        String expectedDeviceId;
        String auth;
        String appId;
        if (this.callbackHandler == null) {
            throw new FailedLoginException("CallbackHandler cannot be null");
        }
        Callback[] callbacks = new Callback[]{new CloudCallback()};
        try {
            this.callbackHandler.handle(callbacks);
            appId = ((CloudCallback)callbacks[0]).getAppId();
            auth = ((CloudCallback)callbacks[0]).getJwt();
            expectedDeviceId = ((CloudCallback)callbacks[0]).getDeviceId();
            messageId = ((CloudCallback)callbacks[0]).getMessageId();
        }
        catch (UnsupportedCallbackException e) {
            String msg = "Provided callback handler could not handle: " + e.getCallback().toString();
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)e);
            throw new FailedLoginException(msg);
        }
        catch (Exception e) {
            String msg = "Error handling callbacks:" + e.toString();
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)e);
            throw new FailedLoginException(msg);
        }
        if (auth != null) {
            AuthenticationUtil.debug((Level)Level.FINE, (String)("Attempting cloudLink authentication with JWT " + messageId), null);
            VerificationKeyResolver resolver = this.scheme.getTrustManager().getKeyResolver(appId);
            if (resolver == null) {
                AuthenticationUtil.debug((Level)Level.WARNING, (String)String.format("No key resolver found for appId: %s %s", appId, messageId), null);
                throw new FailedLoginException("Cloud user authentication failed");
            }
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setRequireNotBefore().setAllowedClockSkewInSeconds(30).setExpectedAudience(new String[]{this.scheme.getTrustManager().getExpectedAudience(appId)}).setExpectedIssuer(this.scheme.getTrustManager().getExpectedIssuer(appId)).setVerificationKeyResolver(resolver).setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"RS256", "ES256"})).build();
            try {
                BUser user;
                JwtClaims claims = jwtConsumer.processToClaims(auth);
                String deviceId = (String)claims.getClaimValue("deviceid", String.class);
                if (deviceId != null && expectedDeviceId != null && !deviceId.equals(expectedDeviceId)) {
                    AuthenticationUtil.debug((Level)Level.WARNING, (String)String.format("Requested DeviceId %s does not match %s %s", deviceId, expectedDeviceId, messageId), null);
                    throw new FailedLoginException("DeviceId does not match");
                }
                String subject = claims.getSubject();
                if (subject == null) {
                    AuthenticationUtil.debug((Level)Level.WARNING, (String)("JWT missing subject claim " + messageId), null);
                    throw new FailedLoginException("JWT missing subject claim");
                }
                String mappedRoles = null;
                String stationRole = claims.getClaimValueAsString("stationrole");
                if (stationRole != null && !stationRole.isEmpty()) {
                    mappedRoles = stationRole;
                } else {
                    BCloudRoleMappings roleMappings;
                    String roles = (String)claims.getClaimValue("cloudroles", String.class);
                    if (roles == null || roles.isEmpty()) {
                        Map customAttributes = (Map)claims.getClaimValue("custom_attributes", Map.class);
                        String string = roles = customAttributes != null ? (String)customAttributes.get("cloudroles") : null;
                        if (roles == null || roles.isEmpty()) {
                            AuthenticationUtil.debug((Level)Level.WARNING, (String)("JWT missing or empty roles claim " + messageId), null);
                            throw new FailedLoginException(this.lexicon.getText("noRoleClaimsError"));
                        }
                    }
                    if (((BRoleMapping[])(roleMappings = this.scheme.getRoleMappings()).getChildren(BRoleMapping.class)).length == 0) {
                        AuthenticationUtil.debug((Level)Level.WARNING, (String)("No role mappings found " + messageId), null);
                        throw new FailedLoginException(this.lexicon.getText("noRoleMappingsError"));
                    }
                    mappedRoles = roleMappings.mapCloudRoles(roles);
                    if (mappedRoles == null || mappedRoles.isEmpty()) {
                        AuthenticationUtil.debug((Level)Level.WARNING, (String)("JWT roles claim does not match any mapped roles " + messageId), null);
                        throw new FailedLoginException(this.lexicon.getText("noRoleMatchError"));
                    }
                }
                String fullName = (String)claims.getClaimValue("username", String.class);
                AuthenticationUtil.debug((Level)Level.FINE, (String)("JWT verification succeeded " + messageId), null);
                String username = SlotPath.escape((String)("cloudLink:" + subject + ':' + mappedRoles));
                BComponent parent = (BComponent)users.get(username);
                if (parent == null) {
                    AuthenticationUtil.debug((Level)Level.FINE, (String)String.format("Cached user not found, creating new user %s %s", username, messageId), null);
                    user = new BUser();
                    user.setRoles(mappedRoles);
                    parent = new BComponent();
                    parent.add(username, (BValue)user);
                    users.put(username, parent);
                } else {
                    user = (BUser)parent.get(username);
                    AuthenticationUtil.debug((Level)Level.FINE, (String)String.format("Authenticating as cached user %s %s", username, messageId), null);
                }
                user.setFullName(fullName != null ? fullName : "");
                user.setPermissions(user.getRoleBasedPermissions());
                this.user = user;
                this.succeeded = true;
                return true;
            }
            catch (MalformedClaimException | InvalidJwtException e) {
                AuthenticationUtil.debug((Level)Level.WARNING, (String)("JWT verification failed " + messageId), (Throwable)e);
                throw new FailedLoginException("Cloud user authentication failed: JWT verification failed");
            }
        }
        AuthenticationUtil.debug((Level)Level.FINE, (String)("Attempting cloud authentication with AppId " + messageId), null);
        if (!this.scheme.getUserMappings().getEnabled()) {
            AuthenticationUtil.debug((Level)Level.WARNING, (String)("Cloud User mappings are disabled " + messageId), null);
            throw new FailedLoginException("Cloud user mappings disabled");
        }
        BUser user = this.scheme.getUserMappings().getUser(appId);
        if (user == null) {
            AuthenticationUtil.debug((Level)Level.WARNING, (String)String.format("No user mapping found for appId: %s %s", appId, messageId), null);
            throw new FailedLoginException("Cloud user authentication failed");
        }
        AuthenticationUtil.debug((Level)Level.FINE, (String)String.format("Found user mapping to user %s %s", user.getName(), messageId), null);
        if (!user.getAuthenticationSchemeName().equals(this.scheme.getName())) {
            AuthenticationUtil.debug((Level)Level.WARNING, (String)String.format("Wrong authentication for user %s. Expected %s but found %s %s", user.getName(), this.scheme.getName(), user.getAuthenticationSchemeName(), messageId), null);
            throw new FailedLoginException("Cloud user authentication failed");
        }
        BUserService service = BUserService.getService();
        if (!service.canLogin(user)) {
            AuthenticationUtil.debug((Level)Level.WARNING, (String)String.format("User cannot login: %s. User is disabled, locked out, or expired %s", user.getName(), messageId), null);
            throw new FailedLoginException("Cloud user authentication failed");
        }
        this.user = user;
        this.succeeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        return AccessController.doPrivileged(() -> {
            this.subject.getPrincipals().add((Principal)this.user);
            this.commitSucceeded = true;
            return true;
        });
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (!this.commitSucceeded) {
            this.succeeded = false;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return AccessController.doPrivileged(() -> {
            if (this.user != null) {
                this.subject.getPrincipals().remove(this.user);
            }
            this.succeeded = false;
            this.commitSucceeded = false;
            this.user = null;
            return true;
        });
    }
}

